/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.pathfinder.utils.geometry;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.locationtech.jts.algorithm.ConvexHull;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.math.Vector2D;
import org.locationtech.jts.math.Vector3D;

public class JTSUtility {
    public static final double TRIANGLE_INTERSECTION_EPSILON = 1.0E-7;

    private JTSUtility() {
    }

    private static double[] distance3D(Coordinate p1, Coordinate p2, Coordinate point) {
        double[] DistanceInfo = new double[2];
        double x1 = p1.getX();
        double y1 = p1.getY();
        double z1 = p1.getZ();
        double x2 = p2.getX();
        double y2 = p2.getY();
        double z2 = p2.getZ();
        double x0 = point.getX();
        double y0 = point.getY();
        double z0 = point.getZ();
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        double px = x0 - x1;
        double py = y0 - y1;
        double pz = z0 - z1;
        double dotProduct = dx * px + dy * py + dz * pz;
        double t = dotProduct / (dx * dx + dy * dy + dz * dz);
        double closestX = x1 + t * dx;
        double closestY = y1 + t * dy;
        double closestZ = z1 + t * dz;
        double distance = Math.sqrt((x0 - closestX) * (x0 - closestX) + (y0 - closestY) * (y0 - closestY) + (z0 - closestZ) * (z0 - closestZ));
        double sign = z0 - closestZ;
        DistanceInfo[0] = distance;
        DistanceInfo[1] = sign;
        return DistanceInfo;
    }

    public static double[] getLinearFunction(Coordinate p1, Coordinate p2) {
        if (Double.compare(p1.x, p2.x) == 0) {
            throw new IllegalArgumentException("X value must be different to compute linear function parameters");
        }
        double a = (p2.y - p1.y) / (p2.x - p1.x);
        double b = (p2.x * p1.y - p1.x * p2.y) / (p2.x - p1.x);
        return new double[]{a, b};
    }

    public static Coordinate getNearestPoint(LineSegment segment, Coordinate p) {
        double segmentLengthFraction = Math.min(1.0, Math.max(0.0, segment.projectionFactor(p)));
        return new Coordinate(segment.p0.x + segmentLengthFraction * (segment.p1.x - segment.p0.x), segment.p0.y + segmentLengthFraction * (segment.p1.y - segment.p0.y), segment.p0.z + segmentLengthFraction * (segment.p1.z - segment.p0.z));
    }

    public static Coordinate getNearestPoint(Coordinate from, LineString to) {
        Coordinate[] coordinates = to.getCoordinates();
        Coordinate closestPoint = null;
        double closestPointDistance = Double.MAX_VALUE;
        for (int i = 0; i < coordinates.length - 1; ++i) {
            Coordinate a = coordinates[i];
            Coordinate b = coordinates[i + 1];
            Coordinate closestPointOnSegment = JTSUtility.getNearestPoint(new LineSegment(a, b), from);
            double closestPointOnSegmentDistance = closestPointOnSegment.distance3D(from);
            if (closestPoint != null && !(closestPointOnSegmentDistance < closestPointDistance)) continue;
            closestPoint = closestPointOnSegment;
            closestPointDistance = closestPointOnSegmentDistance;
        }
        return closestPoint;
    }

    public static double[] getLinearRegressionPolyline(List<Coordinate> xzList) {
        SimpleRegression simpleRegression = new SimpleRegression();
        for (Coordinate p : xzList) {
            simpleRegression.addData(p.x, p.y);
        }
        return new double[]{simpleRegression.getSlope(), simpleRegression.getIntercept()};
    }

    public static Coordinate makeProjectedPoint(double a, double b, Coordinate point) {
        LineSegment plane = new LineSegment(new Coordinate(point.x - 1.0, a * (point.x - 1.0) + b), new Coordinate(point.x + 1.0, a * (point.x + 1.0) + b));
        return plane.project(point);
    }

    public static Coordinate makePointImage(double a, double b, Coordinate point) {
        LineSegment pointPlane = new LineSegment(point, JTSUtility.makeProjectedPoint(a, b, point));
        return pointPlane.pointAlong(2.0);
    }

    public static boolean dotInTri(Coordinate p, Coordinate a, Coordinate b, Coordinate c) {
        return JTSUtility.dotInTri(p, a, b, c, null);
    }

    public static Vector3D getTriangleNormal(Coordinate p1, Coordinate p2, Coordinate p3) {
        Vector3D a = new Vector3D(p1, p2);
        Vector3D b = new Vector3D(p1, p3);
        return new Vector3D(a.getY() * b.getZ() - a.getZ() * b.getY(), a.getZ() * b.getX() - a.getX() * b.getZ(), a.getX() * b.getY() - a.getY() * b.getX()).normalize();
    }

    public static boolean dotInTri(Coordinate p, Coordinate a, Coordinate b, Coordinate c, AtomicReference<Double> error) {
        Vector2D v0 = new Vector2D(c.x - a.x, c.y - a.y);
        Vector2D v1 = new Vector2D(b.x - a.x, b.y - a.y);
        Vector2D v2 = new Vector2D(p.x - a.x, p.y - a.y);
        double dot00 = v0.dot(v0);
        double dot01 = v0.dot(v1);
        double dot02 = v0.dot(v2);
        double dot11 = v1.dot(v1);
        double dot12 = v1.dot(v2);
        double invDenom = 1.0 / (dot00 * dot11 - dot01 * dot01);
        double u = (dot11 * dot02 - dot01 * dot12) * invDenom;
        double v = (dot00 * dot12 - dot01 * dot02) * invDenom;
        if (error != null) {
            double err = 0.0;
            err += Math.max(0.0, -u);
            err += Math.max(0.0, -v);
            error.set(err += Math.max(0.0, u + v - 1.0));
        }
        return u > -1.0E-7 && v > -1.0E-7 && u + v < 1.0000001;
    }

    public static List<Coordinate> getNewCoordinateSystem(List<Coordinate> listPoints) {
        return JTSUtility.getNewCoordinateSystem(listPoints, 0.0);
    }

    public static List<Coordinate> getNewCoordinateSystem(List<Coordinate> listPoints, double tolerance) {
        int idPoint;
        if (listPoints.isEmpty()) {
            return new ArrayList<Coordinate>();
        }
        ArrayList<Coordinate> newCoord = new ArrayList<Coordinate>(listPoints.size());
        newCoord.add(new Coordinate(0.0, listPoints.get((int)0).z));
        for (idPoint = 1; idPoint < listPoints.size(); ++idPoint) {
            Coordinate pt = listPoints.get(idPoint);
            newCoord.add(new Coordinate(((Coordinate)newCoord.get((int)(idPoint - 1))).x + pt.distance(listPoints.get(idPoint - 1)), pt.z));
        }
        if (tolerance > 0.0) {
            idPoint = 1;
            while (idPoint < newCoord.size() - 1) {
                Coordinate previous = (Coordinate)newCoord.get(idPoint - 1);
                Coordinate current = (Coordinate)newCoord.get(idPoint);
                Coordinate next = (Coordinate)newCoord.get(idPoint + 1);
                LineSegment lineSegment = new LineSegment(previous, next);
                if (lineSegment.distance(current) < tolerance) {
                    newCoord.remove(idPoint);
                    continue;
                }
                ++idPoint;
            }
        }
        return newCoord;
    }

    public static List<Coordinate> getOldCoordinateSystemList(List<Coordinate> listPoints, double angle) {
        ArrayList<Coordinate> newCoord = new ArrayList<Coordinate>(listPoints.size());
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        for (Coordinate listPoint : listPoints) {
            double newX = (listPoint.x - listPoints.get((int)(listPoints.size() - 1)).x) * -cos;
            double newY = (listPoint.x - listPoints.get((int)(listPoints.size() - 1)).x) * sin;
            newCoord.add(new Coordinate(newX, newY, listPoint.y));
        }
        return newCoord;
    }

    public static Coordinate getOldCoordinateSystem(Coordinate Point2, double angle) {
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        return new Coordinate(Point2.x * cos, Point2.x * sin, Point2.y);
    }

    public static double[] getMeanPlaneCoefficients(Coordinate[] profile) {
        int n = profile.length - 1;
        if (n == 0) {
            return new double[]{0.0, profile[0].y};
        }
        double valA1 = 0.0;
        double valA2 = 0.0;
        double valB1 = 0.0;
        double valB2 = 0.0;
        for (int i = 0; i < n; ++i) {
            Coordinate p1 = profile[i];
            Coordinate p2 = profile[i + 1];
            double dx = p2.x - p1.x;
            if (!(dx > 0.0)) continue;
            double ai = (p2.y - p1.y) / dx;
            double bi = p1.y - ai * p1.x;
            double vald2 = Math.pow(p2.x, 2.0) - Math.pow(p1.x, 2.0);
            double vald3 = Math.pow(p2.x, 3.0) - Math.pow(p1.x, 3.0);
            valA1 += ai * vald3;
            valA2 += bi * vald2;
            valB1 += ai * vald2;
            valB2 += bi * dx;
        }
        double valA = 0.6666666666666666 * valA1 + valA2;
        double valB = valB1 + 2.0 * valB2;
        double dist3 = Math.pow(profile[n].x - profile[0].x, 3.0);
        double dist4 = Math.pow(profile[n].x - profile[0].x, 4.0);
        double A = 3.0 * (2.0 * valA - valB * (profile[n].x + profile[0].x)) / dist3;
        double B = 2.0 * valB * (Math.pow(profile[n].x, 3.0) - Math.pow(profile[0].x, 3.0)) / dist4 - 3.0 * valA * (profile[n].x + profile[0].x) / dist3;
        return new double[]{A, B};
    }

    public static List<Coordinate> getXAscendingHullPoints(Coordinate[] coordinates) {
        int i;
        ConvexHull convexHull = new ConvexHull(coordinates, new GeometryFactory());
        Geometry hullGeom = convexHull.getConvexHull();
        Coordinate[] hull = hullGeom.getCoordinates();
        if (hull.length > 3 && Orientation.isCCW((Coordinate[])hull)) {
            for (int i2 = 0; i2 < hull.length / 2; ++i2) {
                Coordinate temp = hull[i2];
                hull[i2] = hull[hull.length - 1 - i2];
                hull[hull.length - 1 - i2] = temp;
            }
        }
        int index = -1;
        double minX = Double.MAX_VALUE;
        for (int i3 = 0; i3 < hull.length; ++i3) {
            if (!(hull[i3].x < minX)) continue;
            index = i3;
            minX = hull[i3].x;
        }
        ArrayList<Coordinate> offsetHull = new ArrayList<Coordinate>(hull.length);
        double lastX = Double.NEGATIVE_INFINITY;
        for (i = index; i < hull.length && hull[i].x > lastX; ++i) {
            offsetHull.add(hull[i]);
            lastX = hull[i].x;
        }
        for (i = 0; i < index && hull[i].x > lastX; ++i) {
            offsetHull.add(hull[i]);
            lastX = hull[i].x;
        }
        return offsetHull;
    }

    public static double dist3D(Coordinate c0, Coordinate c1) {
        return Math.sqrt((c1.x - c0.x) * (c1.x - c0.x) + (c1.y - c0.y) * (c1.y - c0.y) + (c1.z - c0.z) * (c1.z - c0.z));
    }

    public static Double dist2D(Coordinate c0, Coordinate c1) {
        return Math.sqrt((c1.x - c0.x) * (c1.x - c0.x) + (c1.y - c0.y) * (c1.y - c0.y));
    }

    public static double getSlope(Coordinate p0, Coordinate p1) {
        return (p1.y - p0.y) / (p1.x - p0.x);
    }
}

