/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.pathfinder.utils.geometry;

import java.util.Objects;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.locationtech.jts.math.Vector3D;

public class Orientation {
    public double yaw;
    public double pitch;
    public double roll;

    public Orientation() {
    }

    public Orientation(double yaw, double pitch, double roll) {
        this.yaw = (360.0 + yaw) % 360.0;
        this.pitch = Math.min(90.0, Math.max(-90.0, pitch));
        this.roll = (360.0 + roll) % 360.0;
    }

    public String toString() {
        return "Orientation(" + this.yaw + "," + this.pitch + "," + this.roll + ")";
    }

    public static Vector3D rotate(Orientation orientation, Vector3D vector) {
        return Orientation.rotate(orientation, vector, false);
    }

    public static Vector3D rotate(Orientation orientation, Vector3D vector, boolean inverse) {
        double[] b = new double[]{vector.getY(), vector.getX(), vector.getZ()};
        double yaw = Math.toRadians(orientation.yaw);
        double pitch = Math.toRadians(orientation.pitch);
        double roll = Math.toRadians(orientation.roll);
        double c1 = Math.cos(yaw);
        double s1 = Math.sin(yaw);
        double c2 = Math.cos(-pitch);
        double s2 = Math.sin(-pitch);
        double c3 = Math.cos(roll);
        double s3 = Math.sin(roll);
        double[][] a = new double[][]{{c1 * c2, c1 * s2 * s3 - s1 * c3, c1 * s2 * c3 + s1 * s3}, {s1 * c2, s1 * s2 * s3 + c1 * c3, s1 * s2 * c3 - c1 * s3}, {-s2, c2 * s3, c2 * c3}};
        Array2DRowRealMatrix matrixA = new Array2DRowRealMatrix((double[][])a);
        if (inverse) {
            matrixA = matrixA.transpose();
        }
        Array2DRowRealMatrix matrixB = new Array2DRowRealMatrix(b);
        RealMatrix res = matrixA.multiply((RealMatrix)matrixB);
        return new Vector3D(res.getEntry(1, 0), res.getEntry(0, 0), res.getEntry(2, 0));
    }

    public static Orientation fromVector(Vector3D vector, double roll) {
        double newYaw = Math.atan2(vector.getX(), vector.getY());
        double newPitch = Math.asin(vector.getZ());
        return new Orientation(Math.toDegrees(newYaw), Math.toDegrees(newPitch), roll);
    }

    public static Vector3D toVector(Orientation orientation) {
        return Orientation.rotate(orientation, new Vector3D(0.0, 1.0, 0.0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Orientation that = (Orientation)o;
        return Double.compare(that.yaw, this.yaw) == 0 && Double.compare(that.pitch, this.pitch) == 0 && Double.compare(that.roll, this.roll) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.yaw, this.pitch, this.roll);
    }
}

