/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.pathfinder.utils.profiler;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilerThread
implements Runnable {
    public Logger log = LoggerFactory.getLogger(ProfilerThread.class);
    public AtomicLong timeTracker = new AtomicLong(System.currentTimeMillis());
    private AtomicBoolean doRun = new AtomicBoolean(true);
    private int writeInterval = 60;
    private int flushInterval = 300;
    private File outputFile;
    long start;
    private Map<String, Integer> metricsIndex = new HashMap<String, Integer>();
    private List<Metric> metrics = new ArrayList<Metric>();

    public ProfilerThread(File outputFile) {
        this.outputFile = outputFile;
        this.start = System.currentTimeMillis();
        this.addMetric(new TimeMetric(this.timeTracker, this.start));
    }

    public void addMetric(Metric metric) {
        this.metrics.add(metric);
        this.metricsIndex.put(metric.getClass().getName(), this.metrics.size() - 1);
    }

    public void setWriteInterval(int writeInterval) {
        this.writeInterval = writeInterval;
    }

    public void setFlushInterval(int flushInterval) {
        this.flushInterval = flushInterval;
    }

    private void writeData(BufferedWriter b) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (Metric m : this.metrics) {
            for (String metricValue : m.getCurrentValues()) {
                if (sb.length() != 0) {
                    sb.append(",");
                }
                sb.append(metricValue);
            }
        }
        sb.append("\n");
        b.write(sb.toString());
    }

    @Override
    public void run() {
        long lastWrite = 0L;
        long lastFlush = 0L;
        try (BufferedWriter b = new BufferedWriter(new FileWriter(this.outputFile));){
            StringBuilder sb = new StringBuilder();
            for (Metric m : this.metrics) {
                for (String columnName : m.getColumnNames()) {
                    if (sb.length() != 0) {
                        sb.append(",");
                    }
                    sb.append(columnName);
                }
            }
            sb.append("\n");
            b.write(sb.toString());
            b.flush();
            while (this.doRun.get()) {
                this.timeTracker.set(System.currentTimeMillis());
                for (Metric m : this.metrics) {
                    m.tick(this.timeTracker.get());
                }
                try {
                    if ((double)(this.timeTracker.get() - lastWrite) / 1000.0 >= (double)this.writeInterval) {
                        lastWrite = this.timeTracker.get();
                        this.writeData(b);
                    } else {
                        Thread.sleep(2L);
                    }
                    if (!((double)(this.timeTracker.get() - lastFlush) / 1000.0 >= (double)this.flushInterval)) continue;
                    lastFlush = this.timeTracker.get();
                    b.flush();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                    break;
                }
            }
            this.writeData(b);
        }
        catch (IOException ex) {
            this.log.error("Error while writing file", (Throwable)ex);
        }
    }

    public void stop() {
        this.doRun.set(false);
    }

    public <T extends Metric> T getMetric(Class<T> metricClass) {
        Integer mIndex = this.metricsIndex.get(metricClass.getName());
        if (mIndex != null) {
            Metric o = this.metrics.get(mIndex);
            if (metricClass.isInstance(o)) {
                return (T)((Metric)metricClass.cast(o));
            }
            return null;
        }
        return null;
    }

    public static interface Metric {
        public String[] getColumnNames();

        public String[] getCurrentValues();

        public void tick(long var1);
    }

    private class TimeMetric
    implements Metric {
        AtomicLong timeTracker;
        long startTime;

        public TimeMetric(AtomicLong timeTracker, long startTime) {
            this.timeTracker = timeTracker;
            this.startTime = startTime;
        }

        @Override
        public String[] getColumnNames() {
            return new String[]{"time"};
        }

        @Override
        public String[] getCurrentValues() {
            return new String[]{String.format(Locale.ROOT, "%.2f", (double)(this.timeTracker.get() - ProfilerThread.this.start) / 1000.0)};
        }

        @Override
        public void tick(long currentMillis) {
        }
    }
}

