/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.pathfinder.utils.profiler;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.noise_planet.noisemodelling.pathfinder.utils.profiler.DefaultProgressVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootProgressVisitor
extends DefaultProgressVisitor {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private boolean canceled = false;
    private boolean logProgression = false;
    private Logger logger = LoggerFactory.getLogger(RootProgressVisitor.class);
    private String lastLoggedProgression = "";
    private double minimumSecondsBetweenPrint = 1.0;
    private long lastPrint = 0L;

    public RootProgressVisitor(long subprocessSize, boolean logProgression, double minimumSecondsBetweenPrint) {
        super(subprocessSize, null);
        this.logProgression = logProgression;
        this.minimumSecondsBetweenPrint = minimumSecondsBetweenPrint;
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(property, listener);
    }

    @Override
    protected synchronized void pushProgression(double incProg) {
        String newLogProgress;
        double oldProgress = this.getProgression();
        super.pushProgression(incProg);
        double newProgress = this.getProgression();
        this.propertyChangeSupport.firePropertyChange("PROGRESS", oldProgress, newProgress);
        if (this.logProgression && !(newLogProgress = String.format("%.2f %%", newProgress * 100.0)).equals(this.lastLoggedProgression)) {
            this.lastLoggedProgression = newLogProgress;
            long t = System.currentTimeMillis();
            if ((double)(t - this.lastPrint) / 1000.0 > this.minimumSecondsBetweenPrint) {
                this.logger.info(newLogProgress);
                this.lastPrint = t;
            }
        }
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void cancel() {
        this.canceled = true;
        this.propertyChangeSupport.firePropertyChange("CANCELED", false, true);
    }
}

