/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.propagation;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.h2gis.api.ProgressVisitor;
import org.noise_planet.noisemodelling.pathfinder.CutPlaneVisitor;
import org.noise_planet.noisemodelling.pathfinder.CutPlaneVisitorFactory;
import org.noise_planet.noisemodelling.pathfinder.path.Scene;
import org.noise_planet.noisemodelling.propagation.AttenuationVisitor;
import org.noise_planet.noisemodelling.propagation.ReceiverNoiseLevel;
import org.noise_planet.noisemodelling.propagation.SceneWithAttenuation;
import org.noise_planet.noisemodelling.propagation.cnossos.CnossosPath;

public class AttenuationComputeOutput
implements CutPlaneVisitorFactory {
    public ConcurrentLinkedDeque<ReceiverNoiseLevel> receiversAttenuationLevels = new ConcurrentLinkedDeque();
    public Deque<CnossosPath> pathParameters = new ConcurrentLinkedDeque<CnossosPath>();
    public AtomicInteger propagationPathsSize = new AtomicInteger(0);
    public boolean exportPaths;
    public boolean exportAttenuationMatrix;
    public AtomicLong cnossosPathCount = new AtomicLong();
    public AtomicLong nb_couple_receiver_src = new AtomicLong();
    public AtomicLong nb_obstr_test = new AtomicLong();
    public AtomicLong nb_image_receiver = new AtomicLong();
    public AtomicLong nb_reflexion_path = new AtomicLong();
    public AtomicLong nb_diffraction_path = new AtomicLong();
    public AtomicInteger cellComputed = new AtomicInteger();
    public SceneWithAttenuation scene;

    public AttenuationComputeOutput(boolean exportPaths, SceneWithAttenuation scene) {
        this.exportPaths = exportPaths;
        this.exportAttenuationMatrix = false;
        this.scene = scene;
    }

    public AttenuationComputeOutput(boolean exportPaths, boolean exportAttenuationMatrix, SceneWithAttenuation scene) {
        this.exportPaths = exportPaths;
        this.exportAttenuationMatrix = exportAttenuationMatrix;
        this.scene = scene;
    }

    public Scene getScene() {
        return this.scene;
    }

    public CutPlaneVisitor subProcess(ProgressVisitor visitor) {
        return new AttenuationVisitor(this);
    }

    public List<ReceiverNoiseLevel> getVerticesSoundLevel() {
        return new ArrayList<ReceiverNoiseLevel>(this.receiversAttenuationLevels);
    }

    public List<CnossosPath> getPropagationPaths() {
        return new ArrayList<CnossosPath>(this.pathParameters);
    }

    public void clearPropagationPaths() {
        this.pathParameters.clear();
        this.propagationPathsSize.set(0);
    }

    public void appendReflexionPath(long added) {
        this.nb_reflexion_path.addAndGet(added);
    }

    public void appendDiffractionPath(long added) {
        this.nb_diffraction_path.addAndGet(added);
    }

    public void appendImageReceiver(long added) {
        this.nb_image_receiver.addAndGet(added);
    }

    public void appendSourceCount(long srcCount) {
        this.nb_couple_receiver_src.addAndGet(srcCount);
    }

    public void appendFreeFieldTestCount(long freeFieldTestCount) {
        this.nb_obstr_test.addAndGet(freeFieldTestCount);
    }

    public synchronized void log(String str) {
    }

    public synchronized void appendCellComputed() {
        this.cellComputed.addAndGet(1);
    }

    public synchronized long getCellComputed() {
        return this.cellComputed.get();
    }
}

