/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.propagation;

import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.geom.Coordinate;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.ProfileBuilder;
import org.noise_planet.noisemodelling.pathfinder.utils.AcousticIndicatorsFunctions;

public class AttenuationParameters {
    public static final double K_0 = 273.15;
    public static final double Pref = 101325.0;
    public static final double Kref = 293.15;
    public static final double FmolO = 0.209;
    public static final double FmolN = 0.781;
    public static final double KvibO = 2239.1;
    public static final double KvibN = 3352.0;
    public static final double K01 = 273.16;
    public static final double a8 = 1.7951958020513104 * Math.log10(Math.pow(Math.exp(1.0), 2.0));
    protected List<Integer> freq_lvl;
    protected List<Double> freq_lvl_exact;
    protected List<Double> freq_lvl_a_weighting;
    public static final double[] DEFAULT_WIND_ROSE = new double[]{0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5};
    public double temperature = 15.0;
    public double celerity = 340.0;
    public double humidity = 70.0;
    public double pressure = 101325.0;
    public double[] alpha_atmo;
    public double defaultOccurance = 0.5;
    public boolean gDisc = true;
    public boolean prime2520 = false;
    public double[] windRose = DEFAULT_WIND_ROSE;
    private static final double angle_section = Math.PI * 2 / (double)DEFAULT_WIND_ROSE.length;

    public AttenuationParameters() {
        this(false);
    }

    public AttenuationParameters(boolean thirdOctave) {
        if (!thirdOctave) {
            this.freq_lvl = Arrays.asList(AcousticIndicatorsFunctions.asOctaveBands((int[])ProfileBuilder.DEFAULT_FREQUENCIES_THIRD_OCTAVE));
            this.freq_lvl_exact = Arrays.asList(AcousticIndicatorsFunctions.asOctaveBands((Double[])ProfileBuilder.DEFAULT_FREQUENCIES_EXACT_THIRD_OCTAVE));
            this.freq_lvl_a_weighting = Arrays.asList(AcousticIndicatorsFunctions.asOctaveBands((Double[])ProfileBuilder.DEFAULT_FREQUENCIES_A_WEIGHTING_THIRD_OCTAVE));
        } else {
            this.freq_lvl = Arrays.stream(ProfileBuilder.DEFAULT_FREQUENCIES_THIRD_OCTAVE).boxed().collect(Collectors.toList());
            this.freq_lvl_exact = Arrays.asList(ProfileBuilder.DEFAULT_FREQUENCIES_EXACT_THIRD_OCTAVE);
            this.freq_lvl_a_weighting = Arrays.asList(ProfileBuilder.DEFAULT_FREQUENCIES_A_WEIGHTING_THIRD_OCTAVE);
        }
        this.init();
    }

    public AttenuationParameters(AttenuationParameters other) {
        this.freq_lvl = other.freq_lvl;
        this.freq_lvl_exact = other.freq_lvl_exact;
        this.freq_lvl_a_weighting = other.freq_lvl_a_weighting;
        this.temperature = other.temperature;
        this.celerity = other.celerity;
        this.humidity = other.humidity;
        this.pressure = other.pressure;
        this.alpha_atmo = other.alpha_atmo;
        this.defaultOccurance = other.defaultOccurance;
        this.gDisc = other.gDisc;
        this.prime2520 = other.prime2520;
        this.windRose = other.windRose;
    }

    public AttenuationParameters(List<Integer> freq_lvl, List<Double> freq_lvl_exact, List<Double> freq_lvl_a_weighting) {
        this.freq_lvl = Collections.unmodifiableList(freq_lvl);
        this.freq_lvl_exact = Collections.unmodifiableList(freq_lvl_exact);
        this.freq_lvl_a_weighting = Collections.unmodifiableList(freq_lvl_a_weighting);
        this.init();
    }

    protected void init() {
        this.setTemperature(this.temperature);
    }

    public List<Integer> getFrequencies() {
        return this.freq_lvl;
    }

    public void setFrequencies(List<Integer> freq_lvl) {
        this.freq_lvl = freq_lvl;
        this.freq_lvl_exact = new ArrayList<Double>();
        this.freq_lvl_a_weighting = new ArrayList<Double>();
        ProfileBuilder.initializeFrequencyArrayFromReference(freq_lvl, this.freq_lvl_exact, this.freq_lvl_a_weighting);
        this.init();
    }

    public List<Double> getFrequenciesExact() {
        return this.freq_lvl_exact;
    }

    public List<Double> getFrequenciesAWeighting() {
        return this.freq_lvl_a_weighting;
    }

    public AttenuationParameters setHumidity(double humidity) {
        this.humidity = humidity;
        this.alpha_atmo = AttenuationParameters.getAtmoCoeffArray(this.freq_lvl_exact, this.temperature, this.pressure, humidity);
        return this;
    }

    public AttenuationParameters setPressure(double pressure) {
        this.pressure = pressure;
        this.alpha_atmo = AttenuationParameters.getAtmoCoeffArray(this.freq_lvl_exact, this.temperature, pressure, this.humidity);
        return this;
    }

    public double[] getWindRose() {
        return this.windRose;
    }

    public void setWindRose(double[] windRose) {
        if (windRose.length != this.windRose.length) {
            throw new IllegalArgumentException(String.format("Wind roses length is not compatible %d!=%d", windRose.length, this.windRose.length));
        }
        this.windRose = windRose;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public double getCelerity() {
        return this.celerity;
    }

    public double getHumidity() {
        return this.humidity;
    }

    public double getPressure() {
        return this.pressure;
    }

    public boolean isPrime2520() {
        return this.prime2520;
    }

    public boolean isgDisc() {
        return this.gDisc;
    }

    public void setgDisc(boolean gDisc) {
        this.gDisc = gDisc;
    }

    public double getDefaultOccurance() {
        return this.defaultOccurance;
    }

    public void setDefaultOccurance(double defaultOccurance) {
        this.defaultOccurance = defaultOccurance;
    }

    public AttenuationParameters setGDisc(boolean gDisc) {
        this.gDisc = gDisc;
        return this;
    }

    public AttenuationParameters setPrime2520(boolean prime2520) {
        this.prime2520 = prime2520;
        return this;
    }

    public AttenuationParameters setTemperature(double temperature) {
        this.temperature = temperature;
        this.celerity = AttenuationParameters.computeCelerity(temperature + 273.15);
        this.alpha_atmo = AttenuationParameters.getAtmoCoeffArray(this.freq_lvl_exact, temperature, this.pressure, this.humidity);
        return this;
    }

    public static double[] getAtmoCoeffArray(List<Double> freq_lvl, double temperature, double pressure, double humidity) {
        double[] alpha_atmo = new double[freq_lvl.size()];
        for (int idfreq = 0; idfreq < freq_lvl.size(); ++idfreq) {
            alpha_atmo[idfreq] = AttenuationParameters.getAlpha(freq_lvl.get(idfreq), temperature, pressure, humidity);
        }
        return alpha_atmo;
    }

    public double[] getAlpha_atmo() {
        return this.alpha_atmo;
    }

    public static int getRoseIndex(Coordinate receiver, Coordinate source) {
        return AttenuationParameters.getRoseIndex(Angle.angle((Coordinate)receiver, (Coordinate)source));
    }

    public static int getRoseIndex(double angle) {
        int index;
        double angleRad = -(angle - Math.PI);
        if ((angleRad -= 1.5707963267948966 - angle_section / 2.0) < 0.0) {
            angleRad += Math.PI * 2;
        }
        if ((index = (int)(angleRad / angle_section) - 1) < 0) {
            index = DEFAULT_WIND_ROSE.length - 1;
        }
        return index;
    }

    static double computeCelerity(double k) {
        return 343.2 * Math.sqrt(k / 293.15);
    }

    public static double getCoefAttAtmosCnossos(double freq, double humidity, double pressure, double T_kel) {
        double tcor = T_kel / 293.15;
        double xmol = humidity * Math.pow(10.0, 4.6151 - 6.8346 * Math.pow(273.16 / T_kel, 1.261));
        double frqO = 24.0 + 40400.0 * xmol * ((0.02 + xmol) / (0.391 + xmol));
        double frqN = Math.pow(tcor, -0.5) * (9.0 + 280.0 * xmol * Math.exp(-4.17 * (Math.pow(tcor, -0.3333333333333333) - 1.0)));
        double a1 = 0.01275 * Math.exp(-2239.1 / T_kel) / (frqO + freq * freq / frqO);
        double a2 = 0.1068 * Math.exp(-3352.0 / T_kel) / (frqN + freq * freq / frqN);
        double a0 = 8.686 * freq * freq * (1.84E-11 * Math.pow(tcor, 0.5) + Math.pow(tcor, -2.5) * (a1 + a2));
        return a0 * 1000.0;
    }

    public static double getCoefAttAtmos(double frequency, double humidity, double pressure, double T_kel) {
        double Kelvin = 273.15;
        double e = 2.718282;
        double T_ref = 293.15;
        double T_rel = T_kel / T_ref;
        double T_01 = 273.15999999999997;
        double P_ref = 101.325;
        double P_rel = pressure / 1000.0 / P_ref;
        double P_sat_over_P_ref = Math.pow(10.0, -6.8346 * Math.pow(T_01 / T_kel, 1.261) + 4.6151);
        double H = humidity * (P_sat_over_P_ref / P_rel);
        double Fro = P_rel * (24.0 + 40400.0 * H * (0.02 + H) / (0.391 + H));
        double Frn = P_rel / Math.sqrt(T_rel) * (9.0 + 280.0 * H * Math.pow(2.718282, -4.17 * (Math.pow(T_rel, -0.3333333333333333) - 1.0)));
        double Xc = 1.84E-11 / P_rel * Math.sqrt(T_rel);
        double Xo = 0.01275 * Math.pow(2.718282, -2239.1 / T_kel) * Math.pow(Fro + frequency * frequency / Fro, -1.0);
        double Xn = 0.1068 * Math.pow(2.718282, -3352.0 / T_kel) * Math.pow(Frn + frequency * frequency / Frn, -1.0);
        double Alpha = 20.0 * Math.log10(2.718282) * frequency * frequency * (Xc + Math.pow(T_rel, -2.5) * (Xo + Xn));
        return Alpha * 1000.0;
    }

    public static double getCoefAttAtmosSpps(double frequency, double humidity, double pressure, double tempKelvin) {
        double cson = AttenuationParameters.computeCelerity(tempKelvin);
        double C = -6.8346 * Math.pow(273.16 / tempKelvin, 1.261) + 4.6151;
        double Ps = 101325.0 * Math.pow(10.0, C);
        double hmol = humidity * (Ps / 101325.0) * (pressure / 101325.0);
        double Acr = 101325.0 / pressure * 1.6E-10 * Math.sqrt(tempKelvin / 293.15) * Math.pow(frequency, 2.0);
        double Fr = pressure / 101325.0 * (24.0 + 40400.0 * hmol * (0.02 + hmol) / (0.391 + hmol));
        double Am = a8 * 0.209 * Math.exp(-2239.1 / tempKelvin) * Math.pow(2239.1 / tempKelvin, 2.0);
        double AvibO = Am * (frequency / cson) * 2.0 * (frequency / Fr) / (1.0 + Math.pow(frequency / Fr, 2.0));
        Fr = pressure / 101325.0 * Math.sqrt(293.15 / tempKelvin) * (9.0 + 280.0 * hmol * Math.exp(-4.17 * (Math.pow(tempKelvin / 293.15, -0.3333333333333333) - 1.0)));
        Am = a8 * 0.781 * Math.exp(-3352.0 / tempKelvin) * Math.pow(3352.0 / tempKelvin, 2.0);
        double AvibN = Am * (frequency / cson) * 2.0 * (frequency / Fr) / (1.0 + Math.pow(frequency / Fr, 2.0));
        double alpha = Acr + AvibO + AvibN;
        return alpha * 1000.0;
    }

    public static double getAlpha(double frequency, double temperature, double pressure, double humidity) {
        return AttenuationParameters.getCoefAttAtmos(frequency, humidity, pressure, temperature + 273.15);
    }

    public void writeToDatabase(Connection connection, String tableName, String period) throws SQLException {
        String createTableSQL = "CREATE TABLE IF NOT EXISTS " + tableName + " (PERIOD VARCHAR PRIMARY KEY,WINDROSE REAL ARRAY,PRESSURE REAL,HUMIDITY REAL,GDISC BOOLEAN,PRIME2520 BOOLEAN,TEMPERATURE REAL)";
        try (Statement stmt = connection.createStatement();){
            stmt.execute(createTableSQL);
        }
        String insertSQL = "INSERT INTO " + tableName + " (PERIOD, WINDROSE, PRESSURE, HUMIDITY, GDISC, PRIME2520, TEMPERATURE) VALUES (?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement pstmt = connection.prepareStatement(insertSQL);){
            Array sqlWindRose = connection.createArrayOf("DOUBLE", Arrays.stream(this.windRose).boxed().toArray());
            pstmt.setString(1, period);
            pstmt.setArray(2, sqlWindRose);
            pstmt.setDouble(3, this.pressure);
            pstmt.setDouble(4, this.humidity);
            pstmt.setBoolean(5, this.gDisc);
            pstmt.setBoolean(6, this.prime2520);
            pstmt.setDouble(7, this.getTemperature());
            pstmt.executeUpdate();
        }
    }

    public static void readFromDatabase(ResultSet rs, Map<String, AttenuationParameters> cnossosParametersPerPeriod) throws SQLException {
        AttenuationParameters params = new AttenuationParameters();
        Array windrose = rs.getArray("WINDROSE");
        params.windRose = AttenuationParameters.convertSqlArrayToDoubleArray(windrose);
        if (params.windRose.length != DEFAULT_WIND_ROSE.length) {
            throw new SQLException("Wind rose array length is not " + DEFAULT_WIND_ROSE.length);
        }
        params.pressure = rs.getDouble("PRESSURE");
        params.humidity = rs.getDouble("HUMIDITY");
        params.gDisc = rs.getBoolean("GDISC");
        params.prime2520 = rs.getBoolean("PRIME2520");
        params.setTemperature(rs.getDouble("TEMPERATURE"));
        cnossosParametersPerPeriod.put(rs.getString("PERIOD"), params);
    }

    public static double[] convertSqlArrayToDoubleArray(Array array) throws SQLException {
        if (array == null) {
            return new double[0];
        }
        Object arrayObj = array.getArray();
        if (arrayObj instanceof Double[]) {
            return Arrays.stream((Double[])arrayObj).mapToDouble(Double::doubleValue).toArray();
        }
        if (arrayObj instanceof Object[]) {
            return Arrays.stream((Object[])arrayObj).mapToDouble(o -> o instanceof Number ? ((Number)o).doubleValue() : 0.0).toArray();
        }
        return new double[0];
    }
}

