/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.propagation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.noise_planet.noisemodelling.pathfinder.CutPlaneVisitor;
import org.noise_planet.noisemodelling.pathfinder.PathFinder;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutProfile;
import org.noise_planet.noisemodelling.pathfinder.utils.AcousticIndicatorsFunctions;
import org.noise_planet.noisemodelling.propagation.AttenuationComputeOutput;
import org.noise_planet.noisemodelling.propagation.AttenuationParameters;
import org.noise_planet.noisemodelling.propagation.ReceiverNoiseLevel;
import org.noise_planet.noisemodelling.propagation.SceneWithAttenuation;
import org.noise_planet.noisemodelling.propagation.cnossos.AttenuationCnossos;
import org.noise_planet.noisemodelling.propagation.cnossos.CnossosPath;
import org.noise_planet.noisemodelling.propagation.cnossos.CnossosPathBuilder;

public class AttenuationVisitor
implements CutPlaneVisitor {
    public AttenuationComputeOutput multiThreadParent;
    public List<ReceiverNoiseLevel> receiverAttenuationLevels = new ArrayList<ReceiverNoiseLevel>();
    public List<CnossosPath> pathParameters = new ArrayList<CnossosPath>();
    public boolean keepRays = false;

    public AttenuationVisitor(AttenuationComputeOutput multiThreadParent) {
        this.multiThreadParent = multiThreadParent;
        this.keepRays = multiThreadParent.exportPaths;
    }

    public CutPlaneVisitor.PathSearchStrategy onNewCutPlane(CutProfile cutProfile) {
        SceneWithAttenuation scene = this.multiThreadParent.scene;
        double gs = scene.sourceGs.getOrDefault(cutProfile.getSource().sourcePk, 0.0);
        CnossosPath cnossosPath = CnossosPathBuilder.computeCnossosPathFromCutProfile(cutProfile, scene.isBodyBarrier(), scene.profileBuilder.exactFrequencyArray, gs);
        if (cnossosPath != null) {
            this.addPropagationPath(cnossosPath);
        }
        return CutPlaneVisitor.PathSearchStrategy.CONTINUE;
    }

    public void startReceiver(PathFinder.ReceiverPointInfo receiver, Collection<PathFinder.SourcePointInfo> sourceList, AtomicInteger cutProfileCount) {
    }

    private void processPath(String period, AttenuationParameters AttenuationParameters2, CnossosPath path) {
        double[] aGlobalMeteo = AttenuationCnossos.computeCnossosAttenuation(AttenuationParameters2, path, this.multiThreadParent.scene, this.multiThreadParent.exportAttenuationMatrix);
        if (aGlobalMeteo != null && aGlobalMeteo.length > 0) {
            this.multiThreadParent.cnossosPathCount.addAndGet(1L);
            if (this.keepRays) {
                this.pathParameters.add(path);
            }
            this.receiverAttenuationLevels.add(new ReceiverNoiseLevel(new PathFinder.SourcePointInfo(path.getCutProfile().getSource()), new PathFinder.ReceiverPointInfo(path.getCutProfile().getReceiver()), period, aGlobalMeteo));
        }
    }

    public void addPropagationPath(CnossosPath path) {
        if (!this.multiThreadParent.scene.cnossosParametersPerPeriod.isEmpty()) {
            for (Map.Entry<String, AttenuationParameters> cnossosParametersEntry : this.multiThreadParent.scene.cnossosParametersPerPeriod.entrySet()) {
                this.processPath(cnossosParametersEntry.getKey(), cnossosParametersEntry.getValue(), path);
            }
        } else {
            this.processPath("", this.multiThreadParent.scene.defaultCnossosParameters, path);
        }
    }

    public void finalizeReceiver(PathFinder.ReceiverPointInfo receiver) {
        if (this.keepRays && !this.pathParameters.isEmpty()) {
            this.multiThreadParent.pathParameters.addAll(this.pathParameters);
            this.multiThreadParent.propagationPathsSize.addAndGet(this.pathParameters.size());
            this.pathParameters.clear();
        }
        if (this.multiThreadParent.receiversAttenuationLevels != null) {
            HashMap<PathFinder.SourcePointInfo, double[]> levelsPerSourceLines = new HashMap<PathFinder.SourcePointInfo, double[]>();
            for (ReceiverNoiseLevel receiverNoiseLevel : this.receiverAttenuationLevels) {
                if (!levelsPerSourceLines.containsKey(receiverNoiseLevel.source)) {
                    levelsPerSourceLines.put(receiverNoiseLevel.source, receiverNoiseLevel.levels);
                    continue;
                }
                levelsPerSourceLines.put(receiverNoiseLevel.source, AcousticIndicatorsFunctions.sumDbArray((double[])((double[])levelsPerSourceLines.get(receiverNoiseLevel.source)), (double[])receiverNoiseLevel.levels));
            }
            for (Map.Entry entry : levelsPerSourceLines.entrySet()) {
                this.multiThreadParent.receiversAttenuationLevels.add(new ReceiverNoiseLevel((PathFinder.SourcePointInfo)entry.getKey(), receiver, "", (double[])entry.getValue()));
            }
        }
        this.receiverAttenuationLevels.clear();
    }
}

