/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.propagation.cnossos;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.math.Vector3D;
import org.noise_planet.noisemodelling.pathfinder.utils.AcousticIndicatorsFunctions;
import org.noise_planet.noisemodelling.pathfinder.utils.geometry.Orientation;
import org.noise_planet.noisemodelling.propagation.AttenuationParameters;
import org.noise_planet.noisemodelling.propagation.SceneWithAttenuation;
import org.noise_planet.noisemodelling.propagation.cnossos.CnossosPath;
import org.noise_planet.noisemodelling.propagation.cnossos.PointPath;
import org.noise_planet.noisemodelling.propagation.cnossos.SegmentPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttenuationCnossos {
    private static double[] freq_lambda;
    private static double[] aGlobal;
    private static final Logger LOGGER;

    public static double[] getaGlobal() {
        return aGlobal;
    }

    public static double[] getDeltaDif(SegmentPath srpath, AttenuationParameters data) {
        double[] DeltaDif = new double[data.getFrequencies().size()];
        for (int idfreq = 0; idfreq < data.getFrequencies().size(); ++idfreq) {
            double cprime;
            double Ch = 1.0;
            if (srpath.eLength > 0.3) {
                double gammaPart = Math.pow(5.0 * freq_lambda[idfreq] / srpath.eLength, 2.0);
                cprime = (1.0 + gammaPart) / (0.3333333333333333 + gammaPart);
            } else {
                cprime = 1.0;
            }
            double testForm = 40.0 / freq_lambda[idfreq] * cprime * srpath.delta;
            double deltaDif = 0.0;
            if (testForm >= -2.0) {
                deltaDif = 10.0 * Ch * Math.log10(Math.max(0.0, 3.0 + testForm));
            }
            DeltaDif[idfreq] = Math.max(0.0, deltaDif);
        }
        return DeltaDif;
    }

    public static double getADiv(double distance) {
        return 20.0 * Math.log10(distance) + 11.0;
    }

    private static double getAAtm(double dist, double alpha_atmo) {
        return alpha_atmo * dist / 1000.0;
    }

    public static double[] getAGroundCore(CnossosPath pathParameters, SegmentPath segmentPath, AttenuationParameters data) {
        double[] aGround = new double[data.getFrequencies().size()];
        for (int idfreq = 0; idfreq < data.getFrequencies().size(); ++idfreq) {
            double AGround;
            double aGroundMin;
            int fm = data.getFrequencies().get(idfreq);
            double gw = segmentPath.gw;
            double dp = segmentPath.dp;
            double k = Math.PI * 2 * (double)fm / data.getCelerity();
            double w = 0.0185 * Math.pow(fm, 2.5) * Math.pow(gw, 2.6) / (Math.pow(fm, 1.5) * Math.pow(gw, 2.6) + 1300.0 * Math.pow(fm, 0.75) * Math.pow(gw, 1.3) + 1160000.0);
            double cf = dp * (1.0 + 3.0 * w * dp * Math.pow(Math.E, -Math.sqrt(w * dp))) / (1.0 + w * dp);
            if (pathParameters.isFavorable()) {
                aGroundMin = data.isPrime2520() ? (segmentPath.testFormF <= 1.0 ? -3.0 * (1.0 - segmentPath.gm) : -3.0 * (1.0 - segmentPath.gm) * (1.0 + 2.0 * (1.0 - 1.0 / segmentPath.testFormF))) : (segmentPath.testFormH <= 1.0 ? -3.0 * (1.0 - segmentPath.gm) : -3.0 * (1.0 - segmentPath.gm) * (1.0 + 2.0 * (1.0 - 1.0 / segmentPath.testFormH)));
                AGround = -10.0 * Math.log10(4.0 * Math.pow(k, 2.0) / Math.pow(segmentPath.dp, 2.0) * (Math.pow(segmentPath.zsF, 2.0) - Math.sqrt(2.0 * cf / k) * segmentPath.zsF + cf / k) * (Math.pow(segmentPath.zrF, 2.0) - Math.sqrt(2.0 * cf / k) * segmentPath.zrF + cf / k));
            } else {
                AGround = -10.0 * Math.log10(4.0 * Math.pow(k, 2.0) / Math.pow(segmentPath.dp, 2.0) * (Math.pow(segmentPath.zsH, 2.0) - Math.sqrt(2.0 * cf / k) * segmentPath.zsH + cf / k) * (Math.pow(segmentPath.zrH, 2.0) - Math.sqrt(2.0 * cf / k) * segmentPath.zrH + cf / k));
                aGroundMin = -3.0 * (1.0 - segmentPath.gm);
            }
            aGround[idfreq] = Math.max(AGround, aGroundMin);
            if (!pathParameters.keepAbsorption) continue;
            if (pathParameters.isFavorable()) {
                int n = idfreq;
                pathParameters.groundAttenuation.wF[n] = pathParameters.groundAttenuation.wF[n] + w;
                pathParameters.groundAttenuation.cfF[idfreq] = cf;
                pathParameters.groundAttenuation.aGroundF[idfreq] = aGround[idfreq];
                continue;
            }
            int n = idfreq;
            pathParameters.groundAttenuation.wH[n] = pathParameters.groundAttenuation.wH[n] + w;
            pathParameters.groundAttenuation.cfH[idfreq] = cf;
            pathParameters.groundAttenuation.aGroundH[idfreq] = aGround[idfreq];
        }
        return aGround;
    }

    private static double getDeltaGround(double aGround, double deltaDifPrim, double deltaDif) {
        double attArg = 1.0 + (Math.pow(10.0, -aGround / 20.0) - 1.0) * Math.pow(10.0, -(deltaDifPrim - deltaDif) / 20.0);
        if (Double.isNaN(attArg)) {
            attArg = Double.MAX_VALUE;
        } else if (attArg < 0.0) {
            attArg = 0.0;
        }
        return -20.0 * Math.log10(attArg);
    }

    private static double[] getARef(CnossosPath pathParameters, AttenuationParameters data) {
        double[] aRef = new double[data.getFrequencies().size()];
        Arrays.fill(aRef, 0.0);
        for (PointPath pointPath : pathParameters.getPointList()) {
            if (!pointPath.type.equals((Object)PointPath.POINT_TYPE.REFL)) continue;
            for (int idf = 0; idf < data.getFrequencies().size(); ++idf) {
                List<Double> alpha = pointPath.alphaWall;
                if (alpha == null || alpha.isEmpty()) continue;
                int n = idf;
                aRef[n] = aRef[n] + 10.0 * Math.log10(1.0 - alpha.get(idf));
            }
        }
        return aRef;
    }

    private static double[] aGround(SegmentPath segmentPath, CnossosPath pathParameters, AttenuationParameters data) {
        if (segmentPath.gPath != 0.0 || !data.isgDisc()) {
            return AttenuationCnossos.getAGroundCore(pathParameters, segmentPath, data);
        }
        if (pathParameters.keepAbsorption) {
            AttenuationCnossos.getAGroundCore(pathParameters, segmentPath, data);
        }
        double aGroundMin = pathParameters.isFavorable() ? (segmentPath.testFormF <= 1.0 ? -3.0 * (1.0 - segmentPath.gm) : -3.0 * (1.0 - segmentPath.gm) * (1.0 + 2.0 * (1.0 - 1.0 / segmentPath.testFormF))) : -3.0;
        double[] aGround = new double[data.getFrequencies().size()];
        Arrays.fill(aGround, aGroundMin);
        if (pathParameters.keepAbsorption) {
            if (pathParameters.isFavorable()) {
                pathParameters.groundAttenuation.aGroundF = aGround;
            } else {
                pathParameters.groundAttenuation.aGroundH = aGround;
            }
        }
        return aGround;
    }

    private static double[] getABoundary(CnossosPath pathParameters, AttenuationParameters data) {
        double[] aGround;
        SegmentPath srPath = pathParameters.getSRSegment();
        List<SegmentPath> segments = pathParameters.getSegmentList();
        double[] aDif = new double[data.getFrequencies().size()];
        srPath.gw = pathParameters.isFavorable() ? Double.valueOf(srPath.gPath) : srPath.gPathPrime;
        srPath.gm = srPath.gPathPrime;
        ArrayList<Integer> difBands = new ArrayList<Integer>();
        ArrayList<Integer> noDifBands = new ArrayList<Integer>();
        double deltaD = srPath.d - (segments.get((int)0).d + segments.get((int)1).dp);
        double deltaDPrime = -srPath.dPrime + segments.get((int)0).dPrime + segments.get((int)1).dPrime;
        for (int freq : data.getFrequencies()) {
            double lambda = 340.0 / (double)freq;
            if (!(deltaD > -lambda / 20.0)) continue;
            if (deltaD > lambda / 4.0 - deltaDPrime) {
                difBands.add(data.getFrequencies().indexOf(freq));
                continue;
            }
            noDifBands.add(data.getFrequencies().indexOf(freq));
        }
        List<SegmentPath> segmentPath = pathParameters.getSegmentList();
        double[] deltaDifSR = AttenuationCnossos.getDeltaDif(srPath, data);
        double[] DeltaDifSpR = AttenuationCnossos.getDeltaDif(segments.get(segments.size() - 2), data);
        double[] deltaDifSRp = AttenuationCnossos.getDeltaDif(segments.get(segments.size() - 1), data);
        segmentPath.get((int)0).gw = pathParameters.isFavorable() ? Double.valueOf(segmentPath.get((int)0).gPath) : segmentPath.get((int)0).gPathPrime;
        segmentPath.get((int)0).gm = segmentPath.get((int)0).gPathPrime;
        double[] aGroundSO = AttenuationCnossos.aGround(segmentPath.get(0), pathParameters, data);
        segmentPath.get((int)(segmentPath.size() - 1)).gw = segmentPath.get((int)(segmentPath.size() - 1)).gPath;
        segmentPath.get((int)(segmentPath.size() - 1)).gm = segmentPath.get((int)(segmentPath.size() - 1)).gPath;
        double[] aGroundOR = AttenuationCnossos.aGround(segmentPath.get(segmentPath.size() - 1), pathParameters, data);
        double[] deltaGroundSO = new double[data.getFrequencies().size()];
        double[] deltaGroundOR = new double[data.getFrequencies().size()];
        Iterator iterator = difBands.iterator();
        while (iterator.hasNext()) {
            int idf = (Integer)iterator.next();
            if (segmentPath.get((int)(segmentPath.size() - 1)).zrH > 1.0E-7) {
                deltaGroundSO[idf] = AttenuationCnossos.getDeltaGround(aGroundSO[idf], DeltaDifSpR[idf], deltaDifSR[idf]);
                deltaGroundOR[idf] = AttenuationCnossos.getDeltaGround(aGroundOR[idf], deltaDifSRp[idf], deltaDifSR[idf]);
            } else {
                deltaGroundSO[idf] = AttenuationCnossos.getDeltaGround(aGroundSO[idf], DeltaDifSpR[idf], deltaDifSR[idf]);
                deltaGroundOR[idf] = aGroundOR[idf];
            }
            aDif[idf] = Math.min(25.0, deltaDifSR[idf]) + deltaGroundSO[idf] + deltaGroundOR[idf];
        }
        double[] aBoundary = aGround = AttenuationCnossos.aGround(srPath, pathParameters, data);
        long difVPointCount = pathParameters.getPointList().stream().filter(pointPath -> pointPath.type.equals((Object)PointPath.POINT_TYPE.DIFV)).count();
        if (difVPointCount > 0L) {
            aDif = AttenuationCnossos.getDeltaDif(srPath, data);
            Iterator iterator2 = noDifBands.iterator();
            while (iterator2.hasNext()) {
                int idf = (Integer)iterator2.next();
                aBoundary[idf] = aDif[idf] + aGround[idf];
            }
        }
        return aBoundary;
    }

    public static void init(AttenuationParameters data) {
        aGlobal = new double[data.getFrequencies().size()];
        freq_lambda = new double[data.getFrequencies().size()];
        for (int idf = 0; idf < data.getFrequencies().size(); ++idf) {
            AttenuationCnossos.freq_lambda[idf] = data.getFrequencies().get(idf) > 0 ? data.getCelerity() / (double)data.getFrequencies().get(idf).intValue() : 1.0;
        }
    }

    public static double[] aDiv(CnossosPath pathParameters, AttenuationParameters data) {
        double[] aDiv = new double[data.getFrequencies().size()];
        long difVPointCount = pathParameters.getPointList().stream().filter(pointPath -> pointPath.type.equals((Object)PointPath.POINT_TYPE.DIFV)).count();
        Arrays.fill(aDiv, AttenuationCnossos.getADiv(difVPointCount == 0L ? pathParameters.getSRSegment().d : pathParameters.getSRSegment().dc));
        return aDiv;
    }

    public static double[] aAtm(double[] alphaAtmosphericKm, double distance) {
        double[] aAtm = new double[alphaAtmosphericKm.length];
        for (int idfreq = 0; idfreq < aAtm.length; ++idfreq) {
            aAtm[idfreq] = AttenuationCnossos.getAAtm(distance, alphaAtmosphericKm[idfreq]);
        }
        return aAtm;
    }

    public static double[] evaluateAref(CnossosPath pathParameters, AttenuationParameters data) {
        return AttenuationCnossos.getARef(pathParameters, data);
    }

    public static double[] evaluate(CnossosPath pathParameters, AttenuationParameters data) {
        aGlobal = new double[data.getFrequencies().size()];
        freq_lambda = new double[data.getFrequencies().size()];
        for (int idf = 0; idf < data.getFrequencies().size(); ++idf) {
            AttenuationCnossos.freq_lambda[idf] = data.getFrequencies().get(idf) > 0 ? data.getCelerity() / (double)data.getFrequencies().get(idf).intValue() : 1.0;
        }
        double[] alpha_atmo = data.getAlpha_atmo();
        long refPointCount = pathParameters.getPointList().stream().filter(pointPath -> pointPath.type.equals((Object)PointPath.POINT_TYPE.REFL)).count();
        double aDiv = refPointCount > 0L ? AttenuationCnossos.getADiv(pathParameters.getSRSegment().dPath) : AttenuationCnossos.getADiv(pathParameters.getSRSegment().d);
        double[] aBoundary = AttenuationCnossos.getABoundary(pathParameters, data);
        double[] aRef = AttenuationCnossos.getARef(pathParameters, data);
        for (int idfreq = 0; idfreq < data.getFrequencies().size(); ++idfreq) {
            long verticalPivotPointCount = pathParameters.getPointList().stream().filter(pointPath -> pointPath.type.equals((Object)PointPath.POINT_TYPE.REFL) || pointPath.type.equals((Object)PointPath.POINT_TYPE.DIFV)).count();
            double aAtm = verticalPivotPointCount > 0L ? AttenuationCnossos.getAAtm(pathParameters.getSRSegment().dPath, alpha_atmo[idfreq]) : AttenuationCnossos.getAAtm(pathParameters.getSRSegment().d, alpha_atmo[idfreq]);
            AttenuationCnossos.aGlobal[idfreq] = -(aDiv + aAtm + aBoundary[idfreq] + aRef[idfreq]);
        }
        return aGlobal;
    }

    private static boolean isValidRcrit(CnossosPath pp, int freq, boolean favorable) {
        double lambda = 340.0 / (double)freq;
        return favorable ? pp.deltaF > -lambda / 20.0 && pp.deltaF > lambda / 4.0 - pp.deltaPrimeF || pp.deltaF > 0.0 : pp.deltaH > -lambda / 20.0 && pp.deltaH > lambda / 4.0 - pp.deltaPrimeH || pp.deltaH > 0.0;
    }

    public static double[] aBoundary(CnossosPath path, AttenuationParameters data) {
        double[] aGround = new double[data.getFrequencies().size()];
        double[] aDif = new double[data.getFrequencies().size()];
        List diffPts = path.getPointList().stream().filter(pointPath -> pointPath.type.equals((Object)PointPath.POINT_TYPE.DIFH_RCRIT) || pointPath.type.equals((Object)PointPath.POINT_TYPE.DIFH) || pointPath.type.equals((Object)PointPath.POINT_TYPE.DIFV)).collect(Collectors.toList());
        path.aBoundaryH.init(data.getFrequencies().size());
        path.aBoundaryF.init(data.getFrequencies().size());
        for (int i = 0; i < data.getFrequencies().size(); ++i) {
            int finalI = i;
            boolean isValidRCriterion = AttenuationCnossos.isValidRcrit(path, data.getFrequencies().get(finalI), path.isFavorable());
            PointPath first = diffPts.stream().filter(pp -> pp.type.equals((Object)PointPath.POINT_TYPE.DIFH) || pp.type.equals((Object)PointPath.POINT_TYPE.DIFV) || pp.type.equals((Object)PointPath.POINT_TYPE.DIFH_RCRIT) && isValidRCriterion).findFirst().orElse(null);
            double d = aGround[i] = path.isFavorable() ? AttenuationCnossos.aGroundF(path, path.getSRSegment(), data, i) : AttenuationCnossos.aGroundH(path, path.getSRSegment(), data, i);
            if (path.groundAttenuation != null && path.groundAttenuation.aGroundF != null) {
                if (path.isFavorable()) {
                    path.groundAttenuation.aGroundF[i] = aGround[i];
                } else {
                    path.groundAttenuation.aGroundH[i] = aGround[i];
                }
            }
            if (first != null) {
                aDif[i] = AttenuationCnossos.aDif(path, data, i, first.type);
                if (first.type.equals((Object)PointPath.POINT_TYPE.DIFV) || !isValidRCriterion) continue;
                aGround[i] = 0.0;
                continue;
            }
            aDif[i] = 0.0;
        }
        if (path.keepAbsorption) {
            if (path.isFavorable()) {
                path.aDifF = aDif;
            } else {
                path.aDifH = aDif;
            }
        }
        double[] aBoundary = new double[data.getFrequencies().size()];
        for (int i = 0; i < data.getFrequencies().size(); ++i) {
            aBoundary[i] = aGround[i] + aDif[i];
        }
        return aBoundary;
    }

    public static double[] deltaRetrodif(CnossosPath reflect, AttenuationParameters data) {
        double[] retroDiff = new double[data.getFrequencies().size()];
        Arrays.fill(retroDiff, 0.0);
        Coordinate originalS = reflect.getSRSegment().s;
        Coordinate originalR = reflect.getSRSegment().r;
        double SR = originalS.distance(originalR);
        Coordinate s = originalS;
        Coordinate r = originalR;
        List<PointPath> pointList = reflect.getPointList();
        for (int idPoint = 0; idPoint < pointList.size(); ++idPoint) {
            PointPath pointPath = pointList.get(idPoint);
            if (pointPath.type.equals((Object)PointPath.POINT_TYPE.DIFH)) {
                s = pointPath.coordinate;
                continue;
            }
            if (!pointPath.type.equals((Object)PointPath.POINT_TYPE.REFL)) continue;
            for (int idPointNext = 0; idPointNext < pointList.size(); ++idPointNext) {
                PointPath pointPathNext = pointList.get(idPoint);
                if (!pointPathNext.type.equals((Object)PointPath.POINT_TYPE.DIFH)) continue;
                r = pointPathNext.coordinate;
                break;
            }
            Coordinate p = new Coordinate(pointPath.coordinate.x, pointPath.obstacleZ);
            double ch = 1.0;
            if (reflect.isFavorable()) {
                double lambda;
                int i;
                double SP = s.distance(p);
                double PR = p.distance(r);
                double gamma = 2.0 * Math.max(1000.0, 8.0 * SR);
                double e = reflect.e;
                double SpO = gamma * Math.asin(SP / gamma);
                double OpR = gamma * Math.asin(PR / gamma);
                double SpR = gamma * Math.asin(s.distance(r) / gamma);
                double deltaPrime = -(SpO + OpR - SpR);
                if (e < 0.3) {
                    for (i = 0; i < data.getFrequencies().size(); ++i) {
                        double dLRetro;
                        lambda = 340.0 / (double)data.getFrequencies().get(i).intValue();
                        double testForm = 40.0 / lambda * deltaPrime;
                        retroDiff[i] = dLRetro = testForm >= -2.0 ? 10.0 * ch * Math.log10(3.0 + testForm) : 0.0;
                    }
                    continue;
                }
                for (i = 0; i < data.getFrequencies().size(); ++i) {
                    double dLRetro;
                    double Csecond;
                    lambda = 340.0 / (double)data.getFrequencies().get(i).intValue();
                    double testForm = 40.0 / lambda * (Csecond = 1.0 + 5.0 * lambda / e * 5.0 * lambda / e / 1.0 / 3.0 + 5.0 * lambda / e * 5.0 * lambda / e) * deltaPrime;
                    retroDiff[i] = dLRetro = testForm >= -2.0 ? 10.0 * ch * Math.log10(3.0 + testForm) : 0.0;
                }
                continue;
            }
            double deltaPrime = s.distance(r) - s.distance(p) - p.distance(r);
            for (int i = 0; i < data.getFrequencies().size(); ++i) {
                double dLRetro;
                double lambda = 340.0 / (double)data.getFrequencies().get(i).intValue();
                double testForm = 40.0 / lambda * deltaPrime;
                retroDiff[i] = dLRetro = testForm >= -2.0 ? 10.0 * ch * Math.log10(3.0 + testForm) : 0.0;
            }
        }
        return retroDiff;
    }

    private static double aDif(CnossosPath proPathParameters, AttenuationParameters data, int i, PointPath.POINT_TYPE type) {
        SegmentPath first = proPathParameters.getSegmentList().get(0);
        SegmentPath last = proPathParameters.getSegmentList().get(proPathParameters.getSegmentList().size() - 1);
        double ch = 1.0;
        double lambda = 340.0 / (double)data.getFrequencies().get(i).intValue();
        long difHCount = proPathParameters.getPointList().stream().filter(pointPath -> pointPath.type.equals((Object)PointPath.POINT_TYPE.DIFH)).count();
        long difVCount = proPathParameters.getPointList().stream().filter(pointPath -> pointPath.type.equals((Object)PointPath.POINT_TYPE.DIFV)).count();
        double cSecond = type.equals((Object)PointPath.POINT_TYPE.DIFH) && difHCount <= 1L || type.equals((Object)PointPath.POINT_TYPE.DIFV) && difVCount <= 1L || proPathParameters.e <= 0.3 ? 1.0 : (1.0 + Math.pow(5.0 * lambda / proPathParameters.e, 2.0)) / (0.3333333333333333 + Math.pow(5.0 * lambda / proPathParameters.e, 2.0));
        double _delta = proPathParameters.isFavorable() && (type.equals((Object)PointPath.POINT_TYPE.DIFH) || type.equals((Object)PointPath.POINT_TYPE.DIFH_RCRIT)) ? proPathParameters.deltaF : proPathParameters.deltaH;
        double deltaDStar = proPathParameters.getSegmentList().get((int)0).dPrime + proPathParameters.getSegmentList().get((int)(proPathParameters.getSegmentList().size() - 1)).dPrime - proPathParameters.getSRSegment().dPrime;
        double deltaDiffSR = 0.0;
        double testForm = 40.0 / lambda * cSecond * _delta;
        if (_delta >= 0.0 || _delta > -lambda / 20.0 && _delta > lambda / 4.0 - deltaDStar) {
            deltaDiffSR = testForm >= -2.0 ? 10.0 * ch * Math.log10(3.0 + testForm) : 0.0;
        } else if (type.equals((Object)PointPath.POINT_TYPE.DIFH)) {
            return 0.0;
        }
        if (type.equals((Object)PointPath.POINT_TYPE.DIFV)) {
            if (proPathParameters.keepAbsorption) {
                if (proPathParameters.isFavorable()) {
                    proPathParameters.aBoundaryF.deltaDiffSR[i] = deltaDiffSR;
                } else {
                    proPathParameters.aBoundaryH.deltaDiffSR[i] = deltaDiffSR;
                }
            }
            return deltaDiffSR;
        }
        _delta = proPathParameters.isFavorable() ? proPathParameters.deltaSPrimeRF : proPathParameters.deltaSPrimeRH;
        testForm = 40.0 / lambda * cSecond * _delta;
        double deltaDiffSPrimeR = testForm >= -2.0 ? 10.0 * ch * Math.log10(3.0 + testForm) : 0.0;
        _delta = proPathParameters.isFavorable() ? proPathParameters.deltaSRPrimeF : proPathParameters.deltaSRPrimeH;
        testForm = 40.0 / lambda * cSecond * _delta;
        double deltaDiffSRPrime = testForm >= -2.0 ? 10.0 * ch * Math.log10(3.0 + testForm) : 0.0;
        double aGroundSO = proPathParameters.isFavorable() ? AttenuationCnossos.aGroundF(proPathParameters, first, data, i) : AttenuationCnossos.aGroundH(proPathParameters, first, data, i);
        double aGroundOR = proPathParameters.isFavorable() ? AttenuationCnossos.aGroundF(proPathParameters, last, data, i, true) : AttenuationCnossos.aGroundH(proPathParameters, last, data, i, true);
        double deltaGroundSO = -20.0 * Math.log10(1.0 + (Math.pow(10.0, -aGroundSO / 20.0) - 1.0) * Math.pow(10.0, -(deltaDiffSPrimeR - deltaDiffSR) / 20.0));
        double deltaGroundOR = -20.0 * Math.log10(1.0 + (Math.pow(10.0, -aGroundOR / 20.0) - 1.0) * Math.pow(10.0, -(deltaDiffSRPrime - deltaDiffSR) / 20.0));
        if (Double.isNaN(deltaGroundSO)) {
            deltaGroundSO = aGroundSO;
            deltaDiffSR = deltaDiffSPrimeR;
        }
        if (Double.isNaN(deltaGroundOR)) {
            deltaGroundOR = aGroundOR;
            deltaDiffSR = deltaDiffSPrimeR;
        }
        double aDiff = Math.min(25.0, Math.max(0.0, deltaDiffSR)) + deltaGroundSO + deltaGroundOR;
        if (proPathParameters.keepAbsorption) {
            if (proPathParameters.isFavorable()) {
                proPathParameters.aBoundaryF.deltaDiffSR[i] = deltaDiffSR;
                proPathParameters.aBoundaryF.aGroundSO[i] = aGroundSO;
                proPathParameters.aBoundaryF.aGroundOR[i] = aGroundOR;
                proPathParameters.aBoundaryF.deltaDiffSPrimeR[i] = deltaDiffSPrimeR;
                proPathParameters.aBoundaryF.deltaDiffSRPrime[i] = deltaDiffSRPrime;
                proPathParameters.aBoundaryF.deltaGroundSO[i] = deltaGroundSO;
                proPathParameters.aBoundaryF.deltaGroundOR[i] = deltaGroundOR;
                proPathParameters.aBoundaryF.aDiff[i] = aDiff;
            } else {
                proPathParameters.aBoundaryH.deltaDiffSR[i] = deltaDiffSR;
                proPathParameters.aBoundaryH.aGroundSO[i] = aGroundSO;
                proPathParameters.aBoundaryH.aGroundOR[i] = aGroundOR;
                proPathParameters.aBoundaryH.deltaDiffSPrimeR[i] = deltaDiffSPrimeR;
                proPathParameters.aBoundaryH.deltaDiffSRPrime[i] = deltaDiffSRPrime;
                proPathParameters.aBoundaryH.deltaGroundSO[i] = deltaGroundSO;
                proPathParameters.aBoundaryH.deltaGroundOR[i] = deltaGroundOR;
                proPathParameters.aBoundaryH.aDiff[i] = aDiff;
            }
        }
        return aDiff;
    }

    private static double[] computeCfKValues(CnossosPath proPathParameters, SegmentPath path, AttenuationParameters data, int idFreq) {
        return AttenuationCnossos.computeCfKValues(proPathParameters, path, data, idFreq, false);
    }

    private static double[] computeCfKValues(CnossosPath proPathParameters, SegmentPath path, AttenuationParameters data, int idFreq, boolean forceGPath) {
        int fm = data.getFrequencies().get(idFreq);
        double c = data.getCelerity();
        double dp = path.dp;
        double k = Math.PI * 2 * (double)fm / c;
        double gw = forceGPath ? path.gPath : (proPathParameters.isFavorable() ? path.gPath : path.gPathPrime);
        double w = 0.0185 * Math.pow(fm, 2.5) * Math.pow(gw, 2.6) / (Math.pow(fm, 1.5) * Math.pow(gw, 2.6) + 1300.0 * Math.pow(fm, 0.75) * Math.pow(gw, 1.3) + 1160000.0);
        double cf = dp * (1.0 + 3.0 * w * dp * Math.exp(-Math.sqrt(w * dp))) / (1.0 + w * dp);
        return new double[]{cf, k, w};
    }

    public static double aGroundH(CnossosPath proPathParameters, SegmentPath path, AttenuationParameters data, int idFreq) {
        return AttenuationCnossos.aGroundH(proPathParameters, path, data, idFreq, false);
    }

    public static double aGroundH(CnossosPath proPathParameters, SegmentPath path, AttenuationParameters data, int idFreq, boolean forceGPath) {
        double[] values = AttenuationCnossos.computeCfKValues(proPathParameters, path, data, idFreq, forceGPath);
        double cf = values[0];
        double k = values[1];
        double w = values[2];
        if (proPathParameters.keepAbsorption && path == proPathParameters.getSRSegment()) {
            proPathParameters.groundAttenuation.wH[idFreq] = w;
            proPathParameters.groundAttenuation.cfH[idFreq] = cf;
        }
        if (path.gPath == 0.0) {
            return -3.0;
        }
        double dp = path.dp;
        double gm = forceGPath ? path.gPath : path.gPathPrime;
        double aGroundHMin = -3.0 * (1.0 - gm);
        double zs = path.zsH;
        double zr = path.zrH;
        double aGroundHComputed = -10.0 * Math.log10(4.0 * (k * k) / (dp * dp) * (zs * zs - Math.sqrt(2.0 * cf / k) * zs + cf / k) * (zr * zr - Math.sqrt(2.0 * cf / k) * zr + cf / k));
        return Math.max(aGroundHComputed, aGroundHMin);
    }

    public static double aGroundF(CnossosPath proPathParameters, SegmentPath path, AttenuationParameters data, int idFreq) {
        return AttenuationCnossos.aGroundF(proPathParameters, path, data, idFreq, false);
    }

    public static double aGroundF(CnossosPath proPathParameters, SegmentPath path, AttenuationParameters data, int idFreq, boolean forceGPath) {
        double aGroundFMin;
        double[] values = AttenuationCnossos.computeCfKValues(proPathParameters, path, data, idFreq);
        double cf = values[0];
        double k = values[1];
        double w = values[2];
        if (proPathParameters.keepAbsorption && path == proPathParameters.getSRSegment()) {
            proPathParameters.groundAttenuation.wF[idFreq] = w;
            proPathParameters.groundAttenuation.cfF[idFreq] = cf;
        }
        double gm = forceGPath ? path.gPath : path.gPathPrime;
        double d = aGroundFMin = path.testFormH <= 1.0 ? -3.0 * (1.0 - gm) : -3.0 * (1.0 - gm) * (1.0 + 2.0 * (1.0 - 1.0 / path.testFormH));
        if (path.gPath == 0.0) {
            return aGroundFMin;
        }
        double dp = path.dp;
        double zs = path.zsF;
        double zr = path.zrF;
        double aGroundFComputed = -10.0 * Math.log10(4.0 * (k * k) / (dp * dp) * (zs * zs - Math.sqrt(2.0 * cf / k) * zs + cf / k) * (zr * zr - Math.sqrt(2.0 * cf / k) * zr + cf / k));
        return Math.max(aGroundFComputed, aGroundFMin);
    }

    public static double[] computeCnossosAttenuation(AttenuationParameters data, CnossosPath proPathParameters, SceneWithAttenuation scene, boolean exportAttenuationMatrix) {
        double[] aRetroDiff;
        double[] aBoundary;
        if (data == null) {
            return new double[0];
        }
        double[] frequencies = new double[]{};
        if (scene != null) {
            frequencies = scene.profileBuilder.frequencyArray.stream().mapToDouble(value -> value.intValue()).toArray();
        }
        if (exportAttenuationMatrix) {
            proPathParameters.keepAbsorption = true;
            proPathParameters.groundAttenuation.init(data.getFrequencies().size());
            proPathParameters.init(data.getFrequencies().size());
        }
        AttenuationCnossos.init(data);
        double[] aDiv = AttenuationCnossos.aDiv(proPathParameters, data);
        double[] aAtm = AttenuationCnossos.aAtm(data.getAlpha_atmo(), proPathParameters.getSRSegment().d);
        double[] aRef = AttenuationCnossos.evaluateAref(proPathParameters, data);
        if (exportAttenuationMatrix) {
            proPathParameters.aRef = (double[])aRef.clone();
        }
        double[] aGlobalMeteoHom = new double[data.getFrequencies().size()];
        double[] aGlobalMeteoFav = new double[data.getFrequencies().size()];
        double[] deltaBodyScreen = new double[data.getFrequencies().size()];
        List<PointPath> ptList = proPathParameters.getPointList();
        double hRail = 0.5;
        Coordinate src = ptList.get((int)0).coordinate;
        PointPath pDif = ptList.stream().filter(p -> p.type.equals((Object)PointPath.POINT_TYPE.DIFH)).findFirst().orElse(null);
        if (pDif != null && !pDif.alphaWall.isEmpty() && pDif.bodyBarrier) {
            int n = 3;
            Coordinate rcv = ptList.get((int)(ptList.size() - 1)).coordinate;
            double[][] deltaGeo = new double[n + 1][data.getFrequencies().size()];
            double[][] deltaAbs = new double[n + 1][data.getFrequencies().size()];
            double[][] deltaDif = new double[n + 1][data.getFrequencies().size()];
            double[][] deltaRef = new double[n + 1][data.getFrequencies().size()];
            double[][] deltaRetroDifi = new double[n + 1][data.getFrequencies().size()];
            double[][] deltaRetroDif = new double[n + 1][data.getFrequencies().size()];
            double[] deltaL = new double[data.getFrequencies().size()];
            Arrays.fill(deltaL, AcousticIndicatorsFunctions.dBToW((double)0.0));
            double db = pDif.coordinate.x;
            double hb = pDif.coordinate.y;
            Coordinate B = new Coordinate(db, hb);
            double Cref = 1.0;
            double dr = rcv.x;
            double h0 = ptList.get((int)0).altitude + hRail;
            double hs = ptList.get((int)0).altitude + src.y - hRail;
            double hr = ptList.get((int)(ptList.size() - 1)).altitude + ptList.get((int)(ptList.size() - 1)).coordinate.y - h0;
            double[] r = new double[4];
            if (db < 5.0 * hb) {
                for (int idfreq = 0; idfreq < data.getFrequencies().size(); ++idfreq) {
                    int i;
                    if (!(pDif.alphaWall.get(idfreq) < 0.8)) continue;
                    double dif0 = 0.0;
                    double ch = 1.0;
                    double lambda = 340.0 / (double)data.getFrequencies().get(idfreq).intValue();
                    double hi = hs;
                    double cSecond = 1.0;
                    for (i = 0; i <= n; ++i) {
                        double di = (double)(-2 * i) * db;
                        Coordinate si = new Coordinate(src.x + di, src.y);
                        r[i] = Math.sqrt(Math.pow(di - (db + dr), 2.0) + Math.pow(hi - hr, 2.0));
                        deltaGeo[i][idfreq] = 20.0 * Math.log10(r[0] / r[i]);
                        double deltai = si.distance(B) + B.distance(rcv) - si.distance(rcv);
                        double dif = 0.0;
                        double testForm = 40.0 / lambda * cSecond * deltai;
                        if (testForm >= -2.0) {
                            dif = 10.0 * ch * Math.log10(3.0 + testForm);
                        }
                        if (i == 0) {
                            dif0 = dif;
                            deltaRetroDif[i][idfreq] = dif;
                        } else {
                            deltaDif[i][idfreq] = dif0 - dif;
                        }
                        deltaAbs[i][idfreq] = (double)(10 * i) * Math.log10(1.0 - pDif.alphaWall.get(idfreq));
                        deltaRef[i][idfreq] = (double)(10 * i) * Math.log10(Cref);
                        double retroDif = 0.0;
                        Coordinate Pi = new Coordinate((double)(-(2 * i - 1)) * db, hb);
                        Coordinate RcvPrime = new Coordinate(dr, Math.max(hr, hb * (db + dr - di) / (db - di)));
                        deltai = -(si.distance(Pi) + Pi.distance(RcvPrime) - si.distance(RcvPrime));
                        testForm = 40.0 / lambda * cSecond * deltai;
                        if (testForm >= -2.0) {
                            retroDif = 10.0 * ch * Math.log10(3.0 + testForm);
                        }
                        deltaRetroDifi[i][idfreq] = i == 0 ? 0.0 : retroDif;
                    }
                    deltaRetroDif[0][idfreq] = 0.0;
                    for (i = 1; i <= n; ++i) {
                        double sumRetrodif = 0.0;
                        for (int j = 1; j <= i; ++j) {
                            sumRetrodif += deltaRetroDifi[j][idfreq];
                        }
                        deltaRetroDif[i][idfreq] = -sumRetrodif;
                    }
                    for (i = 0; i <= n; ++i) {
                        deltaL[idfreq] = deltaL[idfreq] + AcousticIndicatorsFunctions.dBToW((double)(deltaGeo[i][idfreq] + deltaDif[i][idfreq] + deltaAbs[i][idfreq] + deltaRef[i][idfreq] + deltaRetroDif[i][idfreq]));
                    }
                }
                deltaBodyScreen = AcousticIndicatorsFunctions.wToDb((double[])deltaL);
            }
        }
        Vector3D fieldVectorPropagation = Orientation.rotate((Orientation)proPathParameters.getSourceOrientation(), (Vector3D)Orientation.toVector((Orientation)proPathParameters.raySourceReceiverDirectivity), (boolean)false);
        int roseIndex = AttenuationParameters.getRoseIndex(Math.atan2(fieldVectorPropagation.getY(), fieldVectorPropagation.getX()));
        if (data.getWindRose()[roseIndex] != 1.0) {
            proPathParameters.setFavorable(false);
            aBoundary = AttenuationCnossos.aBoundary(proPathParameters, data);
            aRetroDiff = AttenuationCnossos.deltaRetrodif(proPathParameters, data);
            for (int idfreq = 0; idfreq < data.getFrequencies().size(); ++idfreq) {
                aGlobalMeteoHom[idfreq] = -(aDiv[idfreq] + aAtm[idfreq] + aBoundary[idfreq] - aRef[idfreq] + aRetroDiff[idfreq] - deltaBodyScreen[idfreq]);
            }
            if (exportAttenuationMatrix) {
                proPathParameters.aRetroDiffH = (double[])aRetroDiff.clone();
                proPathParameters.double_aBoundaryH = (double[])aBoundary.clone();
                proPathParameters.aGlobalH = (double[])aGlobalMeteoHom.clone();
            }
        }
        if (data.getWindRose()[roseIndex] != 0.0) {
            proPathParameters.setFavorable(true);
            aBoundary = AttenuationCnossos.aBoundary(proPathParameters, data);
            aRetroDiff = AttenuationCnossos.deltaRetrodif(proPathParameters, data);
            for (int idfreq = 0; idfreq < data.getFrequencies().size(); ++idfreq) {
                aGlobalMeteoFav[idfreq] = -(aDiv[idfreq] + aAtm[idfreq] + aBoundary[idfreq] - aRef[idfreq] + aRetroDiff[idfreq] - deltaBodyScreen[idfreq]);
            }
            if (exportAttenuationMatrix) {
                proPathParameters.double_aBoundaryF = (double[])aBoundary.clone();
                proPathParameters.aRetroDiffF = (double[])aRetroDiff.clone();
                proPathParameters.aGlobalF = (double[])aGlobalMeteoFav.clone();
            }
        }
        if (exportAttenuationMatrix) {
            proPathParameters.keepAbsorption = true;
            proPathParameters.aDiv = (double[])aDiv.clone();
            proPathParameters.aAtm = (double[])aAtm.clone();
        }
        double[] aGlobalMeteoRay = AcousticIndicatorsFunctions.sumArrayWithPonderation((double[])aGlobalMeteoFav, (double[])aGlobalMeteoHom, (double)data.getWindRose()[roseIndex]);
        int sourceId = proPathParameters.getCutProfile().getSource().id;
        double sourceLi = proPathParameters.getCutProfile().getSource().li;
        if (scene != null && !scene.isOmnidirectional(sourceId)) {
            Orientation directivityToPick = proPathParameters.raySourceReceiverDirectivity;
            double[] attSource = scene.getSourceAttenuation(sourceId, frequencies, Math.toRadians(directivityToPick.yaw), Math.toRadians(directivityToPick.pitch));
            if (exportAttenuationMatrix) {
                proPathParameters.aSource = attSource;
            }
            aGlobalMeteoRay = AcousticIndicatorsFunctions.sumArray((double[])aGlobalMeteoRay, (double[])attSource);
        }
        if (sourceLi > 1.0) {
            for (int i = 0; i < aGlobalMeteoRay.length; ++i) {
                aGlobalMeteoRay[i] = AcousticIndicatorsFunctions.wToDb((double)(AcousticIndicatorsFunctions.dBToW((double)aGlobalMeteoRay[i]) * sourceLi));
            }
        }
        if (exportAttenuationMatrix) {
            proPathParameters.aGlobal = (double[])aGlobalMeteoRay.clone();
        }
        return aGlobalMeteoRay;
    }

    static {
        LOGGER = LoggerFactory.getLogger(AttenuationCnossos.class);
    }
}

