/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.propagation.cnossos;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.locationtech.jts.algorithm.CGAlgorithms3D;
import org.locationtech.jts.algorithm.ConvexHull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.math.Vector2D;
import org.locationtech.jts.math.Vector3D;
import org.locationtech.jts.triangulate.quadedge.Vertex;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPoint;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointReceiver;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointReflection;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointSource;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointTopography;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointVEdgeDiffraction;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointWall;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutProfile;
import org.noise_planet.noisemodelling.pathfinder.utils.geometry.GeometryUtils;
import org.noise_planet.noisemodelling.pathfinder.utils.geometry.JTSUtility;
import org.noise_planet.noisemodelling.pathfinder.utils.geometry.Orientation;
import org.noise_planet.noisemodelling.propagation.cnossos.CnossosPath;
import org.noise_planet.noisemodelling.propagation.cnossos.PointPath;
import org.noise_planet.noisemodelling.propagation.cnossos.SegmentPath;

public class CnossosPathBuilder {
    public static final double ALPHA0 = 2.0E-4;
    private static final double EPSILON = 1.0E-7;

    public static void computeRayleighDiff(SegmentPath srSeg, CutProfile cutProfile, CnossosPath pathParameters, LineSegment dSR, List<SegmentPath> segments, List<PointPath> points, List<Coordinate> pts2D, Coordinate[] pts2DGround, List<Integer> cut2DGroundIndex, List<Double> exactFrequencyArray) {
        ArrayList cuts = cutProfile.cutPoints;
        Coordinate src = pts2D.get(0);
        Coordinate rcv = pts2D.get(pts2D.size() - 1);
        CutPointSource srcCut = cutProfile.getSource();
        CutPointReceiver rcvCut = cutProfile.getReceiver();
        for (int i0Cut = 1; i0Cut < cuts.size() - 1; ++i0Cut) {
            int iO = cut2DGroundIndex.get(i0Cut);
            Coordinate o = pts2DGround[iO];
            double dSO = src.distance(o);
            double dOR = o.distance(rcv);
            double deltaH = (double)dSR.orientationIndex(o) * (dSO + dOR - srSeg.d);
            boolean rcrit = false;
            for (double f : exactFrequencyArray) {
                if (!(deltaH > -(340.0 / f) / 20.0)) continue;
                rcrit = true;
                break;
            }
            if (!rcrit) continue;
            rcrit = false;
            Coordinate[] soCoords = Arrays.copyOfRange(pts2DGround, 0, iO + 1);
            double[] abs = JTSUtility.getMeanPlaneCoefficients((Coordinate[])soCoords);
            SegmentPath seg1 = CnossosPathBuilder.computeSegment(src, o, abs);
            Coordinate[] orCoords = Arrays.copyOfRange(pts2DGround, iO, pts2DGround.length);
            double[] abr = JTSUtility.getMeanPlaneCoefficients((Coordinate[])orCoords);
            SegmentPath seg2 = CnossosPathBuilder.computeSegment(o, rcv, abr);
            Coordinate srcPrime = new Coordinate(src.x + (seg1.sMeanPlane.x - src.x) * 2.0, src.y + (seg1.sMeanPlane.y - src.y) * 2.0);
            Coordinate rcvPrime = new Coordinate(rcv.x + (seg2.rMeanPlane.x - rcv.x) * 2.0, rcv.y + (seg2.rMeanPlane.y - rcv.y) * 2.0);
            LineSegment dSPrimeRPrime = new LineSegment(srcPrime, rcvPrime);
            srSeg.dPrime = srcPrime.distance(rcvPrime);
            seg1.dPrime = srcPrime.distance(o);
            seg2.dPrime = o.distance(rcvPrime);
            double deltaPrimeH = (double)dSPrimeRPrime.orientationIndex(o) * (seg1.dPrime + seg2.dPrime - srSeg.dPrime);
            for (double f : exactFrequencyArray) {
                if (!(deltaH > 340.0 / f / 4.0 - deltaPrimeH)) continue;
                rcrit = true;
                break;
            }
            if (!rcrit) continue;
            pathParameters.deltaH = deltaH;
            pathParameters.deltaPrimeH = deltaPrimeH;
            seg1.setGpath(cutProfile.getGPath((CutPoint)srcCut, (CutPoint)cuts.get(i0Cut), 0.0), srcCut.getGroundCoefficient());
            seg2.setGpath(cutProfile.getGPath((CutPoint)cuts.get(i0Cut), (CutPoint)rcvCut, 0.0), srcCut.getGroundCoefficient());
            if (dSR.orientationIndex(o) == 1) {
                pathParameters.deltaF = CnossosPathBuilder.toCurve(dSO, srSeg.d) + CnossosPathBuilder.toCurve(dOR, srSeg.d) - CnossosPathBuilder.toCurve(srSeg.d, srSeg.d);
            } else {
                Coordinate pA = dSR.pointAlong((o.x - src.x) / (rcv.x - src.x));
                pathParameters.deltaF = 2.0 * CnossosPathBuilder.toCurve(src.distance(pA), srSeg.d) + 2.0 * CnossosPathBuilder.toCurve(pA.distance(rcv), srSeg.d) - CnossosPathBuilder.toCurve(dSO, srSeg.d) - CnossosPathBuilder.toCurve(dOR, srSeg.d) - CnossosPathBuilder.toCurve(srSeg.d, srSeg.d);
            }
            LineSegment sPrimeR = new LineSegment(seg1.sPrime, rcv);
            double dSPrimeO = seg1.sPrime.distance(o);
            double dSPrimeR = seg1.sPrime.distance(rcv);
            pathParameters.deltaSPrimeRH = (double)sPrimeR.orientationIndex(o) * (dSPrimeO + dOR - dSPrimeR);
            LineSegment sRPrime = new LineSegment(src, seg2.rPrime);
            double dORPrime = o.distance(seg2.rPrime);
            double dSRPrime = src.distance(seg2.rPrime);
            pathParameters.deltaSRPrimeH = (double)sRPrime.orientationIndex(o) * (dSO + dORPrime - dSRPrime);
            if (dSPrimeRPrime.orientationIndex(o) == 1) {
                pathParameters.deltaPrimeF = CnossosPathBuilder.toCurve(seg1.dPrime, srSeg.dPrime) + CnossosPathBuilder.toCurve(seg2.dPrime, srSeg.dPrime) - CnossosPathBuilder.toCurve(srSeg.dPrime, srSeg.dPrime);
            } else {
                Coordinate pA = dSPrimeRPrime.pointAlong((o.x - srcPrime.x) / (rcvPrime.x - srcPrime.x));
                pathParameters.deltaPrimeF = 2.0 * CnossosPathBuilder.toCurve(srcPrime.distance(pA), srSeg.dPrime) + 2.0 * CnossosPathBuilder.toCurve(pA.distance(srcPrime), srSeg.dPrime) - CnossosPathBuilder.toCurve(seg1.dPrime, srSeg.dPrime) - CnossosPathBuilder.toCurve(seg2.dPrime, srSeg.d) - CnossosPathBuilder.toCurve(srSeg.dPrime, srSeg.dPrime);
            }
            segments.add(seg1);
            segments.add(seg2);
            points.add(new PointPath(o, o.z, new ArrayList<Double>(), PointPath.POINT_TYPE.DIFH_RCRIT));
        }
    }

    public static SegmentPath computeSegment(Coordinate src, Coordinate rcv, double[] meanPlane) {
        return CnossosPathBuilder.computeSegment(src, rcv, meanPlane, 0.0, 0.0);
    }

    public static SegmentPath computeSegment(Coordinate src, Coordinate rcv, double[] meanPlane, double gPath, double gS) {
        SegmentPath seg = new SegmentPath();
        Coordinate sourcePointOnMeanPlane = GeometryUtils.projectPointOnLine((Coordinate)src, (double)meanPlane[0], (double)meanPlane[1]);
        Coordinate receiverPointOnMeanPlane = GeometryUtils.projectPointOnLine((Coordinate)rcv, (double)meanPlane[0], (double)meanPlane[1]);
        Vector2D sourceToProjectedPoint = Vector2D.create((Coordinate)src, (Coordinate)sourcePointOnMeanPlane);
        Vector2D receiverToProjectedPoint = Vector2D.create((Coordinate)rcv, (Coordinate)receiverPointOnMeanPlane);
        seg.s = src;
        seg.r = rcv;
        seg.sMeanPlane = sourcePointOnMeanPlane;
        seg.rMeanPlane = receiverPointOnMeanPlane;
        seg.sPrime = Vector2D.create((Coordinate)sourcePointOnMeanPlane).add(sourceToProjectedPoint).toCoordinate();
        seg.rPrime = Vector2D.create((Coordinate)receiverPointOnMeanPlane).add(receiverToProjectedPoint).toCoordinate();
        seg.d = src.distance(rcv);
        seg.dp = sourcePointOnMeanPlane.distance(receiverPointOnMeanPlane);
        seg.zsH = src.distance(sourcePointOnMeanPlane);
        seg.zrH = rcv.distance(receiverPointOnMeanPlane);
        seg.a = meanPlane[0];
        seg.b = meanPlane[1];
        seg.testFormH = seg.dp / (30.0 * (seg.zsH + seg.zrH));
        seg.gPath = gPath;
        seg.gPathPrime = seg.testFormH <= 1.0 ? seg.gPath * seg.testFormH + gS * (1.0 - seg.testFormH) : seg.gPath;
        double deltaZT = 0.006 * seg.dp / (seg.zsH + seg.zrH);
        double deltaZS = 2.0E-4 * Math.pow(seg.zsH / (seg.zsH + seg.zrH), 2.0) * (seg.dp * seg.dp / 2.0);
        seg.zsF = seg.zsH + deltaZS + deltaZT;
        double deltaZR = 2.0E-4 * Math.pow(seg.zrH / (seg.zsH + seg.zrH), 2.0) * (seg.dp * seg.dp / 2.0);
        seg.zrF = seg.zrH + deltaZR + deltaZT;
        seg.testFormF = seg.dp / (30.0 * (seg.zsF + seg.zrF));
        return seg;
    }

    public static double toCurve(double mn, double d) {
        return 2.0 * Math.max(1000.0, 8.0 * d) * Math.asin(mn / (2.0 * Math.max(1000.0, 8.0 * d)));
    }

    public static CnossosPath computeCnossosPathFromCutProfile(CutProfile cutProfile, boolean bodyBarrier, List<Double> exactFrequencyArray, double gS) {
        Coordinate pA;
        int i1;
        ArrayList<SegmentPath> segments = new ArrayList<SegmentPath>();
        ArrayList<PointPath> points = new ArrayList<PointPath>();
        ArrayList cutProfilePoints = cutProfile.cutPoints;
        List pts2D = cutProfile.computePts2D();
        if (pts2D.size() != cutProfilePoints.size()) {
            throw new IllegalArgumentException("The two arrays size should be the same");
        }
        ArrayList<Integer> cut2DGroundIndex = new ArrayList<Integer>(cutProfilePoints.size());
        Coordinate[] pts2DGround = cutProfile.computePts2DGround(cut2DGroundIndex).toArray(new Coordinate[0]);
        double[] meanPlane = JTSUtility.getMeanPlaneCoefficients((Coordinate[])pts2DGround);
        Coordinate firstPts2D = (Coordinate)pts2D.get(0);
        Coordinate lastPts2D = (Coordinate)pts2D.get(pts2D.size() - 1);
        SegmentPath srPath = CnossosPathBuilder.computeSegment(firstPts2D, lastPts2D, meanPlane, cutProfile.getGPath(), cutProfile.getSource().groundCoefficient);
        srPath.setPoints2DGround(pts2DGround);
        srPath.dc = CGAlgorithms3D.distance((Coordinate)cutProfile.getReceiver().getCoordinate(), (Coordinate)cutProfile.getSource().getCoordinate());
        CnossosPath pathParameters = new CnossosPath(cutProfile);
        pathParameters.setFavorable(true);
        pathParameters.setPointList(points);
        pathParameters.setSegmentList(segments);
        pathParameters.setSRSegment(srPath);
        pathParameters.init(exactFrequencyArray.size());
        Coordinate firstPt = (Coordinate)pts2D.get(0);
        Coordinate lastPt = (Coordinate)pts2D.get(pts2D.size() - 1);
        ArrayList<Coordinate> convexHullInput = new ArrayList<Coordinate>();
        convexHullInput.add((Coordinate)pts2D.get(0));
        for (int idPoint = 1; idPoint < cutProfilePoints.size() - 1; ++idPoint) {
            CutPoint currentPoint = (CutPoint)cutProfilePoints.get(idPoint);
            if (!(currentPoint instanceof CutPointTopography) && (!(currentPoint instanceof CutPointWall) || Double.compare(currentPoint.getCoordinate().z, currentPoint.getzGround()) == 0)) continue;
            convexHullInput.add((Coordinate)pts2D.get(idPoint));
        }
        convexHullInput.add((Coordinate)pts2D.get(pts2D.size() - 1));
        List<Object> convexHullPoints = new ArrayList();
        if (convexHullInput.size() > 2) {
            GeometryFactory geomFactory = new GeometryFactory();
            Coordinate[] coordsArray = convexHullInput.toArray(new Coordinate[0]);
            ConvexHull convexHull = new ConvexHull(coordsArray, geomFactory);
            Coordinate[] convexHullCoords = convexHull.getConvexHull().getCoordinates();
            int indexFirst = Arrays.asList(convexHull.getConvexHull().getCoordinates()).indexOf(firstPt);
            int indexLast = Arrays.asList(convexHull.getConvexHull().getCoordinates()).lastIndexOf(lastPt);
            if (indexFirst == -1 || indexLast == -1 || indexFirst > indexLast) {
                throw new IllegalArgumentException("Wrong input data " + cutProfile.toString());
            }
            convexHullCoords = Arrays.copyOfRange(convexHullCoords, indexFirst, indexLast + 1);
            CoordinateSequence coordSequence = geomFactory.getCoordinateSequenceFactory().create(convexHullCoords);
            LineString geom = geomFactory.createLineString(coordSequence);
            Geometry uniqueGeom = geom.union();
            convexHullCoords = uniqueGeom.getCoordinates();
            if (convexHullCoords.length == 3) {
                convexHullPoints = Arrays.asList(convexHullCoords);
            } else {
                for (int j = 0; j < convexHullCoords.length; ++j) {
                    if (convexHullCoords[j].y == Double.MAX_VALUE || Double.isInfinite(convexHullCoords[j].y)) continue;
                    convexHullPoints.add(convexHullCoords[j]);
                }
            }
        } else {
            convexHullPoints = convexHullInput;
        }
        ArrayList pts = convexHullPoints;
        Coordinate src = cutProfile.getSource().getCoordinate();
        if (pts.size() > 2) {
            for (int i = 1; i < pts.size(); ++i) {
                int i0 = pts2D.indexOf(pts.get(i - 1));
                i1 = pts2D.indexOf(pts.get(i));
                LineSegment segmentHull = new LineSegment((Coordinate)pts.get(i - 1), (Coordinate)pts.get(i));
                for (int pointIndex = i0 + 1; pointIndex < i1; ++pointIndex) {
                    CutPoint currentPoint = (CutPoint)cutProfilePoints.get(pointIndex);
                    if (!(currentPoint instanceof CutPointReflection) || Double.compare(currentPoint.getCoordinate().z, currentPoint.getzGround()) == 0) continue;
                    CutPointReflection cutPointReflection = (CutPointReflection)currentPoint;
                    Coordinate interpolatedReflectionPoint = segmentHull.closestPoint((Coordinate)pts2D.get(pointIndex));
                    double wallAltitudeAtReflexionPoint = Vertex.interpolateZ((Coordinate)currentPoint.coordinate, (Coordinate)cutPointReflection.wall.p0, (Coordinate)cutPointReflection.wall.p1);
                    if (wallAltitudeAtReflexionPoint + 1.0E-7 >= interpolatedReflectionPoint.y) {
                        currentPoint.getCoordinate().setZ(interpolatedReflectionPoint.y);
                        ((Coordinate)pts2D.get(pointIndex)).setY(interpolatedReflectionPoint.y);
                        continue;
                    }
                    return null;
                }
            }
        }
        for (int i = 1; i < pts.size(); ++i) {
            CutPoint currentPoint;
            int i0 = pts2D.indexOf(pts.get(i - 1));
            i1 = pts2D.indexOf(pts.get(i));
            int i0Ground = (Integer)cut2DGroundIndex.get(i0);
            int i1Ground = (Integer)cut2DGroundIndex.get(i1);
            CutPoint cutPt0 = (CutPoint)cutProfilePoints.get(i0);
            CutPoint cutPt1 = (CutPoint)cutProfilePoints.get(i1);
            if (i1Ground - 1 > i0Ground && cutPt1 instanceof CutPointWall) {
                CutPointWall cutPt1Wall = (CutPointWall)cutPt1;
                if (cutPt1Wall.intersectionType.equals((Object)CutPointWall.INTERSECTION_TYPE.BUILDING_ENTER)) {
                    --i1Ground;
                } else if (cutPt1Wall.intersectionType.equals((Object)CutPointWall.INTERSECTION_TYPE.THIN_WALL_ENTER_EXIT)) {
                    i1Ground -= 2;
                }
            }
            if (points.isEmpty()) {
                Orientation emissionDirection;
                points.add(new PointPath((Coordinate)pts2D.get(i0), cutPt0.getzGround(), PointPath.POINT_TYPE.SRCE));
                Coordinate targetPosition = ((CutPoint)cutProfilePoints.get(i1)).getCoordinate();
                for (int pointIndex = i0 + 1; pointIndex < i1; ++pointIndex) {
                    currentPoint = (CutPoint)cutProfilePoints.get(pointIndex);
                    if (!(currentPoint instanceof CutPointReflection) && !(currentPoint instanceof CutPointVEdgeDiffraction) || Double.compare(currentPoint.getCoordinate().z, currentPoint.getzGround()) == 0) continue;
                    targetPosition = currentPoint.getCoordinate();
                    break;
                }
                ((PointPath)points.get((int)0)).orientation = emissionDirection = CnossosPathBuilder.computeOrientation(cutProfile.getSource().orientation, ((CutPoint)cutProfilePoints.get(i0)).getCoordinate(), targetPosition);
                pathParameters.raySourceReceiverDirectivity = emissionDirection;
                src = (Coordinate)pts2D.get(i0);
            }
            int previousPivotPoint = i0;
            for (int pointIndex = i0 + 1; pointIndex < i1; ++pointIndex) {
                currentPoint = (CutPoint)cutProfilePoints.get(pointIndex);
                if (currentPoint instanceof CutPointReflection && Double.compare(currentPoint.getCoordinate().z, currentPoint.getzGround()) != 0) {
                    CutPointReflection cutPointReflection = (CutPointReflection)currentPoint;
                    double wallAltitudeAtReflexionPoint = Vertex.interpolateZ((Coordinate)cutPointReflection.coordinate, (Coordinate)cutPointReflection.wall.p0, (Coordinate)cutPointReflection.wall.p1);
                    PointPath reflectionPoint = new PointPath((Coordinate)pts2D.get(pointIndex), (double)currentPoint.getzGround(), cutPointReflection.wallAlpha, PointPath.POINT_TYPE.REFL);
                    reflectionPoint.obstacleZ = wallAltitudeAtReflexionPoint;
                    points.add(reflectionPoint);
                    continue;
                }
                if (!(currentPoint instanceof CutPointVEdgeDiffraction)) continue;
                PointPath diffractionPoint = new PointPath((Coordinate)pts2D.get(pointIndex), (double)currentPoint.getzGround(), new ArrayList<Double>(), PointPath.POINT_TYPE.DIFV);
                points.add(diffractionPoint);
                Coordinate[] segmentGroundPoints = Arrays.copyOfRange(pts2DGround, i0Ground, (Integer)cut2DGroundIndex.get(pointIndex) + 1);
                meanPlane = JTSUtility.getMeanPlaneCoefficients((Coordinate[])segmentGroundPoints);
                SegmentPath seg = CnossosPathBuilder.computeSegment((Coordinate)pts2D.get(previousPivotPoint), (Coordinate)pts2D.get(pointIndex), meanPlane, cutProfile.getGPath(cutPt0, (CutPoint)cutProfilePoints.get(pointIndex), 0.0), gS);
                seg.setPoints2DGround(segmentGroundPoints);
                previousPivotPoint = pointIndex;
                segments.add(seg);
            }
            points.add(new PointPath((Coordinate)pts2D.get(i1), cutPt1.getzGround(), PointPath.POINT_TYPE.RECV));
            if (previousPivotPoint != i0 && i == pts.size() - 1) {
                Coordinate[] segmentGroundPoints = Arrays.copyOfRange(pts2DGround, i1Ground, pts2DGround.length);
                meanPlane = JTSUtility.getMeanPlaneCoefficients((Coordinate[])segmentGroundPoints);
                SegmentPath seg = CnossosPathBuilder.computeSegment((Coordinate)pts2D.get(previousPivotPoint), (Coordinate)pts2D.get(pts2D.size() - 1), meanPlane, cutProfile.getGPath(cutPt1, (CutPoint)cutProfilePoints.get(cutProfilePoints.size() - 1), 0.0), gS);
                seg.setPoints2DGround(segmentGroundPoints);
                segments.add(seg);
            }
            if (pts.size() == 2) break;
            Coordinate[] segmentGroundPoints = Arrays.copyOfRange(pts2DGround, i0Ground, i1Ground + 1);
            meanPlane = JTSUtility.getMeanPlaneCoefficients((Coordinate[])segmentGroundPoints);
            SegmentPath path = CnossosPathBuilder.computeSegment((Coordinate)pts2D.get(i0), (Coordinate)pts2D.get(i1), meanPlane, cutProfile.getGPath((CutPoint)cutProfilePoints.get(i0), (CutPoint)cutProfilePoints.get(i1), 0.0), ((CutPoint)cutProfilePoints.get((int)i0)).groundCoefficient);
            path.dc = cutPt0.getCoordinate().distance3D(cutPt1.getCoordinate());
            path.setPoints2DGround(segmentGroundPoints);
            segments.add(path);
            if (i == pts.size() - 1) continue;
            PointPath pt = (PointPath)points.get(points.size() - 1);
            pt.type = PointPath.POINT_TYPE.DIFH;
            pt.bodyBarrier = bodyBarrier;
            if (!(cutPt1 instanceof CutPointWall)) continue;
            pt.alphaWall = ((CutPointWall)cutPt1).wallAlpha;
        }
        if (points.isEmpty()) {
            return null;
        }
        Coordinate rcv = ((PointPath)points.get((int)(points.size() - 1))).coordinate;
        PointPath p0 = points.stream().filter(p -> p.type.equals((Object)PointPath.POINT_TYPE.DIFH)).findFirst().orElse(null);
        if (p0 == null) {
            boolean horizontalPlaneDiffraction = cutProfile.cutPoints.stream().anyMatch(cutPoint -> cutPoint instanceof CutPointVEdgeDiffraction);
            ArrayList<SegmentPath> rayleighSegments = new ArrayList<SegmentPath>();
            ArrayList<PointPath> rayleighPoints = new ArrayList<PointPath>();
            if (!horizontalPlaneDiffraction) {
                LineSegment dSR = new LineSegment(firstPts2D, lastPts2D);
                CnossosPathBuilder.computeRayleighDiff(srPath, cutProfile, pathParameters, dSR, rayleighSegments, rayleighPoints, pts2D, pts2DGround, cut2DGroundIndex, exactFrequencyArray);
            }
            if (rayleighSegments.isEmpty()) {
                if (segments.isEmpty()) {
                    segments.add(pathParameters.getSRSegment());
                }
                pathParameters.e = 0.0;
                List diffPoints = points.stream().filter(pointPath -> pointPath.type != PointPath.POINT_TYPE.REFL).collect(Collectors.toList());
                for (int idPoint = 1; idPoint < diffPoints.size() - 2; ++idPoint) {
                    pathParameters.e += ((PointPath)diffPoints.get((int)idPoint)).coordinate.distance(((PointPath)diffPoints.get((int)(idPoint + 1))).coordinate);
                }
                long difVPointCount = pathParameters.getPointList().stream().filter(pointPath -> pointPath.type.equals((Object)PointPath.POINT_TYPE.DIFV)).count();
                double distance = difVPointCount == 0L ? pathParameters.getSRSegment().d : pathParameters.getSRSegment().dc;
                pathParameters.deltaF = pathParameters.deltaH = ((SegmentPath)segments.get((int)0)).d + pathParameters.e + ((SegmentPath)segments.get((int)(segments.size() - 1))).d - distance;
            } else {
                segments.addAll(rayleighSegments);
                points.addAll(1, rayleighPoints);
            }
            return pathParameters;
        }
        Coordinate c0 = p0.coordinate;
        PointPath pn = points.stream().filter(p -> p.type.equals((Object)PointPath.POINT_TYPE.DIFH)).reduce((first, second) -> second).orElse(null);
        if (pn == null) {
            return null;
        }
        Coordinate cn = pn.coordinate;
        SegmentPath seg1 = (SegmentPath)segments.get(0);
        SegmentPath seg2 = (SegmentPath)segments.get(segments.size() - 1);
        double dSO0 = seg1.d;
        double dOnR = seg2.d;
        LineSegment sr = new LineSegment(src, rcv);
        LineSegment sPrimeR = new LineSegment(seg1.sPrime, rcv);
        double dSPrimeR = seg1.sPrime.distance(rcv);
        double dSPrimeO = seg1.sPrime.distance(c0);
        pathParameters.e = 0.0;
        List diffPoints = points.stream().filter(pointPath -> pointPath.type != PointPath.POINT_TYPE.REFL).collect(Collectors.toList());
        for (int idPoint = 1; idPoint < diffPoints.size() - 2; ++idPoint) {
            pathParameters.e += ((PointPath)diffPoints.get((int)idPoint)).coordinate.distance(((PointPath)diffPoints.get((int)(idPoint + 1))).coordinate);
        }
        pathParameters.deltaSPrimeRH = (double)sPrimeR.orientationIndex(c0) * (dSPrimeO + pathParameters.e + dOnR - dSPrimeR);
        pathParameters.deltaSPrimeRF = CnossosPathBuilder.toCurve(dSPrimeO, dSPrimeR) + CnossosPathBuilder.toCurve(pathParameters.e, dSPrimeR) + CnossosPathBuilder.toCurve(dOnR, dSPrimeR) - CnossosPathBuilder.toCurve(dSPrimeR, dSPrimeR);
        LineSegment sRPrime = new LineSegment(src, seg2.rPrime);
        double dSRPrime = src.distance(seg2.rPrime);
        double dORPrime = cn.distance(seg2.rPrime);
        pathParameters.deltaSRPrimeH = (double)((src.x > seg2.rPrime.x ? -1 : 1) * sRPrime.orientationIndex(cn)) * (dSO0 + pathParameters.e + dORPrime - dSRPrime);
        pathParameters.deltaSRPrimeF = CnossosPathBuilder.toCurve(dSO0, dSRPrime) + CnossosPathBuilder.toCurve(pathParameters.e, dSRPrime) + CnossosPathBuilder.toCurve(dORPrime, dSRPrime) - CnossosPathBuilder.toCurve(dSRPrime, dSRPrime);
        Coordinate srcPrime = new Coordinate(src.x + (seg1.sMeanPlane.x - src.x) * 2.0, src.y + (seg1.sMeanPlane.y - src.y) * 2.0);
        Coordinate rcvPrime = new Coordinate(rcv.x + (seg2.rMeanPlane.x - rcv.x) * 2.0, rcv.y + (seg2.rMeanPlane.y - rcv.y) * 2.0);
        LineSegment dSPrimeRPrime = new LineSegment(srcPrime, rcvPrime);
        srPath.dPrime = srcPrime.distance(rcvPrime);
        seg1.dPrime = srcPrime.distance(c0);
        seg2.dPrime = cn.distance(rcvPrime);
        long difVPointCount = pathParameters.getPointList().stream().filter(pointPath -> pointPath.type.equals((Object)PointPath.POINT_TYPE.DIFV)).count();
        double distance = difVPointCount == 0L ? pathParameters.getSRSegment().d : pathParameters.getSRSegment().dc;
        pathParameters.deltaH = (double)sr.orientationIndex(c0) * (dSO0 + pathParameters.e + dOnR - distance);
        if (sr.orientationIndex(c0) == 1) {
            pathParameters.deltaF = CnossosPathBuilder.toCurve(seg1.d, srPath.d) + CnossosPathBuilder.toCurve(pathParameters.e, srPath.d) + CnossosPathBuilder.toCurve(seg2.d, srPath.d) - CnossosPathBuilder.toCurve(srPath.d, srPath.d);
        } else {
            pA = sr.pointAlong((c0.x - srcPrime.x) / (rcvPrime.x - srcPrime.x));
            pathParameters.deltaF = 2.0 * CnossosPathBuilder.toCurve(srcPrime.distance(pA), srPath.dPrime) + 2.0 * CnossosPathBuilder.toCurve(pA.distance(rcvPrime), srPath.dPrime) - CnossosPathBuilder.toCurve(seg1.dPrime, srPath.dPrime) - CnossosPathBuilder.toCurve(seg2.dPrime, srPath.dPrime) - CnossosPathBuilder.toCurve(srPath.dPrime, srPath.dPrime);
        }
        pathParameters.deltaPrimeH = (double)dSPrimeRPrime.orientationIndex(c0) * (seg1.dPrime + pathParameters.e + seg2.dPrime - srPath.dPrime);
        pathParameters.deltaPrimeH = (double)dSPrimeRPrime.orientationIndex(c0) * (seg1.dPrime + seg2.dPrime - srPath.dPrime);
        if (dSPrimeRPrime.orientationIndex(c0) == 1) {
            pathParameters.deltaPrimeF = CnossosPathBuilder.toCurve(seg1.dPrime, srPath.dPrime) + CnossosPathBuilder.toCurve(seg2.dPrime, srPath.dPrime) - CnossosPathBuilder.toCurve(srPath.dPrime, srPath.dPrime);
        } else {
            pA = dSPrimeRPrime.pointAlong((c0.x - srcPrime.x) / (rcvPrime.x - srcPrime.x));
            pathParameters.deltaPrimeF = 2.0 * CnossosPathBuilder.toCurve(srcPrime.distance(pA), srPath.dPrime) + 2.0 * CnossosPathBuilder.toCurve(pA.distance(srcPrime), srPath.dPrime) - CnossosPathBuilder.toCurve(seg1.dPrime, srPath.dPrime) - CnossosPathBuilder.toCurve(seg2.dPrime, srPath.d) - CnossosPathBuilder.toCurve(srPath.dPrime, srPath.dPrime);
        }
        return pathParameters;
    }

    private static Orientation computeOrientation(Orientation sourceOrientation, Coordinate src, Coordinate next) {
        if (sourceOrientation == null) {
            return null;
        }
        Vector3D outgoingRay = new Vector3D(new Coordinate(next.x - src.x, next.y - src.y, next.z - src.z)).normalize();
        return Orientation.fromVector((Vector3D)Orientation.rotate((Orientation)sourceOrientation, (Vector3D)outgoingRay, (boolean)true), (double)0.0);
    }
}

