/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.propagation.cnossos;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.ProfileBuilder;
import org.noise_planet.noisemodelling.pathfinder.utils.geometry.Orientation;
import org.noise_planet.noisemodelling.propagation.cnossos.Path;

public class PointPath {
    public Coordinate coordinate;
    public double altitude;
    public List<Double> alphaWall = Collections.unmodifiableList(Arrays.asList(0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1));
    public int buildingId = -1;
    public int wallId = -1;
    public double e = 0.0;
    public Orientation orientation;
    public double obstacleZ;
    public POINT_TYPE type;
    public boolean bodyBarrier = false;

    public PointPath(Coordinate coordinate, double altitude, List<Double> alphaWall, int buildingId, POINT_TYPE type) {
        this.coordinate = coordinate;
        this.altitude = altitude;
        this.alphaWall = alphaWall;
        this.buildingId = buildingId;
        this.type = type;
    }

    public void setObstacleZ(double obstacleZ) {
        this.obstacleZ = obstacleZ;
    }

    public double getObstacleZ() {
        return this.obstacleZ;
    }

    public PointPath(Coordinate coordinate, double altitude, List<Double> alphaWall, POINT_TYPE type) {
        this.coordinate = coordinate;
        this.altitude = altitude;
        this.alphaWall = alphaWall;
        this.type = type;
    }

    public PointPath(Coordinate coordinate, double altitude, POINT_TYPE type) {
        this(coordinate, altitude, new ArrayList<Double>(), type);
    }

    public PointPath(Coordinate coordinate, double altitude, double[] alphaWall, POINT_TYPE type) {
        this.coordinate = coordinate;
        this.altitude = altitude;
        this.alphaWall = new ArrayList<Double>(alphaWall.length);
        for (double a : alphaWall) {
            this.alphaWall.add(a);
        }
        this.type = type;
    }

    public PointPath() {
    }

    public void writeStream(DataOutputStream out) throws IOException {
        Path.writeCoordinate(out, this.coordinate);
        out.writeDouble(this.altitude);
        out.writeShort(this.alphaWall.size());
        for (Double bandAlpha : this.alphaWall) {
            out.writeDouble(bandAlpha);
        }
        out.writeInt(this.buildingId);
        out.writeInt(this.type.ordinal());
    }

    public void readStream(DataInputStream in) throws IOException {
        this.coordinate = Path.readCoordinate(in);
        this.altitude = in.readDouble();
        int nbFreq = in.readShort();
        ArrayList<Double> readAlpha = new ArrayList<Double>(nbFreq);
        for (int j = 0; j < nbFreq; ++j) {
            readAlpha.add(in.readDouble());
        }
        this.alphaWall = readAlpha;
        this.buildingId = in.readInt();
        this.type = POINT_TYPE.values()[in.readInt()];
    }

    public void setType(POINT_TYPE type) {
        this.type = type;
    }

    public void setAlphaWall(List<Double> alphaWall) {
        this.alphaWall = new ArrayList<Double>(alphaWall);
    }

    public int getBuildingId() {
        return this.buildingId;
    }

    public int getWallId() {
        return this.wallId;
    }

    public void setBuildingId(int id) {
        this.buildingId = id;
        this.wallId = -1;
    }

    public void setWallId(int id) {
        this.wallId = id;
        this.buildingId = -1;
    }

    public void setCoordinate(Coordinate coordinate) {
        this.coordinate = coordinate;
    }

    public POINT_TYPE toPointType(ProfileBuilder.IntersectionType intersectionType, POINT_TYPE defaultPointType) {
        if (intersectionType.equals((Object)ProfileBuilder.IntersectionType.SOURCE)) {
            return POINT_TYPE.SRCE;
        }
        if (intersectionType.equals((Object)ProfileBuilder.IntersectionType.RECEIVER)) {
            return POINT_TYPE.RECV;
        }
        return defaultPointType;
    }

    public static enum POINT_TYPE {
        SRCE,
        REFL,
        DIFV,
        DIFH,
        RECV,
        DIFH_RCRIT;

    }
}

