/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.propagation.cnossos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.math.Vector3D;
import org.noise_planet.noisemodelling.propagation.cnossos.Path;

@JsonAutoDetect(isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE)
public class SegmentPath {
    private transient Coordinate[] points2DGround = new Coordinate[0];
    public double gPath;
    public Vector3D meanGdPlane;
    public Coordinate pInit;
    public Coordinate s;
    public Coordinate r;
    public double a;
    public double b;
    public int idPtStart;
    public int idPtFinal;
    public Double gPathPrime = null;
    public Double gw = null;
    public Double gm = null;
    public Double zsH = null;
    public Double zrH = null;
    public Double testFormH = null;
    public Coordinate sMeanPlane = null;
    public Coordinate rMeanPlane = null;
    public Coordinate sPrime = null;
    public Coordinate rPrime = null;
    public Double zsF = null;
    public Double zrF = null;
    public Double testFormF = null;
    public Double dPath;
    public Double d;
    public Double dc;
    public Double dp;
    public Double eLength = 0.0;
    public Double delta = 1.0;
    public double dPrime;
    public double deltaPrime;

    public Coordinate[] getPoints2DGround() {
        return this.points2DGround;
    }

    public void setPoints2DGround(Coordinate[] points2DGround) {
        this.points2DGround = points2DGround;
    }

    public void setDelta(Double delta) {
        this.delta = delta;
    }

    public Double getDelta() {
        return this.delta;
    }

    public SegmentPath(double gPath, Vector3D meanGdPlane, Coordinate pInit) {
        this.gPath = gPath;
        this.meanGdPlane = meanGdPlane;
        this.pInit = pInit;
    }

    public SegmentPath() {
    }

    public void writeStream(DataOutputStream out) throws IOException {
        out.writeDouble(this.gPath);
        Path.writeVector(out, this.meanGdPlane);
        Path.writeCoordinate(out, this.pInit);
    }

    public void readStream(DataInputStream in) throws IOException {
        this.gPath = in.readDouble();
        this.meanGdPlane = Path.readVector(in);
        this.pInit = Path.readCoordinate(in);
    }

    public void setGw(double g) {
        this.gw = g;
    }

    public void setGm(double g) {
        this.gm = g;
    }

    public void setGpath(double gPath, double gS) {
        this.gPath = gPath;
        this.gPathPrime = this.testFormH <= 1.0 ? this.gPath * this.testFormH + gS * (1.0 - this.testFormH) : this.gPath;
    }

    public Double getGw() {
        return this.gw;
    }

    public Double getGm() {
        return this.gm;
    }

    public Double getgPathPrime() {
        return this.gPathPrime;
    }

    public Double getZs() {
        return this.zsH;
    }

    public Double getZr() {
        return this.zrH;
    }

    public Double getZsPrime() {
        return this.zsF;
    }

    public Double getZrPrime() {
        return this.zrF;
    }
}

