/*
 * Decompiled with CFR 0.152.
 */
package org.orcid.jaxb.model.clientgroup;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;
import org.orcid.jaxb.model.message.ScopePathType;

@XmlType(name="client-type")
@XmlEnum
public enum ClientType {
    CREATOR("creator"),
    PREMIUM_CREATOR("premium-creator"),
    UPDATER("updater"),
    PREMIUM_UPDATER("premium-updater"),
    PUBLIC_CLIENT("public-client");

    private final String value;

    private ClientType(String v) {
        this.value = v;
    }

    public String value() {
        return this.value;
    }

    @JsonValue
    public String jsonValue() {
        return this.name();
    }

    public static ClientType fromValue(String v) {
        for (ClientType c : ClientType.values()) {
            if (!c.value.equals(v)) continue;
            return c;
        }
        throw new IllegalArgumentException(v);
    }

    public static Set<String> getScopes(ClientType clientType) {
        switch (clientType) {
            case PREMIUM_CREATOR: {
                return ClientType.premiumCreatorScopes();
            }
            case CREATOR: {
                return ClientType.creatorScopes();
            }
            case PREMIUM_UPDATER: {
                return ClientType.premiumUpdaterScopes();
            }
            case UPDATER: {
                return ClientType.updaterScopes();
            }
            case PUBLIC_CLIENT: {
                return new HashSet<String>(ScopePathType.getScopesAsStrings(ScopePathType.AUTHENTICATE, ScopePathType.READ_PUBLIC, ScopePathType.OPENID));
            }
        }
        throw new IllegalArgumentException("Unsupported client type: " + (Object)((Object)clientType));
    }

    public static Set<String> premiumCreatorScopes() {
        Set<String> creatorScopes = ClientType.creatorScopes();
        ClientType.addPremiumOnlyScopes(creatorScopes);
        return creatorScopes;
    }

    public static Set<String> creatorScopes() {
        return ScopePathType.ORCID_PROFILE_CREATE.getCombinedAsStrings();
    }

    public static Set<String> premiumUpdaterScopes() {
        Set<String> updaterScopes = ClientType.updaterScopes();
        ClientType.addPremiumOnlyScopes(updaterScopes);
        return updaterScopes;
    }

    public static Set<String> updaterScopes() {
        return new HashSet<String>(ScopePathType.getScopesAsStrings(ScopePathType.AFFILIATIONS_CREATE, ScopePathType.AFFILIATIONS_READ_LIMITED, ScopePathType.AFFILIATIONS_UPDATE, ScopePathType.AUTHENTICATE, ScopePathType.FUNDING_CREATE, ScopePathType.FUNDING_READ_LIMITED, ScopePathType.FUNDING_UPDATE, ScopePathType.ORCID_BIO_EXTERNAL_IDENTIFIERS_CREATE, ScopePathType.ORCID_BIO_READ_LIMITED, ScopePathType.ORCID_BIO_UPDATE, ScopePathType.ORCID_PROFILE_READ_LIMITED, ScopePathType.ORCID_WORKS_CREATE, ScopePathType.ORCID_WORKS_READ_LIMITED, ScopePathType.ORCID_WORKS_UPDATE, ScopePathType.READ_PUBLIC, ScopePathType.ACTIVITIES_UPDATE, ScopePathType.PERSON_UPDATE, ScopePathType.ACTIVITIES_READ_LIMITED, ScopePathType.READ_LIMITED, ScopePathType.PERSON_READ_LIMITED, ScopePathType.PEER_REVIEW_CREATE, ScopePathType.PEER_REVIEW_UPDATE, ScopePathType.PEER_REVIEW_READ_LIMITED, ScopePathType.GROUP_ID_RECORD_READ, ScopePathType.GROUP_ID_RECORD_UPDATE, ScopePathType.OPENID));
    }

    private static void addPremiumOnlyScopes(Set<String> scopes) {
        scopes.add(ScopePathType.WEBHOOK.value());
    }
}

