/*
 * Decompiled with CFR 0.152.
 */
package org.orcid.jaxb.model.message;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="scope-path-type")
@XmlEnum
public enum ScopePathType implements Serializable
{
    READ_PUBLIC("/read-public", new ScopePathType[0]),
    AUTHENTICATE("/authenticate", READ_PUBLIC),
    ORCID_BIO_EXTERNAL_IDENTIFIERS_CREATE("/orcid-bio/external-identifiers/create", READ_PUBLIC),
    ORCID_BIO_READ_LIMITED("/orcid-bio/read-limited", READ_PUBLIC),
    ORCID_BIO_UPDATE("/orcid-bio/update", ORCID_BIO_EXTERNAL_IDENTIFIERS_CREATE),
    AFFILIATIONS_CREATE("/affiliations/create", READ_PUBLIC),
    AFFILIATIONS_READ_LIMITED("/affiliations/read-limited", READ_PUBLIC),
    AFFILIATIONS_UPDATE("/affiliations/update", READ_PUBLIC),
    FUNDING_CREATE("/funding/create", READ_PUBLIC),
    FUNDING_READ_LIMITED("/funding/read-limited", READ_PUBLIC),
    FUNDING_UPDATE("/funding/update", READ_PUBLIC),
    ORCID_PATENTS_CREATE("/orcid-patents/create", READ_PUBLIC),
    ORCID_PATENTS_READ_LIMITED("/orcid-patents/read-limited", READ_PUBLIC),
    ORCID_PATENTS_UPDATE("/orcid-patents/update", READ_PUBLIC),
    PEER_REVIEW_CREATE("/peer-review/create", READ_PUBLIC),
    PEER_REVIEW_READ_LIMITED("/peer-review/read-limited", READ_PUBLIC),
    PEER_REVIEW_UPDATE("/peer-review/update", READ_PUBLIC),
    ORCID_WORKS_CREATE("/orcid-works/create", READ_PUBLIC),
    ORCID_WORKS_READ_LIMITED("/orcid-works/read-limited", READ_PUBLIC),
    ORCID_WORKS_UPDATE("/orcid-works/update", READ_PUBLIC),
    PERSON_READ_LIMITED("/person/read-limited", ORCID_BIO_READ_LIMITED),
    PERSON_UPDATE("/person/update", ORCID_BIO_UPDATE),
    ACTIVITIES_READ_LIMITED("/activities/read-limited", ORCID_WORKS_READ_LIMITED, AFFILIATIONS_READ_LIMITED, FUNDING_READ_LIMITED, PEER_REVIEW_READ_LIMITED, ORCID_PATENTS_READ_LIMITED),
    ACTIVITIES_UPDATE("/activities/update", ORCID_WORKS_CREATE, ORCID_WORKS_UPDATE, AFFILIATIONS_CREATE, AFFILIATIONS_UPDATE, FUNDING_CREATE, FUNDING_UPDATE, PEER_REVIEW_CREATE, PEER_REVIEW_UPDATE, ORCID_PATENTS_CREATE, ORCID_PATENTS_UPDATE),
    READ_LIMITED("/read-limited", ACTIVITIES_READ_LIMITED, PERSON_READ_LIMITED),
    ORCID_PROFILE_READ_LIMITED("/orcid-profile/read-limited", READ_LIMITED),
    EMAIL_READ_PRIVATE("/email/read-private", READ_PUBLIC),
    WEBHOOK("/webhook", new ScopePathType[0]),
    GROUP_ID_RECORD_READ("/group-id-record/read", new ScopePathType[0]),
    GROUP_ID_RECORD_UPDATE("/group-id-record/update", GROUP_ID_RECORD_READ),
    OPENID("openid", AUTHENTICATE, READ_PUBLIC),
    ORCID_PROFILE_CREATE("/orcid-profile/create", AUTHENTICATE, ACTIVITIES_UPDATE, PERSON_UPDATE, ORCID_PROFILE_READ_LIMITED, PEER_REVIEW_CREATE, PEER_REVIEW_UPDATE, PEER_REVIEW_READ_LIMITED, GROUP_ID_RECORD_READ, GROUP_ID_RECORD_UPDATE, OPENID),
    BASIC_NOTIFICATION("/basic-notification", new ScopePathType[0]),
    PREMIUM_NOTIFICATION("/premium-notification", BASIC_NOTIFICATION),
    INTERNAL_PERSON_LAST_MODIFIED("/orcid-internal/person/last_modified", new ScopePathType[0]),
    IDENTIFIER_TYPES_CREATE("/identifier-types/create", new ScopePathType[0]);

    private final String value;
    Set<ScopePathType> combined;
    static Map<String, ScopePathType> mapByValue;

    private ScopePathType(String value, ScopePathType ... inherited) {
        this.value = value;
        if (this.combined == null) {
            this.combined = new HashSet<ScopePathType>();
        }
        for (ScopePathType scope : inherited) {
            this.combine(scope);
        }
        this.combined.add(this);
    }

    private void combine(ScopePathType scope) {
        Set<ScopePathType> toCombine = scope.combined();
        if (toCombine != null) {
            for (ScopePathType other : toCombine) {
                if (other.equals(scope) || other.combined() == null || other.combined().isEmpty()) continue;
                for (ScopePathType childScope : other.combined()) {
                    this.combine(childScope);
                }
            }
        }
        this.combined.add(scope);
    }

    public String value() {
        return this.value;
    }

    public String getContent() {
        return this.value;
    }

    public static ScopePathType fromValue(String scopeString) {
        if (mapByValue.containsKey(scopeString)) {
            return mapByValue.get(scopeString);
        }
        throw new IllegalArgumentException(scopeString);
    }

    public Set<ScopePathType> combined() {
        return this.combined;
    }

    public boolean isReadOnlyScope() {
        switch (this) {
            case ORCID_BIO_READ_LIMITED: {
                return true;
            }
            case ORCID_PROFILE_READ_LIMITED: {
                return true;
            }
            case ORCID_WORKS_READ_LIMITED: {
                return true;
            }
            case FUNDING_READ_LIMITED: {
                return true;
            }
            case AFFILIATIONS_READ_LIMITED: {
                return true;
            }
            case PEER_REVIEW_READ_LIMITED: {
                return true;
            }
            case ORCID_PATENTS_READ_LIMITED: {
                return true;
            }
            case ACTIVITIES_READ_LIMITED: {
                return true;
            }
            case READ_LIMITED: {
                return true;
            }
            case PERSON_READ_LIMITED: {
                return true;
            }
            case OPENID: {
                return true;
            }
        }
        return false;
    }

    public boolean isClientCreditalScope() {
        switch (this) {
            case ORCID_PROFILE_CREATE: {
                return true;
            }
            case READ_PUBLIC: {
                return true;
            }
            case WEBHOOK: {
                return true;
            }
            case PREMIUM_NOTIFICATION: {
                return true;
            }
            case GROUP_ID_RECORD_READ: {
                return true;
            }
            case GROUP_ID_RECORD_UPDATE: {
                return true;
            }
        }
        return false;
    }

    public boolean isUserGrantWriteScope() {
        switch (this) {
            case AFFILIATIONS_UPDATE: {
                return true;
            }
            case AFFILIATIONS_CREATE: {
                return true;
            }
            case ORCID_WORKS_UPDATE: {
                return true;
            }
            case ORCID_WORKS_CREATE: {
                return true;
            }
            case ORCID_BIO_EXTERNAL_IDENTIFIERS_CREATE: {
                return true;
            }
            case ORCID_BIO_UPDATE: {
                return true;
            }
            case ORCID_PROFILE_CREATE: {
                return false;
            }
            case FUNDING_CREATE: {
                return true;
            }
            case FUNDING_UPDATE: {
                return true;
            }
            case ORCID_PATENTS_CREATE: {
                return true;
            }
            case ORCID_PATENTS_UPDATE: {
                return true;
            }
            case ACTIVITIES_UPDATE: {
                return true;
            }
            case PERSON_UPDATE: {
                return true;
            }
        }
        return false;
    }

    public boolean isInternalScope() {
        switch (this) {
            case INTERNAL_PERSON_LAST_MODIFIED: {
                return true;
            }
        }
        return false;
    }

    public Set<String> getCombinedAsStrings() {
        return ScopePathType.getScopesAsStrings(this.combined());
    }

    public boolean hasScope(ScopePathType scope) {
        return this.combined.contains(scope);
    }

    public boolean hasScope(String scope) {
        return this.hasScope(ScopePathType.fromValue(scope));
    }

    public static boolean hasStringScope(String scope, ScopePathType required) {
        return ScopePathType.fromValue(scope).combined().contains(required);
    }

    public static Set<ScopePathType> getScopesFromStrings(Collection<String> scopes) {
        HashSet<ScopePathType> newScopes = new HashSet<ScopePathType>();
        for (String scopeString : scopes) {
            ScopePathType scope = mapByValue.get(scopeString);
            if (scope == null) continue;
            newScopes.add(scope);
        }
        return newScopes;
    }

    public static Set<String> getCombinedScopesFromStringsAsStrings(Collection<String> scopes) {
        HashSet<String> newScopes = new HashSet<String>();
        for (String scopeString : scopes) {
            ScopePathType scope = mapByValue.get(scopeString);
            if (scope == null) continue;
            newScopes.addAll(ScopePathType.getScopesAsStrings(scope.combined()));
        }
        return newScopes;
    }

    public static Set<ScopePathType> getScopesFromSpaceSeparatedString(String scopesString) {
        if (scopesString == null) {
            return null;
        }
        return ScopePathType.getScopesFromStrings(Arrays.asList(scopesString.split("\\s")));
    }

    public static Set<String> getScopesAsStrings(Collection<ScopePathType> scopes) {
        HashSet<String> scopeStrings = new HashSet<String>();
        for (ScopePathType scope : scopes) {
            scopeStrings.add(scope.value());
        }
        return scopeStrings;
    }

    public static String getScopesAsSingleString(Collection<ScopePathType> scopes) {
        StringBuilder sb = new StringBuilder();
        for (ScopePathType scope : scopes) {
            sb.append(scope.value() + " ");
        }
        return sb.toString().trim();
    }

    public static Set<String> getScopesAsStrings(ScopePathType ... scopes) {
        return ScopePathType.getScopesAsStrings(Arrays.asList(scopes));
    }

    static {
        mapByValue = new HashMap<String, ScopePathType>();
        for (ScopePathType scope : ScopePathType.values()) {
            mapByValue.put(scope.value(), scope);
        }
    }
}

