/*
 * Decompiled with CFR 0.152.
 */
package org.orcid.jaxb.model.record_rc2;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.orcid.jaxb.model.common_rc2.Url;
import org.orcid.jaxb.model.message.WorkExternalIdentifier;
import org.orcid.jaxb.model.message.WorkExternalIdentifierType;
import org.orcid.jaxb.model.record_rc2.GroupAble;
import org.orcid.jaxb.model.record_rc2.Relationship;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"type", "value", "url", "relationship"})
public class ExternalID
implements GroupAble,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="external-id-type", namespace="http://www.orcid.org/ns/common", required=true)
    protected String type;
    @XmlElement(name="external-id-value", namespace="http://www.orcid.org/ns/common", required=true)
    protected String value;
    @XmlElement(name="external-id-url", namespace="http://www.orcid.org/ns/common")
    protected Url url;
    @XmlElement(name="external-id-relationship", namespace="http://www.orcid.org/ns/common")
    protected Relationship relationship;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Relationship getRelationship() {
        return this.relationship;
    }

    public void setRelationship(Relationship relationship) {
        this.relationship = relationship;
    }

    public Url getUrl() {
        return this.url;
    }

    public void setUrl(Url url) {
        this.url = url;
    }

    @Override
    @JsonIgnore
    public String getGroupId() {
        String workIdVal = this.value == null ? null : this.value;
        String typeVal = this.type == null ? null : this.type;
        return workIdVal + typeVal;
    }

    @Override
    @JsonIgnore
    public boolean isGroupAble() {
        if (Relationship.PART_OF.equals(this.relationship)) {
            return false;
        }
        if (this.getValue() == null || this.getValue().isEmpty()) {
            return false;
        }
        return !WorkExternalIdentifierType.ISSN.value().equals(this.getType());
    }

    public static ExternalID fromMessageExtId(WorkExternalIdentifier oldExtId) {
        ExternalID id = new ExternalID();
        id.setType(oldExtId.getWorkExternalIdentifierType().value());
        id.setValue(oldExtId.getWorkExternalIdentifierId().getContent());
        return id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExternalID other = (ExternalID)obj;
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public ExternalID clone() {
        ExternalID id = new ExternalID();
        id.type = this.getType();
        id.value = this.getValue();
        if (this.getUrl() != null) {
            id.url = new Url(this.getUrl().getValue());
        }
        if (this.getRelationship() != null) {
            id.relationship = this.getRelationship();
        }
        return id;
    }
}

