/*
 * Decompiled with CFR 0.152.
 */
package org.orcid.jaxb.model.v3.rc1.record.summary;

import io.swagger.annotations.ApiModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.orcid.jaxb.model.record.util.RecordUtil;
import org.orcid.jaxb.model.v3.rc1.common.LastModifiedDate;
import org.orcid.jaxb.model.v3.rc1.record.ActivitiesContainer;
import org.orcid.jaxb.model.v3.rc1.record.Activity;
import org.orcid.jaxb.model.v3.rc1.record.SourceAware;
import org.orcid.jaxb.model.v3.rc1.record.summary.AffiliationGroup;
import org.orcid.jaxb.model.v3.rc1.record.summary.DistinctionSummary;
import org.orcid.jaxb.model.v3.rc1.record.summary.Distinctions;
import org.orcid.jaxb.model.v3.rc1.record.summary.EducationSummary;
import org.orcid.jaxb.model.v3.rc1.record.summary.Educations;
import org.orcid.jaxb.model.v3.rc1.record.summary.EmploymentSummary;
import org.orcid.jaxb.model.v3.rc1.record.summary.Employments;
import org.orcid.jaxb.model.v3.rc1.record.summary.FundingGroup;
import org.orcid.jaxb.model.v3.rc1.record.summary.FundingSummary;
import org.orcid.jaxb.model.v3.rc1.record.summary.Fundings;
import org.orcid.jaxb.model.v3.rc1.record.summary.InvitedPositionSummary;
import org.orcid.jaxb.model.v3.rc1.record.summary.InvitedPositions;
import org.orcid.jaxb.model.v3.rc1.record.summary.MembershipSummary;
import org.orcid.jaxb.model.v3.rc1.record.summary.Memberships;
import org.orcid.jaxb.model.v3.rc1.record.summary.PeerReviewDuplicateGroup;
import org.orcid.jaxb.model.v3.rc1.record.summary.PeerReviewGroup;
import org.orcid.jaxb.model.v3.rc1.record.summary.PeerReviewSummary;
import org.orcid.jaxb.model.v3.rc1.record.summary.PeerReviews;
import org.orcid.jaxb.model.v3.rc1.record.summary.QualificationSummary;
import org.orcid.jaxb.model.v3.rc1.record.summary.Qualifications;
import org.orcid.jaxb.model.v3.rc1.record.summary.ResearchResourceGroup;
import org.orcid.jaxb.model.v3.rc1.record.summary.ResearchResourceSummary;
import org.orcid.jaxb.model.v3.rc1.record.summary.ResearchResources;
import org.orcid.jaxb.model.v3.rc1.record.summary.ServiceSummary;
import org.orcid.jaxb.model.v3.rc1.record.summary.Services;
import org.orcid.jaxb.model.v3.rc1.record.summary.WorkGroup;
import org.orcid.jaxb.model.v3.rc1.record.summary.WorkSummary;
import org.orcid.jaxb.model.v3.rc1.record.summary.Works;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"lastModifiedDate", "distinctions", "educations", "employments", "fundings", "invitedPositions", "memberships", "peerReviews", "qualifications", "researchResources", "services", "works"})
@XmlRootElement(name="activities-summary", namespace="http://www.orcid.org/ns/activities")
@ApiModel(value="ActivitiesSummaryV3_0_rc1")
public class ActivitiesSummary
implements Serializable,
ActivitiesContainer {
    private static final long serialVersionUID = -1381163133529602122L;
    @XmlElement(name="last-modified-date", namespace="http://www.orcid.org/ns/common")
    protected LastModifiedDate lastModifiedDate;
    @XmlElement(name="distinctions", namespace="http://www.orcid.org/ns/activities")
    protected Distinctions distinctions;
    @XmlElement(name="educations", namespace="http://www.orcid.org/ns/activities")
    protected Educations educations;
    @XmlElement(name="employments", namespace="http://www.orcid.org/ns/activities")
    protected Employments employments;
    @XmlElement(name="fundings", namespace="http://www.orcid.org/ns/activities")
    protected Fundings fundings;
    @XmlElement(name="invited-positions", namespace="http://www.orcid.org/ns/activities")
    protected InvitedPositions invitedPositions;
    @XmlElement(name="memberships", namespace="http://www.orcid.org/ns/activities")
    protected Memberships memberships;
    @XmlElement(name="peer-reviews", namespace="http://www.orcid.org/ns/activities")
    protected PeerReviews peerReviews;
    @XmlElement(name="qualifications", namespace="http://www.orcid.org/ns/activities")
    protected Qualifications qualifications;
    @XmlElement(name="works", namespace="http://www.orcid.org/ns/activities")
    protected Works works;
    @XmlElement(name="services", namespace="http://www.orcid.org/ns/activities")
    protected Services services;
    @XmlElement(name="research-resources", namespace="http://www.orcid.org/ns/activities")
    protected ResearchResources researchResources;
    @XmlAttribute
    protected String path;

    public Distinctions getDistinctions() {
        return this.distinctions;
    }

    public void setDistinctions(Distinctions distinctions) {
        this.distinctions = distinctions;
    }

    public InvitedPositions getInvitedPositions() {
        return this.invitedPositions;
    }

    public void setInvitedPositions(InvitedPositions invitedPositions) {
        this.invitedPositions = invitedPositions;
    }

    public Memberships getMemberships() {
        return this.memberships;
    }

    public void setMemberships(Memberships memberships) {
        this.memberships = memberships;
    }

    public Qualifications getQualifications() {
        return this.qualifications;
    }

    public void setQualifications(Qualifications qualifications) {
        this.qualifications = qualifications;
    }

    public Services getServices() {
        return this.services;
    }

    public void setServices(Services services) {
        this.services = services;
    }

    public Educations getEducations() {
        return this.educations;
    }

    public void setEducations(Educations educations) {
        this.educations = educations;
    }

    public Employments getEmployments() {
        return this.employments;
    }

    public void setEmployments(Employments employments) {
        this.employments = employments;
    }

    public PeerReviews getPeerReviews() {
        if (this.peerReviews == null) {
            this.peerReviews = new PeerReviews();
        }
        return this.peerReviews;
    }

    public void setPeerReviews(PeerReviews peerReviews) {
        this.peerReviews = peerReviews;
    }

    public Works getWorks() {
        if (this.works == null) {
            this.works = new Works();
        }
        return this.works;
    }

    public void setWorks(Works works) {
        this.works = works;
    }

    public Fundings getFundings() {
        if (this.fundings == null) {
            this.fundings = new Fundings();
        }
        return this.fundings;
    }

    public void setFundings(Fundings fundings) {
        this.fundings = fundings;
    }

    public ResearchResources getResearchResources() {
        if (this.researchResources == null) {
            this.researchResources = new ResearchResources();
        }
        return this.researchResources;
    }

    public void setResearchResources(ResearchResources researchResources) {
        this.researchResources = researchResources;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.distinctions == null ? 0 : this.distinctions.hashCode());
        result = 31 * result + (this.educations == null ? 0 : this.educations.hashCode());
        result = 31 * result + (this.employments == null ? 0 : this.employments.hashCode());
        result = 31 * result + (this.invitedPositions == null ? 0 : this.invitedPositions.hashCode());
        result = 31 * result + (this.fundings == null ? 0 : this.fundings.hashCode());
        result = 31 * result + (this.memberships == null ? 0 : this.memberships.hashCode());
        result = 31 * result + (this.peerReviews == null ? 0 : this.peerReviews.hashCode());
        result = 31 * result + (this.qualifications == null ? 0 : this.qualifications.hashCode());
        result = 31 * result + (this.services == null ? 0 : this.services.hashCode());
        result = 31 * result + (this.works == null ? 0 : this.works.hashCode());
        result = 31 * result + (this.researchResources == null ? 0 : this.researchResources.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ActivitiesSummary other = (ActivitiesSummary)obj;
        if (this.distinctions == null ? other.distinctions != null : !this.distinctions.equals(other.distinctions)) {
            return false;
        }
        if (this.educations == null ? other.educations != null : !this.educations.equals(other.educations)) {
            return false;
        }
        if (this.employments == null ? other.employments != null : !this.employments.equals(other.employments)) {
            return false;
        }
        if (this.invitedPositions == null ? other.invitedPositions != null : !this.invitedPositions.equals(other.invitedPositions)) {
            return false;
        }
        if (this.fundings == null ? other.fundings != null : !this.fundings.equals(other.fundings)) {
            return false;
        }
        if (this.memberships == null ? other.memberships != null : !this.memberships.equals(other.memberships)) {
            return false;
        }
        if (this.peerReviews == null ? other.peerReviews != null : !this.peerReviews.equals(other.peerReviews)) {
            return false;
        }
        if (this.qualifications == null ? other.qualifications != null : !this.qualifications.equals(other.qualifications)) {
            return false;
        }
        if (this.services == null ? other.services != null : !this.services.equals(other.services)) {
            return false;
        }
        if (this.works == null ? other.works != null : !this.works.equals(other.works)) {
            return false;
        }
        return !(this.researchResources == null ? other.researchResources != null : !this.researchResources.equals(other.researchResources));
    }

    public String toString() {
        return RecordUtil.convertToString(this);
    }

    @Override
    public Map<Long, ? extends Activity> retrieveActivitiesAsMap() {
        Collection<Serializable> groups;
        HashMap<Long, SourceAware> activities = new HashMap<Long, SourceAware>();
        if (this.works != null) {
            groups = this.works.getWorkGroup();
            for (WorkGroup workGroup : groups) {
                if (workGroup == null) continue;
                List<WorkSummary> summaries = workGroup.getWorkSummary();
                Iterator<WorkSummary> iterator = summaries.iterator();
                while (iterator.hasNext()) {
                    WorkSummary workSummary = iterator.next();
                    activities.put(workSummary.getPutCode(), workSummary);
                }
            }
        }
        if (this.peerReviews != null) {
            groups = this.peerReviews.getPeerReviewGroup();
            for (PeerReviewGroup peerReviewGroup : groups) {
                if (peerReviewGroup == null) continue;
                for (PeerReviewDuplicateGroup peerReviewDuplicateGroup : peerReviewGroup.getPeerReviewGroup()) {
                    List<PeerReviewSummary> list = peerReviewDuplicateGroup.getPeerReviewSummary();
                    for (PeerReviewSummary summary : list) {
                        activities.put(summary.getPutCode(), summary);
                    }
                }
            }
        }
        if (this.fundings != null) {
            groups = this.fundings.getFundingGroup();
            for (FundingGroup fundingGroup : groups) {
                if (fundingGroup == null) continue;
                List<FundingSummary> fundings = fundingGroup.getFundingSummary();
                for (FundingSummary fundingSummary : fundings) {
                    activities.put(fundingSummary.getPutCode(), fundingSummary);
                }
            }
        }
        if (this.researchResources != null) {
            groups = this.researchResources.getResearchResourceGroup();
            for (ResearchResourceGroup researchResourceGroup : groups) {
                if (researchResourceGroup == null) continue;
                List<ResearchResourceSummary> researchResources = researchResourceGroup.getResearchResourceSummary();
                for (ResearchResourceSummary researchResourceSummary : researchResources) {
                    activities.put(researchResourceSummary.getPutCode(), researchResourceSummary);
                }
            }
        }
        if (this.educations != null) {
            groups = this.educations.getEducationGroups();
            for (AffiliationGroup affiliationGroup : groups) {
                if (affiliationGroup == null) continue;
                for (EducationSummary educationSummary : affiliationGroup.getActivities()) {
                    activities.put(educationSummary.getPutCode(), educationSummary);
                }
            }
        }
        if (this.employments != null) {
            groups = this.employments.getEmploymentGroups();
            for (AffiliationGroup affiliationGroup : groups) {
                if (affiliationGroup == null) continue;
                for (EmploymentSummary employmentSummary : affiliationGroup.getActivities()) {
                    activities.put(employmentSummary.getPutCode(), employmentSummary);
                }
            }
        }
        if (this.distinctions != null) {
            groups = this.distinctions.getDistinctionGroups();
            for (AffiliationGroup affiliationGroup : groups) {
                if (affiliationGroup == null) continue;
                for (DistinctionSummary distinctionSummary : affiliationGroup.getActivities()) {
                    activities.put(distinctionSummary.getPutCode(), distinctionSummary);
                }
            }
        }
        if (this.invitedPositions != null) {
            groups = this.invitedPositions.getInvitedPositionGroups();
            for (AffiliationGroup affiliationGroup : groups) {
                if (affiliationGroup == null) continue;
                for (InvitedPositionSummary invitedPositionSummary : affiliationGroup.getActivities()) {
                    activities.put(invitedPositionSummary.getPutCode(), invitedPositionSummary);
                }
            }
        }
        if (this.memberships != null) {
            groups = this.memberships.getMembershipGroups();
            for (AffiliationGroup affiliationGroup : groups) {
                if (affiliationGroup == null) continue;
                for (MembershipSummary membershipSummary : affiliationGroup.getActivities()) {
                    activities.put(membershipSummary.getPutCode(), membershipSummary);
                }
            }
        }
        if (this.qualifications != null) {
            groups = this.qualifications.getQualificationGroups();
            for (AffiliationGroup affiliationGroup : groups) {
                if (affiliationGroup == null) continue;
                for (QualificationSummary qualificationSummary : affiliationGroup.getActivities()) {
                    activities.put(qualificationSummary.getPutCode(), qualificationSummary);
                }
            }
        }
        if (this.services != null) {
            groups = this.services.getServiceGroups();
            for (AffiliationGroup affiliationGroup : groups) {
                if (affiliationGroup == null) continue;
                for (ServiceSummary serviceSummary : affiliationGroup.getActivities()) {
                    activities.put(serviceSummary.getPutCode(), serviceSummary);
                }
            }
        }
        return activities;
    }

    public List<? extends Activity> retrieveActivities() {
        return new ArrayList<Activity>(this.retrieveActivitiesAsMap().values());
    }

    public LastModifiedDate getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    @Override
    public void setLastModifiedDate(LastModifiedDate lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

