/*
 * Decompiled with CFR 0.152.
 */
package org.orcid.model.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.orcid.model.utils.DateUtils;

public class ReleaseNameUtils {
    private static final String RELEASE_NAME_PROPERTY = "releaseName";
    private static String releaseName;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readReleaseNameFromFile() {
        try (InputStream is = ReleaseNameUtils.class.getResourceAsStream("/release_name.txt");){
            if (is == null) return null;
            String input = IOUtils.toString((InputStream)is);
            String string = input.trim();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading release name file", e);
        }
    }

    public static String getReleaseName() {
        return releaseName;
    }

    static {
        String releaseNameFromSystemProperty = System.getProperty(RELEASE_NAME_PROPERTY);
        if (StringUtils.isBlank((CharSequence)releaseNameFromSystemProperty)) {
            releaseName = ReleaseNameUtils.readReleaseNameFromFile();
            if (StringUtils.isBlank((CharSequence)releaseName)) {
                releaseName = DateUtils.convertToXMLGregorianCalendar(new Date()).toXMLFormat();
            }
            System.setProperty(RELEASE_NAME_PROPERTY, releaseName);
        } else {
            releaseName = releaseNameFromSystemProperty;
        }
    }
}

