/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.fp.oneOf;

import java.util.Objects;
import org.organicdesign.fp.collections.ImList;
import org.organicdesign.fp.function.Fn0;
import org.organicdesign.fp.function.Fn1;
import org.organicdesign.fp.oneOf.None;
import org.organicdesign.fp.type.RuntimeTypes;

public abstract class OneOf2OrNone<A, B> {
    private final Object item;
    private final int sel;
    private final ImList<Class> types;

    protected OneOf2OrNone(Object o, Class<A> aClass, Class<B> bClass, int index) {
        this.types = RuntimeTypes.registerClasses(aClass, bClass, None.class);
        this.sel = index;
        this.item = o;
        if (index < 0) {
            throw new IllegalArgumentException("Selected item index must be 0-2");
        }
        if (index > 2) {
            throw new IllegalArgumentException("Selected item index must be 0-2");
        }
        if (index == 2 && o != null) {
            throw new IllegalArgumentException("You specified the index " + index + " meaning 'None' but passed a value: " + o);
        }
        if (o != null && !((Class)this.types.get(index)).isInstance(o)) {
            throw new ClassCastException("You specified index " + index + ", indicating a(n) " + ((Class)this.types.get(index)).getCanonicalName() + ", but passed a " + o.getClass().getCanonicalName());
        }
    }

    public <R> R match(Fn1<A, R> fa, Fn1<B, R> fb, Fn0<R> fz) {
        if (this.sel == 0) {
            return fa.apply(this.item);
        }
        if (this.sel == 1) {
            return fb.apply(this.item);
        }
        return fz.apply();
    }

    public int hashCode() {
        return Objects.hashCode(this.item) + this.sel;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OneOf2OrNone)) {
            return false;
        }
        OneOf2OrNone that = (OneOf2OrNone)other;
        return this.sel == that.sel && Objects.equals(this.item, that.item);
    }

    public String toString() {
        return RuntimeTypes.union2Str(this.sel == 2 ? None.NONE : this.item, this.types);
    }
}

