/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.fp.collections;

import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Equator<T> {
    @NotNull
    public static <T> Equator<T> defaultEquator() {
        return Equat.DEFAULT;
    }

    @NotNull
    public static <T> Comparator<T> defaultComparator() {
        return Comp.DEFAULT;
    }

    public static int doCompare(Comparable<Object> o1, Comparable<Object> o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -Integer.signum(o2.compareTo(o1));
        }
        return o1.compareTo(o2);
    }

    public int hash(T var1);

    public boolean eq(T var1, T var2);

    default public boolean neq(T o1, T o2) {
        return !this.eq(o1, o2);
    }

    public static enum Comp implements Comparator<Comparable<Object>>
    {
        DEFAULT{

            @Override
            public int compare(Comparable<Object> o1, Comparable<Object> o2) {
                return Equator.doCompare(o1, o2);
            }
        };

    }

    public static enum Equat implements Equator<Object>
    {
        DEFAULT{

            @Override
            public int hash(@Nullable Object o) {
                return o == null ? 0 : o.hashCode();
            }

            @Override
            public boolean eq(@Nullable Object o1, @Nullable Object o2) {
                if (o1 == null) {
                    return o2 == null;
                }
                return o1.equals(o2);
            }
        };

    }
}

