/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.fp.oneOf;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.organicdesign.fp.collections.ImList;
import org.organicdesign.fp.function.Fn1;
import org.organicdesign.fp.type.RuntimeTypes;

public class OneOf2<A, B> {
    @NotNull
    protected final Object item;
    private final int sel;
    @NotNull
    private final ImList<Class> types;

    protected OneOf2(@NotNull Object o, @NotNull Class<A> aClass, @NotNull Class<B> bClass, int index) {
        this.types = RuntimeTypes.registerClasses(aClass, bClass);
        this.sel = index;
        this.item = o;
        if (index < 0) {
            throw new IllegalArgumentException("Selected item index must be 0-1");
        }
        if (index > 1) {
            throw new IllegalArgumentException("Selected item index must be 0-1");
        }
        if (!((Class)this.types.get(index)).isInstance(o)) {
            throw new ClassCastException("You specified index " + index + ", indicating a(n) " + ((Class)this.types.get(index)).getCanonicalName() + ", but passed a " + o.getClass().getCanonicalName());
        }
    }

    public <R> R match(@NotNull Fn1<A, R> fa, @NotNull Fn1<B, R> fb) {
        if (this.sel == 0) {
            return fa.apply(this.item);
        }
        return fb.apply(this.item);
    }

    public int hashCode() {
        return Objects.hashCode(this.item) + this.sel;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OneOf2)) {
            return false;
        }
        OneOf2 that = (OneOf2)other;
        return this.sel == that.sel && Objects.equals(this.item, that.item);
    }

    @NotNull
    public String toString() {
        return RuntimeTypes.union2Str(this.item, this.types);
    }
}

