/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.fp.collections;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.organicdesign.fp.FunctionUtils;
import org.organicdesign.fp.collections.AbstractUnmodMap;
import org.organicdesign.fp.collections.BaseMap;
import org.organicdesign.fp.collections.Equator;
import org.organicdesign.fp.collections.ImSortedMap;
import org.organicdesign.fp.collections.ImSortedSet;
import org.organicdesign.fp.collections.PersistentTreeSet;
import org.organicdesign.fp.collections.UnmodIterator;
import org.organicdesign.fp.collections.UnmodMap;
import org.organicdesign.fp.collections.UnmodSortedIterator;
import org.organicdesign.fp.function.Fn1;
import org.organicdesign.fp.oneOf.Option;
import org.organicdesign.fp.tuple.Tuple2;

public class PersistentTreeMap<K, V>
extends AbstractUnmodMap<K, V>
implements ImSortedMap<K, V>,
Serializable {
    public static final PersistentTreeMap EMPTY = new PersistentTreeMap(Equator.defaultComparator(), null, 0);
    private final Comparator<? super K> comp;
    private final transient Node<K, V> tree;
    private final int size;
    private static final long serialVersionUID = 20160904095000L;

    public static <K extends Comparable<K>, V> PersistentTreeMap<K, V> of(Iterable<Map.Entry<K, V>> es) {
        if (es == null) {
            return PersistentTreeMap.empty();
        }
        ImSortedMap<Object, V> map = new PersistentTreeMap(Equator.defaultComparator(), null, 0);
        for (Map.Entry<K, V> entry : es) {
            if (entry == null) continue;
            map = map.assoc((Object)((Comparable)entry.getKey()), (Object)entry.getValue());
        }
        return map;
    }

    public static <K, V> PersistentTreeMap<K, V> ofComp(Comparator<? super K> comp, Iterable<Map.Entry<K, V>> kvPairs) {
        if (kvPairs == null) {
            return new PersistentTreeMap<K, V>(comp, null, 0);
        }
        ImSortedMap<K, V> map = new PersistentTreeMap<K, V>(comp, null, 0);
        for (Map.Entry<K, V> entry : kvPairs) {
            if (entry == null) continue;
            map = map.assoc((Object)entry.getKey(), (Object)entry.getValue());
        }
        return map;
    }

    public static <K extends Comparable<K>, V> PersistentTreeMap<K, V> empty() {
        return EMPTY;
    }

    public static <K, V> PersistentTreeMap<K, V> empty(Comparator<? super K> c) {
        return new PersistentTreeMap<K, V>(c, null, 0);
    }

    private PersistentTreeMap(Comparator<? super K> c, Node<K, V> t, int n) {
        if (c == null) {
            throw new IllegalArgumentException("Comparator can't be null.");
        }
        this.comp = c;
        this.tree = t;
        this.size = n;
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("Proxy required");
    }

    @Override
    public ImSortedSet<Map.Entry<K, V>> entrySet() {
        return this.fold(PersistentTreeSet.ofComp(new KeyComparator<K>(this.comp)), PersistentTreeSet::put);
    }

    @Override
    public ImSortedMap<K, V> subMap(K fromKey, K toKey) {
        UnmodMap.UnEntry next;
        Object key;
        int diff = this.comp.compare(fromKey, toKey);
        if (diff > 0) {
            throw new IllegalArgumentException("fromKey is greater than toKey");
        }
        UnmodMap.UnEntry<K, V> last = this.last();
        Object lastKey = last.getKey();
        int compFromKeyLastKey = this.comp.compare(fromKey, lastKey);
        if (diff == 0 || compFromKeyLastKey > 0) {
            return new PersistentTreeMap<K, V>(this.comp, null, 0);
        }
        if (this.comp.compare(fromKey, this.firstKey()) <= 0 && this.comp.compare(toKey, lastKey) > 0) {
            return this;
        }
        if (compFromKeyLastKey == 0) {
            return PersistentTreeMap.ofComp(this.comp, Collections.singletonList(last));
        }
        BaseMap<K, V> ret = new PersistentTreeMap<K, V>(this.comp, null, 0);
        UnmodIterator iter = this.iterator();
        while (iter.hasNext() && this.comp.compare(toKey, key = (next = (UnmodMap.UnEntry)iter.next()).getKey()) > 0) {
            if (this.comp.compare(fromKey, key) > 0) continue;
            ret = ret.assoc(key, next.getValue());
        }
        return ret;
    }

    @Override
    public Option<UnmodMap.UnEntry<K, V>> head() {
        Node<K, V> t = this.tree;
        if (t != null) {
            while (t.left() != null) {
                t = t.left();
            }
        }
        return Option.some(t);
    }

    @Override
    public ImSortedMap<K, V> tailMap(K fromKey) {
        UnmodMap.UnEntry<K, V> last = this.last();
        Object lastKey = last.getKey();
        int compFromKeyLastKey = this.comp.compare(fromKey, lastKey);
        if (compFromKeyLastKey > 0) {
            return new PersistentTreeMap<K, V>(this.comp, null, 0);
        }
        if (this.comp.compare(fromKey, this.firstKey()) <= 0) {
            return this;
        }
        if (compFromKeyLastKey == 0) {
            return PersistentTreeMap.ofComp(this.comp, Collections.singletonList(last));
        }
        BaseMap<K, V> ret = new PersistentTreeMap<K, V>(this.comp, null, 0);
        for (UnmodMap.UnEntry next : this) {
            Object key = next.getKey();
            if (this.comp.compare(fromKey, key) > 0) continue;
            ret = ret.assoc(key, next.getValue());
        }
        return ret;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comp == Equator.Comp.DEFAULT ? null : this.comp;
    }

    @Override
    public PersistentTreeMap<K, V> assoc(K key, V val) {
        Box<Object> found = new Box<Object>(null);
        Node<K, V> t = this.add(this.tree, key, val, found);
        if (t == null) {
            Node foundNode = (Node)found.val;
            if (foundNode.getValue() == val) {
                return this;
            }
            return new PersistentTreeMap<K, V>(this.comp, this.replace(this.tree, key, val), this.size);
        }
        return new PersistentTreeMap<K, V>(this.comp, t.blacken(), this.size + 1);
    }

    @Override
    public PersistentTreeMap<K, V> without(K key) {
        Box<Object> found = new Box<Object>(null);
        Node<K, V> t = this.remove(this.tree, key, found);
        if (t == null) {
            if (found.val == null) {
                return this;
            }
            return new PersistentTreeMap<K, V>(this.comp, null, 0);
        }
        return new PersistentTreeMap<K, V>(this.comp, t.blacken(), this.size - 1);
    }

    @Override
    public UnmodSortedIterator<UnmodMap.UnEntry<K, V>> iterator() {
        return this.iterator(Tuple2::of);
    }

    @Override
    public UnmodSortedIterator<K> keyIterator() {
        return this.iterator(Tuple2::getKey);
    }

    @Override
    public UnmodSortedIterator<V> valIterator() {
        return this.iterator(Tuple2::getValue);
    }

    public <R> UnmodSortedIterator<R> iterator(Fn1<Node<K, V>, R> aFn) {
        return new NodeIterator<K, V, R>(this.tree, true, aFn);
    }

    @Override
    public K firstKey() {
        if (this.size() < 1) {
            throw new NoSuchElementException("this map is empty");
        }
        return this.head().get().getKey();
    }

    @Override
    public K lastKey() {
        UnmodMap.UnEntry<K, V> max = this.last();
        if (max == null) {
            throw new NoSuchElementException("this map is empty");
        }
        return max.getKey();
    }

    public UnmodMap.UnEntry<K, V> last() {
        Node<K, V> t = this.tree;
        if (t != null) {
            while (t.right() != null) {
                t = t.right();
            }
        }
        return t;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Option<UnmodMap.UnEntry<K, V>> entry(K key) {
        Node<K, V> t = this.tree;
        while (t != null) {
            int c = this.comp.compare(key, t.getKey());
            if (c == 0) {
                return Option.some(t);
            }
            if (c < 0) {
                t = t.left();
                continue;
            }
            t = t.right();
        }
        return Option.none();
    }

    private Node<K, V> add(Node<K, V> t, K key, V val, Box<Node<K, V>> found) {
        if (t == null) {
            return new Red<K, V>(key, val);
        }
        int c = this.comp.compare(key, t.getKey());
        if (c == 0) {
            found.val = t;
            return null;
        }
        Node<K, V> ins = this.add(c < 0 ? t.left() : t.right(), key, val, found);
        if (ins == null) {
            return null;
        }
        if (c < 0) {
            return t.addLeft(ins);
        }
        return t.addRight(ins);
    }

    private Node<K, V> remove(Node<K, V> t, K key, Box<Node<K, V>> found) {
        if (t == null) {
            return null;
        }
        int c = this.comp.compare(key, t.getKey());
        if (c == 0) {
            found.val = t;
            return PersistentTreeMap.append(t.left(), t.right());
        }
        Node<K, V> del = this.remove(c < 0 ? t.left() : t.right(), key, found);
        if (del == null && found.val == null) {
            return null;
        }
        if (c < 0) {
            if (t.left() instanceof Black) {
                return PersistentTreeMap.balanceLeftDel(t.getKey(), t.getValue(), del, t.right());
            }
            return PersistentTreeMap.red(t.getKey(), t.getValue(), del, t.right());
        }
        if (t.right() instanceof Black) {
            return PersistentTreeMap.balanceRightDel(t.getKey(), t.getValue(), t.left(), del);
        }
        return PersistentTreeMap.red(t.getKey(), t.getValue(), t.left(), del);
    }

    private static <K, V> Node<K, V> append(Node<? extends K, ? extends V> left, Node<? extends K, ? extends V> right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        if (left instanceof Red) {
            if (right instanceof Red) {
                Node<K, V> app = PersistentTreeMap.append(left.right(), right.left());
                if (app instanceof Red) {
                    return PersistentTreeMap.red(app.getKey(), app.getValue(), PersistentTreeMap.red(left.getKey(), left.getValue(), left.left(), app.left()), PersistentTreeMap.red(right.getKey(), right.getValue(), app.right(), right.right()));
                }
                return PersistentTreeMap.red(left.getKey(), left.getValue(), left.left(), PersistentTreeMap.red(right.getKey(), right.getValue(), app, right.right()));
            }
            return PersistentTreeMap.red(left.getKey(), left.getValue(), left.left(), PersistentTreeMap.append(left.right(), right));
        }
        if (right instanceof Red) {
            return PersistentTreeMap.red(right.getKey(), right.getValue(), PersistentTreeMap.append(left, right.left()), right.right());
        }
        Node<K, V> app = PersistentTreeMap.append(left.right(), right.left());
        if (app instanceof Red) {
            return PersistentTreeMap.red(app.getKey(), app.getValue(), PersistentTreeMap.black(left.getKey(), left.getValue(), left.left(), app.left()), PersistentTreeMap.black(right.getKey(), right.getValue(), app.right(), right.right()));
        }
        return PersistentTreeMap.balanceLeftDel(left.getKey(), left.getValue(), left.left(), PersistentTreeMap.black(right.getKey(), right.getValue(), app, right.right()));
    }

    private static <K, V, K1 extends K, V1 extends V> Node<K, V> balanceLeftDel(K1 key, V1 val, Node<? extends K, ? extends V> del, Node<? extends K, ? extends V> right) {
        if (del instanceof Red) {
            return PersistentTreeMap.red(key, val, del.blacken(), right);
        }
        if (right instanceof Black) {
            return PersistentTreeMap.rightBalance(key, val, del, right.redden());
        }
        if (right instanceof Red && right.left() instanceof Black) {
            return PersistentTreeMap.red(right.left().getKey(), right.left().getValue(), PersistentTreeMap.black(key, val, del, right.left().left()), PersistentTreeMap.rightBalance(right.getKey(), right.getValue(), right.left().right(), right.right().redden()));
        }
        throw new UnsupportedOperationException("Invariant violation");
    }

    private static <K, V, K1 extends K, V1 extends V> Node<K, V> balanceRightDel(K1 key, V1 val, Node<? extends K, ? extends V> left, Node<? extends K, ? extends V> del) {
        if (del instanceof Red) {
            return PersistentTreeMap.red(key, val, left, del.blacken());
        }
        if (left instanceof Black) {
            return PersistentTreeMap.leftBalance(key, val, left.redden(), del);
        }
        if (left instanceof Red && left.right() instanceof Black) {
            return PersistentTreeMap.red(left.right().getKey(), left.right().getValue(), PersistentTreeMap.leftBalance(left.getKey(), left.getValue(), left.left().redden(), left.right().left()), PersistentTreeMap.black(key, val, left.right().right(), del));
        }
        throw new UnsupportedOperationException("Invariant violation");
    }

    private static <K, V, K1 extends K, V1 extends V> Node<K, V> leftBalance(K1 key, V1 val, Node<? extends K, ? extends V> ins, Node<? extends K, ? extends V> right) {
        if (ins instanceof Red && ins.left() instanceof Red) {
            return PersistentTreeMap.red(ins.getKey(), ins.getValue(), ins.left().blacken(), PersistentTreeMap.black(key, val, ins.right(), right));
        }
        if (ins instanceof Red && ins.right() instanceof Red) {
            return PersistentTreeMap.red(ins.right().getKey(), ins.right().getValue(), PersistentTreeMap.black(ins.getKey(), ins.getValue(), ins.left(), ins.right().left()), PersistentTreeMap.black(key, val, ins.right().right(), right));
        }
        return PersistentTreeMap.black(key, val, ins, right);
    }

    private static <K, V, K1 extends K, V1 extends V> Node<K, V> rightBalance(K1 key, V1 val, Node<? extends K, ? extends V> left, Node<? extends K, ? extends V> ins) {
        if (ins instanceof Red && ins.right() instanceof Red) {
            return PersistentTreeMap.red(ins.getKey(), ins.getValue(), PersistentTreeMap.black(key, val, left, ins.left()), ins.right().blacken());
        }
        if (ins instanceof Red && ins.left() instanceof Red) {
            return PersistentTreeMap.red(ins.left().getKey(), ins.left().getValue(), PersistentTreeMap.black(key, val, left, ins.left().left()), PersistentTreeMap.black(ins.getKey(), ins.getValue(), ins.left().right(), ins.right()));
        }
        return PersistentTreeMap.black(key, val, left, ins);
    }

    private Node<K, V> replace(Node<K, V> t, K key, V val) {
        int c = this.comp.compare(key, t.getKey());
        return t.replace(t.getKey(), c == 0 ? val : t.getValue(), c < 0 ? this.replace(t.left(), key, val) : t.left(), c > 0 ? this.replace(t.right(), key, val) : t.right());
    }

    private static <K, V, K1 extends K, V1 extends V> Red<K, V> red(K1 key, V1 val, Node<? extends K, ? extends V> left, Node<? extends K, ? extends V> right) {
        if (left == null && right == null) {
            return new Red<K1, V1>(key, val);
        }
        return new RedBranch<K, V>(key, val, left, right);
    }

    private static <K, V, K1 extends K, V1 extends V> Black<K, V> black(K1 key, V1 val, Node<? extends K, ? extends V> left, Node<? extends K, ? extends V> right) {
        if (left == null && right == null) {
            return new Black<K1, V1>(key, val);
        }
        return new BlackBranch<K, V>(key, val, left, right);
    }

    private static class NodeIterator<K, V, R>
    implements UnmodSortedIterator<R> {
        private Stack<Node<K, V>> stack = new Stack();
        private final boolean asc;
        private Fn1<Node<K, V>, R> aFn;

        NodeIterator(Node<K, V> t, boolean asc, Fn1<Node<K, V>, R> aFn) {
            this.asc = asc;
            this.aFn = aFn;
            this.push(t);
        }

        private void push(Node<K, V> t) {
            while (t != null) {
                this.stack.push(t);
                t = this.asc ? t.left() : t.right();
            }
        }

        @Override
        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        @Override
        public R next() {
            Node<K, V> t = this.stack.pop();
            this.push(this.asc ? t.right() : t.left());
            return this.aFn.apply(t);
        }
    }

    private static class RedBranch<K, V>
    extends Red<K, V> {
        final transient Node<K, V> left;
        final transient Node<K, V> right;

        RedBranch(K key, V val, Node<K, V> left, Node<K, V> right) {
            super(key, val);
            this.left = left;
            this.right = right;
        }

        @Override
        public Node<K, V> left() {
            return this.left;
        }

        @Override
        public Node<K, V> right() {
            return this.right;
        }

        @Override
        Node<K, V> balanceLeft(Node<K, V> parent) {
            if (this.left instanceof Red) {
                return PersistentTreeMap.red(this._1, this._2, this.left.blacken(), PersistentTreeMap.black(parent.getKey(), parent.getValue(), this.right, parent.right()));
            }
            if (this.right instanceof Red) {
                return PersistentTreeMap.red(this.right.getKey(), this.right.getValue(), PersistentTreeMap.black(this._1, this._2, this.left, this.right.left()), PersistentTreeMap.black(parent.getKey(), parent.getValue(), this.right.right(), parent.right()));
            }
            return super.balanceLeft(parent);
        }

        @Override
        Node<K, V> balanceRight(Node<K, V> parent) {
            if (this.right instanceof Red) {
                return PersistentTreeMap.red(this._1, this._2, PersistentTreeMap.black(parent.getKey(), parent.getValue(), parent.left(), this.left), this.right.blacken());
            }
            if (this.left instanceof Red) {
                return PersistentTreeMap.red(this.left.getKey(), this.left.getValue(), PersistentTreeMap.black(parent.getKey(), parent.getValue(), parent.left(), this.left.left()), PersistentTreeMap.black(this._1, this._2, this.left.right(), this.right));
            }
            return super.balanceRight(parent);
        }

        @Override
        Node<K, V> blacken() {
            return new BlackBranch<Object, Object>(this._1, this._2, this.left, this.right);
        }
    }

    private static class Red<K, V>
    extends Node<K, V> {
        Red(K key, V val) {
            super(key, val);
        }

        @Override
        Node<K, V> addLeft(Node<K, V> ins) {
            return PersistentTreeMap.red(this._1, this._2, ins, this.right());
        }

        @Override
        Node<K, V> addRight(Node<K, V> ins) {
            return PersistentTreeMap.red(this._1, this._2, this.left(), ins);
        }

        @Override
        Node<K, V> removeLeft(Node<K, V> del) {
            return PersistentTreeMap.red(this._1, this._2, del, this.right());
        }

        @Override
        Node<K, V> removeRight(Node<K, V> del) {
            return PersistentTreeMap.red(this._1, this._2, this.left(), del);
        }

        @Override
        Node<K, V> blacken() {
            return new Black<Object, Object>(this._1, this._2);
        }

        @Override
        Node<K, V> redden() {
            throw new UnsupportedOperationException("Invariant violation");
        }

        @Override
        Node<K, V> replace(K key, V val, Node<K, V> left, Node<K, V> right) {
            return PersistentTreeMap.red(key, val, left, right);
        }
    }

    private static class BlackBranch<K, V>
    extends Black<K, V> {
        final transient Node<K, V> left;
        final transient Node<K, V> right;

        BlackBranch(K key, V val, Node<K, V> l, Node<K, V> r) {
            super(key, val);
            this.left = l;
            this.right = r;
        }

        @Override
        public Node<K, V> left() {
            return this.left;
        }

        @Override
        public Node<K, V> right() {
            return this.right;
        }

        @Override
        Node<K, V> redden() {
            return new RedBranch<Object, Object>(this._1, this._2, this.left, this.right);
        }
    }

    private static class Black<K, V>
    extends Node<K, V> {
        Black(K key, V val) {
            super(key, val);
        }

        @Override
        Node<K, V> addLeft(Node<K, V> ins) {
            return ins.balanceLeft(this);
        }

        @Override
        Node<K, V> addRight(Node<K, V> ins) {
            return ins.balanceRight(this);
        }

        @Override
        Node<K, V> removeLeft(Node<K, V> del) {
            return PersistentTreeMap.balanceLeftDel(this._1, this._2, del, this.right());
        }

        @Override
        Node<K, V> removeRight(Node<K, V> del) {
            return PersistentTreeMap.balanceRightDel(this._1, this._2, this.left(), del);
        }

        @Override
        Node<K, V> blacken() {
            return this;
        }

        @Override
        Node<K, V> redden() {
            return new Red<Object, Object>(this._1, this._2);
        }

        @Override
        Node<K, V> replace(K key, V val, Node<K, V> left, Node<K, V> right) {
            return PersistentTreeMap.black(key, val, left, right);
        }
    }

    private static abstract class Node<K, V>
    extends Tuple2<K, V> {
        Node(K key, V val) {
            super(key, val);
        }

        Node<K, V> left() {
            return null;
        }

        Node<K, V> right() {
            return null;
        }

        abstract Node<K, V> addLeft(Node<K, V> var1);

        abstract Node<K, V> addRight(Node<K, V> var1);

        abstract Node<K, V> removeLeft(Node<K, V> var1);

        abstract Node<K, V> removeRight(Node<K, V> var1);

        abstract Node<K, V> blacken();

        abstract Node<K, V> redden();

        Node<K, V> balanceLeft(Node<K, V> parent) {
            return PersistentTreeMap.black(parent._1, parent._2, this, parent.right());
        }

        Node<K, V> balanceRight(Node<K, V> parent) {
            return PersistentTreeMap.black(parent._1, parent._2, parent.left(), this);
        }

        abstract Node<K, V> replace(K var1, V var2, Node<K, V> var3, Node<K, V> var4);

        @Override
        public String toString() {
            return FunctionUtils.stringify(this._1) + "=" + FunctionUtils.stringify(this._2);
        }
    }

    private static class SerializationProxy<K, V>
    implements Serializable {
        private static final long serialVersionUID = 20160904095000L;
        private final Comparator<? super K> comparator;
        private final int size;
        private transient PersistentTreeMap<K, V> theMap;

        SerializationProxy(PersistentTreeMap<K, V> phm) {
            this.comparator = phm.comp;
            if (!(this.comparator instanceof Serializable)) {
                throw new IllegalStateException("Comparator must equal serializable.  Instead it was " + this.comparator);
            }
            this.size = phm.size;
            this.theMap = phm;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            if (this.theMap.tree != null) {
                ArrayDeque queue = new ArrayDeque();
                queue.add(this.theMap.tree);
                while (queue.peek() != null) {
                    Node node = (Node)queue.remove();
                    s.writeObject(node.getKey());
                    s.writeObject(node.getValue());
                    Node child = node.left();
                    if (child != null) {
                        queue.add(child);
                    }
                    if ((child = node.right()) == null) continue;
                    queue.add(child);
                }
            }
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            this.theMap = new PersistentTreeMap(this.comparator, null, 0);
            for (int i = 0; i < this.size; ++i) {
                this.theMap = this.theMap.assoc(s.readObject(), s.readObject());
            }
        }

        private Object readResolve() {
            return this.theMap;
        }
    }

    static final class KeyComparator<T>
    implements Comparator<Map.Entry<T, ?>>,
    Serializable {
        private static final long serialVersionUID = 20160827174100L;
        private final Comparator<? super T> wrappedComparator;

        private KeyComparator(Comparator<? super T> c) {
            this.wrappedComparator = c;
        }

        @Override
        public int compare(Map.Entry<T, ?> a, Map.Entry<T, ?> b) {
            return this.wrappedComparator.compare(a.getKey(), b.getKey());
        }

        public String toString() {
            return "KeyComparator(" + this.wrappedComparator + ")";
        }

        Comparator<? super T> unwrap() {
            return this.wrappedComparator;
        }
    }

    static class Box<E> {
        E val;

        Box(E val) {
            this.val = val;
        }
    }
}

