/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.fp.collections;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.SortedMap;
import java.util.SortedSet;
import org.organicdesign.fp.collections.UnmodIterable;
import org.organicdesign.fp.collections.UnmodIterator;
import org.organicdesign.fp.collections.UnmodMap;
import org.organicdesign.fp.collections.UnmodSortedIterator;
import org.organicdesign.fp.collections.UnmodSortedMap;

public interface UnmodSortedIterable<T>
extends UnmodIterable<T> {
    public static boolean equal(UnmodSortedIterable a, UnmodSortedIterable b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        UnmodIterator as = a.iterator();
        UnmodIterator bs = b.iterator();
        while (as.hasNext() && bs.hasNext()) {
            if (Objects.equals(as.next(), bs.next())) continue;
            return false;
        }
        return !as.hasNext() && !bs.hasNext();
    }

    public static <E> UnmodSortedIterable<E> castFromSortedSet(SortedSet<E> s) {
        class Implementation<S>
        implements UnmodSortedIterable<S>,
        Serializable {
            private static final long serialVersionUID = 20160903174100L;
            private final SortedSet<S> ss;

            private Implementation(SortedSet<S> s) {
                this.ss = s;
            }

            @Override
            public UnmodSortedIterator<S> iterator() {
                return new UnmodSortedIterator.Wrapper(this.ss.iterator());
            }
        }
        return new Implementation<E>(s);
    }

    public static <E> UnmodSortedIterable<E> castFromList(List<E> s) {
        class Implementation<S>
        implements UnmodSortedIterable<S>,
        Serializable {
            private static final long serialVersionUID = 20160903174100L;
            private final List<S> ss;

            private Implementation(List<S> s) {
                this.ss = s;
            }

            @Override
            public UnmodSortedIterator<S> iterator() {
                return new UnmodSortedIterator.Wrapper<S>(this.ss.iterator());
            }
        }
        return new Implementation<E>(s);
    }

    public static <K, V> UnmodSortedIterable<UnmodMap.UnEntry<K, V>> castFromSortedMap(SortedMap<K, V> sm) {
        if (sm instanceof UnmodSortedMap) {
            return (UnmodSortedMap)sm;
        }
        class Implementation<K1, V1>
        implements UnmodSortedIterable<UnmodMap.UnEntry<K1, V1>>,
        Serializable {
            private static final long serialVersionUID = 20160903174100L;
            private final SortedMap<K1, V1> m;

            private Implementation(SortedMap<K1, V1> s) {
                this.m = s;
            }

            @Override
            public UnmodSortedIterator<UnmodMap.UnEntry<K1, V1>> iterator() {
                return new UnmodMap.UnEntry.EntryToUnEntrySortedIter(this.m.entrySet().iterator());
            }
        }
        return new Implementation<K, V>(sm);
    }

    @Override
    public UnmodSortedIterator<T> iterator();
}

