/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.fp.oneOf;

import java.io.Serializable;
import java.util.Objects;
import org.organicdesign.fp.FunctionUtils;
import org.organicdesign.fp.function.Fn0;
import org.organicdesign.fp.function.Fn1;
import org.organicdesign.fp.oneOf.None;

public interface Option<T>
extends Serializable {
    public T get();

    public T getOrElse(T var1);

    public <U> Option<U> then(Fn1<T, Option<U>> var1);

    public boolean isSome();

    public <U> U match(Fn1<T, U> var1, Fn0<U> var2);

    public static <T> Option<T> none() {
        return None.NONE;
    }

    @Deprecated
    public static <T> Option<T> of(T t) {
        if (None.NONE.equals(t)) {
            return Option.none();
        }
        return new Some<T>(t);
    }

    public static <T> Option<T> some(T t) {
        return new Some<T>(t);
    }

    public static <T> Option<T> someOrNullNoneOf(T t) {
        if (t == null || None.NONE.equals(t)) {
            return Option.none();
        }
        return new Some<T>(t);
    }

    public static class Some<T>
    implements Option<T> {
        private static final long serialVersionUID = 20160915081300L;
        private final T item;

        private Some(T t) {
            this.item = t;
        }

        @Override
        public T get() {
            return this.item;
        }

        @Override
        public T getOrElse(T t) {
            return this.item;
        }

        @Override
        public boolean isSome() {
            return true;
        }

        public String toString() {
            return "Some(" + FunctionUtils.stringify(this.item) + ")";
        }

        @Override
        public <U> U match(Fn1<T, U> has, Fn0<U> hasNot) {
            return has.apply(this.item);
        }

        @Override
        public <U> Option<U> then(Fn1<T, Option<U>> f) {
            return f.apply(this.item);
        }

        @Deprecated
        public int hashCode() {
            return this.item == null ? Integer.MIN_VALUE : this.item.hashCode();
        }

        @Deprecated
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Option)) {
                return false;
            }
            Option that = (Option)other;
            return that.isSome() && Objects.equals(this.item, that.get());
        }
    }
}

