/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.common.annotation;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.test.common.annotation.Property;

public class PropertiesConverter {
    public static Dictionary<String, Object> of(Property[] entrys) {
        Hashtable<String, Object> dictionary = new Hashtable<String, Object>();
        for (Property entry : entrys) {
            ((Dictionary)dictionary).put(entry.key(), PropertiesConverter.toValue(entry));
        }
        return dictionary;
    }

    private static Object toValue(Property entry) {
        boolean primitive = entry.type().equals((Object)Property.Type.PrimitiveArray);
        Object result = PropertiesConverter.createArray(entry.scalar(), primitive, entry.value().length);
        int i = 0;
        for (String v : entry.value()) {
            Object val = null;
            if (v != null) {
                switch (entry.scalar()) {
                    case Boolean: {
                        Boolean booleanValue = Boolean.valueOf(v);
                        val = primitive ? booleanValue.booleanValue() : booleanValue.booleanValue();
                        break;
                    }
                    case Byte: {
                        Byte byteVal = Byte.valueOf(v);
                        val = primitive ? byteVal.byteValue() : byteVal.byteValue();
                        break;
                    }
                    case Character: {
                        char charVal = v.charAt(0);
                        val = Character.valueOf(primitive ? charVal : new Character(charVal).charValue());
                        break;
                    }
                    case Double: {
                        Double doubleVal = Double.valueOf(v);
                        val = primitive ? doubleVal.doubleValue() : doubleVal.doubleValue();
                        break;
                    }
                    case Float: {
                        Float floatVal = Float.valueOf(v);
                        val = Float.valueOf(primitive ? floatVal.floatValue() : floatVal.floatValue());
                        break;
                    }
                    case Integer: {
                        Integer integerVal = Integer.valueOf(v);
                        val = primitive ? integerVal.intValue() : integerVal.intValue();
                        break;
                    }
                    case Long: {
                        Long longVal = Long.valueOf(v);
                        val = primitive ? longVal.longValue() : longVal.longValue();
                        break;
                    }
                    case Short: {
                        Short shortVal = Short.valueOf(v);
                        val = primitive ? shortVal.shortValue() : shortVal.shortValue();
                        break;
                    }
                    case String: {
                        val = v;
                    }
                }
            }
            if (Property.Type.Scalar.equals((Object)entry.type())) {
                result = val;
                break;
            }
            Array.set(result, i++, val);
        }
        switch (entry.type()) {
            case Array: {
                return result;
            }
            case PrimitiveArray: {
                return result;
            }
            case Scalar: {
                return result;
            }
            case Collection: {
                return Arrays.asList((Object[])result);
            }
        }
        throw new RuntimeException("conversion error - unknown type");
    }

    private static Object createArray(Property.Scalar scalar, boolean primitive, int length) {
        switch (scalar) {
            case Boolean: {
                if (primitive) {
                    return new boolean[length];
                }
                return new Boolean[length];
            }
            case Byte: {
                if (primitive) {
                    return new byte[length];
                }
                return new Byte[length];
            }
            case Character: {
                if (primitive) {
                    return new char[length];
                }
                return new Character[length];
            }
            case Double: {
                if (primitive) {
                    return new double[length];
                }
                return new Double[length];
            }
            case Float: {
                if (primitive) {
                    return new int[length];
                }
                return new Float[length];
            }
            case Integer: {
                if (primitive) {
                    return new int[length];
                }
                return new Integer[length];
            }
            case Long: {
                if (primitive) {
                    return new long[length];
                }
                return new Long[length];
            }
            case Short: {
                if (primitive) {
                    return new short[length];
                }
                return new Short[length];
            }
            case String: {
                if (primitive) {
                    throw new IllegalArgumentException("@Property Could not be Scalar=String and type=primitiveArray at the same time");
                }
                return new String[length];
            }
        }
        throw new RuntimeException("conversion error - unknown type");
    }
}

