/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.common.context;

import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Dictionary;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.test.common.exceptions.ConsumerWithException;
import org.osgi.test.common.exceptions.Exceptions;

public class CloseableBundleContext
implements AutoCloseable,
InvocationHandler {
    private static final Consumer<ServiceRegistration<?>> unregisterService = ConsumerWithException.asConsumerIgnoreException(ServiceRegistration::unregister);
    private static final Consumer<AutoCloseable> autoclose = ConsumerWithException.asConsumer(AutoCloseable::close);
    private static final Predicate<Bundle> installed = bundle -> (bundle.getState() & 1) != 1;
    private static final Consumer<Bundle> uninstallBundle = ConsumerWithException.asConsumer(Bundle::uninstall);
    private final BundleContext bundleContext;
    private final Class<?> host;
    private final Set<ServiceRegistration<?>> regs = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    private final Set<FrameworkListener> fwListeners = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    private final Set<ServiceListener> sListeners = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    private final Set<BundleListener> bListeners = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    private final Set<Bundle> bundles = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    private final Set<ServiceReference<?>> services = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    private final Set<ServiceObjects<?>> serviceobjects = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));

    public static BundleContext proxy(Class<?> host) {
        return (BundleContext)Proxy.newProxyInstance(host.getClassLoader(), new Class[]{BundleContext.class, AutoCloseable.class}, (InvocationHandler)new CloseableBundleContext(host, FrameworkUtil.getBundle(host).getBundleContext()));
    }

    public static BundleContext proxy(Class<?> host, BundleContext bundleContext) {
        return (BundleContext)Proxy.newProxyInstance(host.getClassLoader(), new Class[]{BundleContext.class, AutoCloseable.class}, (InvocationHandler)new CloseableBundleContext(host, bundleContext));
    }

    public CloseableBundleContext(Class<?> host, BundleContext bundleContext) {
        this.host = host;
        this.bundleContext = bundleContext;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass().equals(AutoCloseable.class)) {
            this.close();
            return null;
        }
        if (method.getDeclaringClass().equals(BundleContext.class)) {
            try {
                Method ourMethod = this.getClass().getMethod(method.getName(), method.getParameterTypes());
                return ourMethod.invoke((Object)this, args);
            }
            catch (NoSuchMethodException t) {
                return method.invoke((Object)this.bundleContext, args);
            }
        }
        if (method.getDeclaringClass().equals(Object.class)) {
            switch (method.getName()) {
                case "toString": {
                    return this.delegatedToString(proxy);
                }
                case "hashCode": {
                    return this.bundleContext.hashCode();
                }
                case "equals": {
                    return this.bundleContext.equals(args[0]);
                }
            }
        }
        throw new IllegalArgumentException();
    }

    public static void close(BundleContext bundleContext) {
        CloseableBundleContext cbc = (CloseableBundleContext)Proxy.getInvocationHandler(bundleContext);
        cbc.close();
    }

    @Override
    public void close() {
        this.bundles.stream().filter(installed).forEach(uninstallBundle);
        this.services.forEach(this::ungetService);
        this.serviceobjects.stream().map(AutoCloseable.class::cast).forEach(autoclose);
        this.regs.forEach(unregisterService);
        this.bListeners.forEach(arg_0 -> ((BundleContext)this.bundleContext).removeBundleListener(arg_0));
        this.sListeners.forEach(arg_0 -> ((BundleContext)this.bundleContext).removeServiceListener(arg_0));
        this.fwListeners.forEach(arg_0 -> ((BundleContext)this.bundleContext).removeFrameworkListener(arg_0));
    }

    public String delegatedToString(Object proxy) {
        return "CloseableBundleContext[" + System.identityHashCode(proxy) + "]:" + this.bundleContext.toString();
    }

    public Bundle installBundle(String location, InputStream input) throws BundleException {
        Bundle bundle = this.bundleContext.installBundle(location, input);
        this.bundles.add(bundle);
        return bundle;
    }

    public Bundle installBundle(String location) throws BundleException {
        Bundle bundle = this.bundleContext.installBundle(location);
        this.bundles.add(bundle);
        return bundle;
    }

    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.bundleContext.addServiceListener(listener, filter);
        this.sListeners.add(listener);
    }

    public void addServiceListener(ServiceListener listener) {
        this.bundleContext.addServiceListener(listener);
        this.sListeners.add(listener);
    }

    public void removeServiceListener(ServiceListener listener) {
        this.bundleContext.removeServiceListener(listener);
        this.sListeners.remove(listener);
    }

    public void addBundleListener(BundleListener listener) {
        this.bundleContext.addBundleListener(listener);
        this.bListeners.add(listener);
    }

    public void removeBundleListener(BundleListener listener) {
        this.bundleContext.removeBundleListener(listener);
        this.bListeners.remove(listener);
    }

    public void addFrameworkListener(FrameworkListener listener) {
        this.bundleContext.addFrameworkListener(listener);
        this.fwListeners.add(listener);
    }

    public void removeFrameworkListener(FrameworkListener listener) {
        this.bundleContext.removeFrameworkListener(listener);
        this.fwListeners.remove(listener);
    }

    public <S> S getService(ServiceReference<S> reference) {
        Object service = this.bundleContext.getService(reference);
        this.services.add(reference);
        return (S)service;
    }

    public <S> ServiceObjects<S> getServiceObjects(ServiceReference<S> reference) {
        ServiceObjects so = this.bundleContext.getServiceObjects(reference);
        ServiceObjects serviceObjects = ClosableServiceObjects.proxy(this.host, so);
        this.serviceobjects.add(serviceObjects);
        return serviceObjects;
    }

    public ServiceRegistration<?> registerService(String[] clazzes, Object service, Dictionary<String, ?> properties) {
        ServiceRegistration reg = this.bundleContext.registerService(clazzes, service, properties);
        this.regs.add(reg);
        return reg;
    }

    public ServiceRegistration<?> registerService(String clazz, Object service, Dictionary<String, ?> properties) {
        ServiceRegistration reg = this.bundleContext.registerService(clazz, service, properties);
        this.regs.add(reg);
        return reg;
    }

    public <S> ServiceRegistration<S> registerService(Class<S> clazz, S service, Dictionary<String, ?> properties) {
        ServiceRegistration reg = this.bundleContext.registerService(clazz, service, properties);
        this.regs.add(reg);
        return reg;
    }

    public <S> ServiceRegistration<S> registerService(Class<S> clazz, ServiceFactory<S> factory, Dictionary<String, ?> properties) {
        ServiceRegistration reg = this.bundleContext.registerService(clazz, factory, properties);
        this.regs.add(reg);
        return reg;
    }

    private void ungetService(ServiceReference<?> reference) {
        while (this.bundleContext.ungetService(reference)) {
        }
    }

    private static class ClosableServiceObjects<S>
    implements AutoCloseable,
    InvocationHandler {
        private final ServiceObjects<S> so;
        private final Map<S, Integer> instances = Collections.synchronizedMap(new IdentityHashMap());

        public static <S> ServiceObjects<S> proxy(Class<?> host, ServiceObjects<S> so) {
            return (ServiceObjects)Proxy.newProxyInstance(host.getClassLoader(), new Class[]{ServiceObjects.class, AutoCloseable.class}, new ClosableServiceObjects<S>(so));
        }

        public ClosableServiceObjects(ServiceObjects<S> so) {
            this.so = so;
        }

        @Override
        public void close() {
            this.instances.forEach((service, useCount) -> {
                for (int i = useCount.intValue(); i > 0; --i) {
                    this.so.ungetService(service);
                }
            });
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass().equals(AutoCloseable.class)) {
                this.close();
                return null;
            }
            if (method.getDeclaringClass().equals(ServiceObjects.class)) {
                try {
                    try {
                        Method ourMethod = this.getClass().getMethod(method.getName(), method.getParameterTypes());
                        return ourMethod.invoke((Object)this, args);
                    }
                    catch (NoSuchMethodException t) {
                        return method.invoke(this.so, args);
                    }
                }
                catch (InvocationTargetException e) {
                    throw Exceptions.duck(e.getCause());
                }
            }
            if (method.getDeclaringClass().equals(Object.class)) {
                switch (method.getName()) {
                    case "toString": {
                        return this.delegatedToString(proxy);
                    }
                    case "hashCode": {
                        return this.so.hashCode();
                    }
                    case "equals": {
                        return this.so.equals(args[0]);
                    }
                }
            }
            throw new IllegalArgumentException();
        }

        public String delegatedToString(Object proxy) {
            return "CloseableServiceObjects[" + System.identityHashCode(proxy) + "]:" + this.so.toString();
        }

        public S getService() {
            Object service = this.so.getService();
            this.instances.merge(service, 1, (oldValue, dummy) -> oldValue + 1);
            return (S)service;
        }

        public void ungetService(S service) {
            this.instances.compute(service, (key, oldValue) -> {
                if (oldValue == null) {
                    throw new AssertionError((Object)("Attempt to ungetService " + service + " but there are no outstanding references to this object"));
                }
                return oldValue == 1 ? null : Integer.valueOf(oldValue - 1);
            });
            this.so.ungetService(service);
        }
    }
}

