/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.common.dictionary;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.osgi.test.common.stream.MapStream;

public class Dictionaries {
    private Dictionaries() {
    }

    public static <K, V> Map<K, V> asMap(Dictionary<? extends K, ? extends V> dictionary) {
        if (dictionary instanceof Map) {
            Map coerced = (Map)((Object)dictionary);
            return coerced;
        }
        return new DictionaryAsMap<K, V>(dictionary);
    }

    public static <K, V> Dictionary<K, V> asDictionary(Map<? extends K, ? extends V> map) {
        if (map instanceof Dictionary) {
            Dictionary coerced = (Dictionary)((Object)map);
            return coerced;
        }
        return new MapAsDictionary<K, V>(map);
    }

    public static <K, V> Dictionary<K, V> dictionaryOf() {
        return new MapAsDictionary(Collections.emptyMap());
    }

    public static <K, V> Dictionary<K, V> dictionaryOf(K k1, V v1) {
        return MapStream.of(k1, v1).collect(Dictionaries.toDictionary());
    }

    public static <K, V> Dictionary<K, V> dictionaryOf(K k1, V v1, K k2, V v2) {
        return MapStream.of(k1, v1, k2, v2).collect(Dictionaries.toDictionary());
    }

    public static <K, V> Dictionary<K, V> dictionaryOf(K k1, V v1, K k2, V v2, K k3, V v3) {
        return MapStream.of(k1, v1, k2, v2, k3, v3).collect(Dictionaries.toDictionary());
    }

    public static <K, V> Dictionary<K, V> dictionaryOf(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return MapStream.of(k1, v1, k2, v2, k3, v3, k4, v4).collect(Dictionaries.toDictionary());
    }

    private static <K, V> Collector<? super Map.Entry<? extends K, ? extends V>, ?, Dictionary<K, V>> toDictionary() {
        return Collectors.collectingAndThen(MapStream.toMap((u, v) -> {
            throw new IllegalArgumentException("duplicate keys");
        }, LinkedHashMap::new), map -> new MapAsDictionary(Collections.unmodifiableMap(map)));
    }

    private static class MapAsDictionary<K, V>
    extends Dictionary<K, V>
    implements Map<K, V> {
        private final Map<K, V> map;

        MapAsDictionary(Map<? extends K, ? extends V> map) {
            boolean nullValue;
            boolean nullKey;
            this.map = Objects.requireNonNull(map);
            try {
                nullKey = map.containsKey(null);
            }
            catch (NullPointerException e) {
                nullKey = false;
            }
            if (nullKey) {
                throw new NullPointerException("a Dictionary cannot contain a null key");
            }
            try {
                nullValue = map.containsValue(null);
            }
            catch (NullPointerException e) {
                nullValue = false;
            }
            if (nullValue) {
                throw new NullPointerException("a Dictionary cannot contain a null value");
            }
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            MapStream.of(m).forEachOrdered(this::put);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Set<K> keySet() {
            return this.map.keySet();
        }

        @Override
        public Collection<V> values() {
            return this.map.values();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.map.entrySet();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Enumeration<K> keys() {
            return Collections.enumeration(this.map.keySet());
        }

        @Override
        public Enumeration<V> elements() {
            return Collections.enumeration(this.map.values());
        }

        @Override
        public V get(Object key) {
            if (key == null) {
                return null;
            }
            return this.map.get(key);
        }

        @Override
        public V put(K key, V value) {
            return this.map.put(Objects.requireNonNull(key, "a Dictionary cannot contain a null key"), Objects.requireNonNull(value, "a Dictionary cannot contain a null value"));
        }

        @Override
        public V remove(Object key) {
            if (key == null) {
                return null;
            }
            return this.map.remove(key);
        }

        public String toString() {
            return this.map.toString();
        }
    }

    private static class DictionaryAsMap<K, V>
    extends AbstractMap<K, V> {
        private final Dictionary<K, V> dict;

        DictionaryAsMap(Dictionary<? extends K, ? extends V> dict) {
            this.dict = Objects.requireNonNull(dict);
        }

        Iterator<K> keys() {
            ArrayList<K> keys = new ArrayList<K>(this.dict.size());
            Enumeration<K> e = this.dict.keys();
            while (e.hasMoreElements()) {
                keys.add(e.nextElement());
            }
            return keys.iterator();
        }

        @Override
        public int size() {
            return this.dict.size();
        }

        @Override
        public boolean isEmpty() {
            return this.dict.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            if (key == null) {
                return false;
            }
            return this.dict.get(key) != null;
        }

        @Override
        public V get(Object key) {
            if (key == null) {
                return null;
            }
            return this.dict.get(key);
        }

        @Override
        public V put(K key, V value) {
            return this.dict.put(Objects.requireNonNull(key, "a Dictionary cannot contain a null key"), Objects.requireNonNull(value, "a Dictionary cannot contain a null value"));
        }

        @Override
        public V remove(Object key) {
            if (key == null) {
                return null;
            }
            return this.dict.remove(key);
        }

        @Override
        public void clear() {
            Iterator<K> iter = this.keys();
            while (iter.hasNext()) {
                this.dict.remove(iter.next());
            }
        }

        @Override
        public Set<K> keySet() {
            return new KeySet();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new EntrySet();
        }

        @Override
        public String toString() {
            return this.dict.toString();
        }

        final class Entry
        extends AbstractMap.SimpleEntry<K, V> {
            private static final long serialVersionUID = 1L;

            Entry(K key) {
                super(key, DictionaryAsMap.this.get(key));
            }

            @Override
            public V setValue(V value) {
                DictionaryAsMap.this.put(this.getKey(), value);
                return super.setValue(value);
            }
        }

        final class EntryIterator
        implements Iterator<Map.Entry<K, V>> {
            private final Iterator<K> keys;
            private K key;

            EntryIterator() {
                this.keys = DictionaryAsMap.this.keys();
                this.key = null;
            }

            @Override
            public boolean hasNext() {
                return this.keys.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                this.key = this.keys.next();
                return new Entry(this.key);
            }

            @Override
            public void remove() {
                if (this.key == null) {
                    throw new IllegalStateException();
                }
                DictionaryAsMap.this.remove(this.key);
                this.key = null;
            }
        }

        final class EntrySet
        extends AbstractSet<Map.Entry<K, V>> {
            EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntryIterator();
            }

            @Override
            public int size() {
                return DictionaryAsMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return DictionaryAsMap.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry e = (Map.Entry)o;
                    return this.containsEntry(e);
                }
                return false;
            }

            private boolean containsEntry(Map.Entry<?, ?> e) {
                Object key = e.getKey();
                if (key == null) {
                    return false;
                }
                Object value = e.getValue();
                if (value == null) {
                    return false;
                }
                return Objects.equals(DictionaryAsMap.this.get(key), value);
            }

            @Override
            public boolean remove(Object o) {
                Map.Entry e;
                if (o instanceof Map.Entry && this.containsEntry(e = (Map.Entry)o)) {
                    DictionaryAsMap.this.remove(e.getKey());
                    return true;
                }
                return false;
            }

            @Override
            public void clear() {
                DictionaryAsMap.this.clear();
            }
        }

        final class KeyIterator
        implements Iterator<K> {
            private final Iterator<K> keys;
            private K key;

            KeyIterator() {
                this.keys = DictionaryAsMap.this.keys();
                this.key = null;
            }

            @Override
            public boolean hasNext() {
                return this.keys.hasNext();
            }

            @Override
            public K next() {
                this.key = this.keys.next();
                return this.key;
            }

            @Override
            public void remove() {
                if (this.key == null) {
                    throw new IllegalStateException();
                }
                DictionaryAsMap.this.remove(this.key);
                this.key = null;
            }
        }

        final class KeySet
        extends AbstractSet<K> {
            KeySet() {
            }

            @Override
            public Iterator<K> iterator() {
                return new KeyIterator();
            }

            @Override
            public int size() {
                return DictionaryAsMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return DictionaryAsMap.this.isEmpty();
            }

            @Override
            public boolean contains(Object key) {
                return DictionaryAsMap.this.containsKey(key);
            }

            @Override
            public boolean remove(Object key) {
                return DictionaryAsMap.this.remove(key) != null;
            }

            @Override
            public void clear() {
                DictionaryAsMap.this.clear();
            }
        }
    }
}

