/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.common.install;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.test.common.exceptions.Exceptions;

public class InstallBundle {
    private final BundleContext bundleContext;

    public InstallBundle(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public Bundle installBundle(String pathToEmbeddedJar) {
        return this.installBundle(pathToEmbeddedJar, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Bundle installBundle(String pathToEmbeddedJar, boolean startBundle) {
        String[] stringArray;
        int lastIndexOf = pathToEmbeddedJar.lastIndexOf(47);
        if (lastIndexOf == -1) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "/";
            stringArray = stringArray2;
            stringArray2[1] = pathToEmbeddedJar;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = pathToEmbeddedJar.substring(0, lastIndexOf);
            stringArray = stringArray3;
            stringArray3[1] = pathToEmbeddedJar.substring(lastIndexOf + 1);
        }
        String[] parts = stringArray;
        Enumeration entries = this.bundleContext.getBundle().findEntries(parts[0], parts[1], false);
        if (entries == null) throw new AssertionError((Object)("No bundle entry " + pathToEmbeddedJar + " found in " + this.bundleContext.getBundle()));
        if (!entries.hasMoreElements()) {
            throw new AssertionError((Object)("No bundle entry " + pathToEmbeddedJar + " found in " + this.bundleContext.getBundle()));
        }
        try (InputStream is = ((URL)entries.nextElement()).openStream();){
            Bundle bundle = this.bundleContext.installBundle(pathToEmbeddedJar, is);
            if (startBundle) {
                bundle.start();
            }
            Bundle bundle2 = bundle;
            return bundle2;
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }
}

