/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.junit4.service;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.common.inject.FieldInjector;
import org.osgi.test.common.service.ServiceAware;
import org.osgi.test.common.service.ServiceConfiguration;
import org.osgi.test.common.service.ServiceConfigurationKey;

public class ServiceRule
implements AutoCloseable,
MethodRule {
    private final Map<ServiceConfigurationKey<?>, ServiceConfiguration<?>> configurations = new ConcurrentHashMap();

    public ServiceRule init(Object testInstance) {
        BundleContext bundleContext = FrameworkUtil.getBundle(testInstance.getClass()).getBundleContext();
        List fields = FieldInjector.findAnnotatedNonStaticFields(testInstance.getClass(), InjectService.class);
        fields.forEach(field -> {
            ServiceRule.assertValidFieldCandidate(field);
            InjectService injectService = field.getAnnotation(InjectService.class);
            Class<?> memberType = field.getType();
            Type genericMemberType = field.getGenericType();
            FieldInjector.setField((Field)field, (Object)testInstance, (Object)ServiceRule.resolveReturnValue(memberType, genericMemberType, injectService, bundleContext, this.configurations));
        });
        return this;
    }

    @Override
    public void close() throws Exception {
        Iterator<Map.Entry<ServiceConfigurationKey<?>, ServiceConfiguration<?>>> itr = this.configurations.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<ServiceConfigurationKey<?>, ServiceConfiguration<?>> entry = itr.next();
            entry.getValue().close();
            itr.remove();
        }
    }

    public Statement apply(final Statement statement, FrameworkMethod method, Object testInstance) {
        this.init(testInstance);
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    statement.evaluate();
                }
                finally {
                    ServiceRule.this.close();
                }
            }
        };
    }

    static void assertValidFieldCandidate(Field field) {
        if (Modifier.isFinal(field.getModifiers()) || Modifier.isPrivate(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
            throw new RuntimeException(InjectService.class.getName() + " field [" + field + "] must not be final, private or static.");
        }
    }

    static <X> ServiceConfiguration<X> getServiceUseConfiguration(InjectService injectService, Class<X> serviceType, BundleContext bundleContext, Map<ServiceConfigurationKey<?>, ServiceConfiguration<?>> configurations) {
        ServiceConfiguration closeableTrackServices = configurations.computeIfAbsent(new ServiceConfigurationKey(serviceType, injectService.filter(), injectService.filterArguments(), injectService.cardinality(), injectService.timeout()), key -> new ServiceConfiguration(key).init(bundleContext));
        return closeableTrackServices;
    }

    static Object resolveReturnValue(Class<?> memberType, Type genericMemberType, InjectService serviceUseParameter, BundleContext bundleContext, Map<ServiceConfigurationKey<?>, ServiceConfiguration<?>> configurations) {
        Type serviceType = genericMemberType;
        if (List.class.equals(memberType) && genericMemberType instanceof ParameterizedType) {
            serviceType = ((ParameterizedType)serviceType).getActualTypeArguments()[0];
        } else if (ServiceAware.class.equals(memberType) && genericMemberType instanceof ParameterizedType) {
            serviceType = ((ParameterizedType)serviceType).getActualTypeArguments()[0];
        }
        if (!(serviceType instanceof Class)) {
            throw new IllegalStateException("The only generic types allowed are List<S> and ServiceAware<S>: " + serviceType);
        }
        ServiceConfiguration configuration = ServiceRule.getServiceUseConfiguration(serviceUseParameter, (Class)serviceType, bundleContext, configurations);
        if (List.class.equals(memberType) && genericMemberType instanceof ParameterizedType) {
            return configuration.getServices();
        }
        if (ServiceAware.class.equals(memberType) && genericMemberType instanceof ParameterizedType) {
            return configuration;
        }
        return configuration.getService();
    }
}

