/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.junit5.cm;

import java.io.IOException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.test.junit5.cm.BlockingConfigurationHandler;

public class BlockingConfigurationHandlerImpl
implements ConfigurationListener,
BlockingConfigurationHandler {
    private Map<String, CountDownLatch> updateMap = new HashMap<String, CountDownLatch>();
    private Map<String, CountDownLatch> deleteMap = new HashMap<String, CountDownLatch>();

    @Override
    public boolean update(Configuration configuration, Dictionary<String, Object> dictionary, long timeout) throws InterruptedException, IOException {
        CountDownLatch latch = this.createCountdownLatchUpdate(configuration.getPid());
        configuration.update(dictionary);
        boolean isOk = latch.await(timeout, TimeUnit.MILLISECONDS);
        return isOk;
    }

    @Override
    public boolean delete(Configuration configuration, long timeout) throws InterruptedException, IOException {
        CountDownLatch latch = this.createCountdownLatchDelete(configuration.getPid());
        configuration.delete();
        boolean isOk = latch.await(timeout, TimeUnit.MILLISECONDS);
        return isOk;
    }

    private CountDownLatch createCountdownLatchUpdate(String pid) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.updateMap.put(pid, countDownLatch);
        return countDownLatch;
    }

    private CountDownLatch createCountdownLatchDelete(String pid) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.deleteMap.put(pid, countDownLatch);
        return countDownLatch;
    }

    public void configurationEvent(ConfigurationEvent event) {
        CountDownLatch countDownLatch;
        String pid = event.getPid();
        if (event.getType() == 1) {
            CountDownLatch countDownLatch2 = this.updateMap.get(pid);
            if (countDownLatch2 != null) {
                this.updateMap.remove(pid);
                countDownLatch2.countDown();
            }
        } else if (event.getType() == 2 && (countDownLatch = this.deleteMap.get(pid)) != null) {
            this.deleteMap.remove(pid);
            countDownLatch.countDown();
        }
    }
}

