/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.junit5.cm;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.test.common.annotation.PropertiesConverter;
import org.osgi.test.common.annotation.Property;
import org.osgi.test.common.annotation.config.InjectConfiguration;
import org.osgi.test.common.annotation.config.WithConfiguration;
import org.osgi.test.common.annotation.config.WithConfigurations;
import org.osgi.test.common.annotation.config.WithFactoryConfiguration;
import org.osgi.test.common.annotation.config.WithFactoryConfigurations;
import org.osgi.test.common.dictionary.Dictionaries;
import org.osgi.test.common.inject.FieldInjector;
import org.osgi.test.common.inject.TargetType;
import org.osgi.test.junit5.cm.BlockingConfigurationHandler;
import org.osgi.test.junit5.cm.BlockingConfigurationHandlerImpl;
import org.osgi.test.junit5.cm.ConfigUtil;
import org.osgi.test.junit5.cm.ConfigurationCopy;
import org.osgi.test.junit5.context.BundleContextExtension;
import org.osgi.test.junit5.service.ServiceExtension;

public class ConfigurationExtension
implements BeforeEachCallback,
ParameterResolver,
BeforeAllCallback,
AfterAllCallback,
AfterEachCallback {
    private static final String STORE_CONFIGURATION_KEY = "store.configurationAdmin";
    private static BlockingConfigurationHandler blockingConfigHandler;

    static BundleContext bc(ExtensionContext extensionContext) {
        return BundleContextExtension.getBundleContext((ExtensionContext)extensionContext);
    }

    static ConfigurationAdmin ca(ExtensionContext extensionContext) {
        return (ConfigurationAdmin)ServiceExtension.getServiceConfiguration(ConfigurationAdmin.class, (String)"", (String[])new String[0], (int)0, (long)0L, (ExtensionContext)extensionContext).getService();
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        this.storeConfigCopy(extensionContext);
        this.handleInjectConfigAnnotationOnFields(extensionContext);
        this.handleAnnotationsOnActiveElement(extensionContext);
    }

    private void handleInjectConfigAnnotationOnFields(ExtensionContext extensionContext) throws Exception {
        List fields = FieldInjector.findAnnotatedFields((Class)extensionContext.getRequiredTestClass(), InjectConfiguration.class);
        for (Field field : fields) {
            this.handleInjectConfigAnnotationOnField(extensionContext, field);
        }
    }

    private void handleInjectConfigAnnotationOnField(ExtensionContext extensionContext, Field field) throws Exception {
        ConfigurationExtension.assertValidFieldCandidate(field);
        ConfigurationAdmin ca = ConfigurationExtension.ca(extensionContext);
        TargetType targetType = TargetType.of((Field)field);
        InjectConfiguration injectConfiguration = field.getAnnotation(InjectConfiguration.class);
        Configuration ic = ConfigUtil.getConfigsByServicePid(ca, injectConfiguration.value(), injectConfiguration.timeout());
        Object objectToInject = this.transformConfigToTargetType(ic, targetType);
        FieldInjector.setField((Field)field, (Object)extensionContext.getRequiredTestInstance(), (Object)objectToInject);
    }

    private void storeConfigCopy(ExtensionContext extensionContext) throws Exception {
        List<Configuration> configurations = ConfigUtil.getAllConfigurations(ConfigurationExtension.ca(extensionContext));
        List<ConfigurationCopy> configurationCopies = ConfigUtil.cloneConfigurations(configurations);
        extensionContext.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{ConfigurationExtension.class, extensionContext.getUniqueId()})).put((Object)STORE_CONFIGURATION_KEY, configurationCopies);
    }

    Configuration handleWithConfiguration(WithConfiguration configAnnotation, ConfigurationAdmin configurationAdmin, BlockingConfigurationHandler blockingConfigHandler) throws ParameterResolutionException, IllegalArgumentException {
        try {
            Configuration configBefore = ConfigUtil.getConfigsByServicePid(configurationAdmin, configAnnotation.pid(), 0L);
            Configuration configuration = "org.osgi.test.common.annotation.notset".equals(configAnnotation.location()) ? configurationAdmin.getConfiguration(configAnnotation.pid()) : configurationAdmin.getConfiguration(configAnnotation.pid(), configAnnotation.location());
            this.updateConfigurationRespectNew(configuration, PropertiesConverter.of((Property[])configAnnotation.properties()), configBefore == null);
            return configuration;
        }
        catch (Exception e) {
            throw new ParameterResolutionException("ConfigurationAdmin could not be found", (Throwable)e);
        }
    }

    Configuration handleWithFactoryConfiguration(WithFactoryConfiguration configAnnotation, ConfigurationAdmin configurationAdmin) throws ParameterResolutionException, IllegalArgumentException {
        try {
            Configuration configBefore = ConfigUtil.getConfigsByServicePid(configurationAdmin, configAnnotation.factoryPid() + "~" + configAnnotation.name());
            Configuration configuration = "org.osgi.test.common.annotation.notset".equals(configAnnotation.location()) ? configurationAdmin.getFactoryConfiguration(configAnnotation.factoryPid(), configAnnotation.name()) : configurationAdmin.getFactoryConfiguration(configAnnotation.factoryPid(), configAnnotation.name(), configAnnotation.location());
            this.updateConfigurationRespectNew(configuration, PropertiesConverter.of((Property[])configAnnotation.properties()), configBefore == null);
            return configuration;
        }
        catch (Exception e) {
            throw new ParameterResolutionException("ConfigurationAdmin could not be found", (Throwable)e);
        }
    }

    static void assertValidFieldCandidate(Field field) {
        if (Modifier.isFinal(field.getModifiers()) || Modifier.isPrivate(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
            throw new ExtensionConfigurationException("@" + WithConfiguration.class.getSimpleName() + " field [" + field.getName() + "] must not be final, private or static.");
        }
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        ConfigurationAdmin ca = ConfigurationExtension.ca(extensionContext);
        try {
            Optional injectConfiguration = parameterContext.findAnnotation(InjectConfiguration.class);
            TargetType targetType = TargetType.of((Parameter)parameterContext.getParameter());
            if (injectConfiguration.isPresent()) {
                InjectConfiguration ic = (InjectConfiguration)injectConfiguration.get();
                Configuration configuration = null;
                boolean valueUsed = false;
                boolean withConfigUsed = false;
                boolean withFactoryConfigUsed = false;
                if (!ic.value().equals("org.osgi.test.common.annotation.notset")) {
                    configuration = ConfigUtil.getConfigsByServicePid(ConfigurationExtension.ca(extensionContext), ic.value(), ic.timeout());
                    valueUsed = true;
                } else if (!ic.withConfig().pid().equals("org.osgi.test.common.annotation.notset")) {
                    if (valueUsed) {
                        throw new IllegalArgumentException("@InjectConfiguration - only one of the Fields `value`, `withConfig` or `withFactoryConfig` could be used.");
                    }
                    WithConfiguration wc = ic.withConfig();
                    configuration = this.handleWithConfiguration(wc, ca, blockingConfigHandler);
                    withConfigUsed = true;
                } else if (!ic.withFactoryConfig().factoryPid().equals("org.osgi.test.common.annotation.notset")) {
                    if (valueUsed || withConfigUsed) {
                        throw new IllegalArgumentException("@InjectConfiguration - only one of the Fields `value`, `withConfig` or `withFactoryConfig` could be used.");
                    }
                    WithFactoryConfiguration wc = ic.withFactoryConfig();
                    configuration = this.handleWithFactoryConfiguration(wc, ca);
                    withFactoryConfigUsed = true;
                }
                if (!(valueUsed || withConfigUsed || withFactoryConfigUsed)) {
                    throw new IllegalArgumentException("@InjectConfiguration - one of the Fields `value`, `withConfig` or `withFactoryConfig` must be used.");
                }
                return this.transformConfigToTargetType(configuration, targetType);
            }
            return null;
        }
        catch (Exception e) {
            throw new ParameterResolutionException("Could not get Configuration from Configuration-Admin", (Throwable)e);
        }
    }

    private Object transformConfigToTargetType(Configuration configuration, TargetType targetType) throws Exception {
        if (targetType.matches(Configuration.class)) {
            return configuration;
        }
        if (targetType.matches(Optional.class, new Type[]{Configuration.class})) {
            return Optional.ofNullable(configuration);
        }
        if (targetType.matches(Map.class, new Type[]{String.class, Object.class})) {
            return Dictionaries.asMap((Dictionary)configuration.getProperties());
        }
        if (targetType.matches(Dictionary.class, new Type[]{String.class, Object.class})) {
            return configuration.getProperties();
        }
        throw new ParameterResolutionException("Bad Parameter-Type");
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Parameter parameter;
        return parameterContext.isAnnotated(InjectConfiguration.class) && ((parameter = parameterContext.getParameter()).getType().isAssignableFrom(Configuration.class) || parameter.getType().isAssignableFrom(Optional.class) && ((ParameterizedType)parameter.getParameterizedType()).getActualTypeArguments()[0].equals(Configuration.class) || parameter.getType().isAssignableFrom(Map.class) || parameter.getType().isAssignableFrom(Dictionary.class));
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        BlockingConfigurationHandlerImpl blockingConfigHandlerImpl = new BlockingConfigurationHandlerImpl();
        ConfigurationExtension.bc(extensionContext).registerService(ConfigurationListener.class, (Object)blockingConfigHandlerImpl, null);
        blockingConfigHandler = blockingConfigHandlerImpl;
        this.storeConfigCopy(extensionContext);
        this.handleAnnotationsOnActiveElement(extensionContext);
    }

    private void handleAnnotationsOnActiveElement(ExtensionContext extensionContext) {
        this.handleWithConfigurations(extensionContext);
        this.handleWithConfiguration(extensionContext);
        this.handleWithFactoryConfigurations(extensionContext);
        this.handleWithFactoryConfiguration(extensionContext);
    }

    private void handleWithFactoryConfiguration(ExtensionContext extensionContext) {
        extensionContext.getElement().ifPresent(element -> {
            WithFactoryConfiguration factoryConfigAnnotation = element.getAnnotation(WithFactoryConfiguration.class);
            if (factoryConfigAnnotation != null) {
                this.handleWithFactoryConfiguration(factoryConfigAnnotation, ConfigurationExtension.ca(extensionContext));
            }
        });
    }

    private void handleWithFactoryConfigurations(ExtensionContext extensionContext) {
        extensionContext.getElement().ifPresent(element -> {
            WithFactoryConfigurations factoryConfigAnnotations = element.getAnnotation(WithFactoryConfigurations.class);
            if (factoryConfigAnnotations != null) {
                Stream.of(factoryConfigAnnotations.value()).forEachOrdered(factoryConfigAnnotation -> this.handleWithFactoryConfiguration((WithFactoryConfiguration)factoryConfigAnnotation, ConfigurationExtension.ca(extensionContext)));
            }
        });
    }

    private void handleWithConfiguration(ExtensionContext extensionContext) {
        extensionContext.getElement().ifPresent(element -> {
            WithConfiguration configAnnotation = element.getAnnotation(WithConfiguration.class);
            if (configAnnotation != null) {
                this.handleWithConfiguration(configAnnotation, ConfigurationExtension.ca(extensionContext), blockingConfigHandler);
            }
        });
    }

    private void handleWithConfigurations(ExtensionContext extensionContext) {
        extensionContext.getElement().ifPresent(element -> {
            WithConfigurations configAnnotations = element.getAnnotation(WithConfigurations.class);
            if (configAnnotations != null) {
                Stream.of(configAnnotations.value()).forEachOrdered(configAnnotation -> this.handleWithConfiguration((WithConfiguration)configAnnotation, ConfigurationExtension.ca(extensionContext), blockingConfigHandler));
            }
        });
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        this.reset(extensionContext);
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        this.reset(extensionContext);
    }

    private void reset(ExtensionContext extensionContext) throws Exception {
        List copys = (List)ConfigurationExtension.getStore(extensionContext).get((Object)STORE_CONFIGURATION_KEY, List.class);
        ConfigUtil.resetConfig(blockingConfigHandler, ConfigurationExtension.ca(extensionContext), copys);
        ConfigurationExtension.getStore(extensionContext).remove((Object)STORE_CONFIGURATION_KEY, List.class);
    }

    static ExtensionContext.Store getStore(ExtensionContext extensionContext) {
        return extensionContext.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{ConfigurationExtension.class, extensionContext.getUniqueId()}));
    }

    public void updateConfigurationRespectNew(Configuration configurationToBeUpdated, Dictionary<String, Object> newConfigurationProperties, boolean isNewConfiguration) throws InterruptedException, IOException {
        if (configurationToBeUpdated != null) {
            if (newConfigurationProperties != null && !ConfigUtil.isDictionaryWithNotSetMarker(newConfigurationProperties)) {
                blockingConfigHandler.update(configurationToBeUpdated, newConfigurationProperties, 1000L);
            } else if (isNewConfiguration) {
                blockingConfigHandler.update(configurationToBeUpdated, Dictionaries.dictionaryOf(), 1000L);
            }
        }
    }
}

