/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.junit5.cm;

import java.io.IOException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.test.common.context.ContextHelper;
import org.osgi.test.junit5.cm.BlockingConfigurationHandler;

public class BlockingConfigurationHandlerImpl
implements ConfigurationListener,
BlockingConfigurationHandler,
ExtensionContext.Store.CloseableResource {
    private final Map<String, CountDownLatch> updateMap = new HashMap<String, CountDownLatch>();
    private final Map<String, CountDownLatch> deleteMap = new HashMap<String, CountDownLatch>();
    private final ServiceRegistration<?> reg;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public BlockingConfigurationHandlerImpl() {
        this(Optional.empty());
    }

    public BlockingConfigurationHandlerImpl(Optional<Class<?>> testClass) {
        BundleContext context = ContextHelper.getBundleContext(testClass.orElse(BlockingConfigurationHandlerImpl.class));
        this.reg = context.registerService(ConfigurationListener.class, (Object)this, null);
    }

    public void close() throws Throwable {
        this.reg.unregister();
        this.closed.set(true);
    }

    @Override
    public boolean update(Configuration configuration, Dictionary<String, Object> dictionary, long timeout) throws InterruptedException, IOException {
        Assertions.assertFalse((boolean)this.closed.get(), (String)"BlockingConfigurationHandler was closed");
        CountDownLatch latch = this.createCountdownLatchUpdate(configuration.getPid());
        boolean updatedBecauseDifferent = configuration.updateIfDifferent(dictionary);
        if (!updatedBecauseDifferent) {
            this.updateMap.remove(configuration.getPid());
            return true;
        }
        boolean isOk = latch.await(timeout, TimeUnit.MILLISECONDS);
        return isOk;
    }

    @Override
    public boolean delete(Configuration configuration, long timeout) throws InterruptedException, IOException {
        Assertions.assertFalse((boolean)this.closed.get(), (String)"BlockingConfigurationHandler was closed");
        CountDownLatch latch = this.createCountdownLatchDelete(configuration.getPid());
        configuration.delete();
        boolean isOk = latch.await(timeout, TimeUnit.MILLISECONDS);
        return isOk;
    }

    private CountDownLatch createCountdownLatchUpdate(String pid) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.updateMap.put(pid, countDownLatch);
        return countDownLatch;
    }

    private CountDownLatch createCountdownLatchDelete(String pid) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.deleteMap.put(pid, countDownLatch);
        return countDownLatch;
    }

    public void configurationEvent(ConfigurationEvent event) {
        CountDownLatch countDownLatch;
        String pid = event.getPid();
        if (event.getType() == 1) {
            CountDownLatch countDownLatch2 = this.updateMap.remove(pid);
            if (countDownLatch2 != null) {
                countDownLatch2.countDown();
            }
        } else if (event.getType() == 2 && (countDownLatch = this.deleteMap.remove(pid)) != null) {
            countDownLatch.countDown();
        }
    }
}

