/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.junit5.context;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.test.common.annotation.InjectBundleContext;
import org.osgi.test.common.annotation.InjectInstallBundle;
import org.osgi.test.common.context.CloseableBundleContext;
import org.osgi.test.common.inject.FieldInjector;
import org.osgi.test.common.install.InstallBundle;

public class BundleContextExtension
implements BeforeAllCallback,
BeforeEachCallback,
ParameterResolver {
    public static final String BUNDLE_CONTEXT_KEY = "bundle.context";
    public static final String INSTALL_BUNDLE_KEY = "install.bundle";

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        List fields = FieldInjector.findAnnotatedFields((Class)extensionContext.getRequiredTestClass(), InjectBundleContext.class, m -> Modifier.isStatic(m.getModifiers()));
        fields.forEach(field -> {
            FieldInjector.assertFieldIsOfType((Field)field, BundleContext.class, InjectBundleContext.class, ExtensionConfigurationException::new);
            FieldInjector.setField((Field)field, null, (Object)BundleContextExtension.getBundleContext(extensionContext));
        });
        fields = FieldInjector.findAnnotatedFields((Class)extensionContext.getRequiredTestClass(), InjectInstallBundle.class, m -> Modifier.isStatic(m.getModifiers()));
        fields.forEach(field -> {
            FieldInjector.assertFieldIsOfType((Field)field, InstallBundle.class, InjectInstallBundle.class, ExtensionConfigurationException::new);
            FieldInjector.setField((Field)field, null, (Object)BundleContextExtension.getInstallbundle(extensionContext));
        });
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        for (Object instance : extensionContext.getRequiredTestInstances().getAllInstances()) {
            Class<?> testClass = instance.getClass();
            List fields = FieldInjector.findAnnotatedNonStaticFields(testClass, InjectBundleContext.class);
            fields.forEach(field -> {
                FieldInjector.assertFieldIsOfType((Field)field, BundleContext.class, InjectBundleContext.class, ExtensionConfigurationException::new);
                FieldInjector.setField((Field)field, (Object)instance, (Object)BundleContextExtension.getBundleContext(extensionContext));
            });
            fields = FieldInjector.findAnnotatedNonStaticFields(testClass, InjectInstallBundle.class);
            fields.forEach(field -> {
                FieldInjector.assertFieldIsOfType((Field)field, InstallBundle.class, InjectInstallBundle.class, ExtensionConfigurationException::new);
                FieldInjector.setField((Field)field, (Object)instance, (Object)BundleContextExtension.getInstallbundle(extensionContext));
            });
        }
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Class<?> parameterType = parameterContext.getParameter().getType();
        if (parameterContext.isAnnotated(InjectBundleContext.class)) {
            FieldInjector.assertParameterIsOfType(parameterType, BundleContext.class, InjectBundleContext.class, ParameterResolutionException::new);
            return BundleContextExtension.getBundleContext(extensionContext);
        }
        if (parameterContext.isAnnotated(InjectInstallBundle.class)) {
            FieldInjector.assertParameterIsOfType(parameterType, InstallBundle.class, InjectInstallBundle.class, ParameterResolutionException::new);
            return BundleContextExtension.getInstallbundle(extensionContext);
        }
        throw new ExtensionConfigurationException("No parameter types known to BundleContextExtension were found");
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        boolean annotatedBundleContextParameter = parameterContext.isAnnotated(InjectBundleContext.class);
        boolean annotatedInstallBundleParameter = parameterContext.isAnnotated(InjectInstallBundle.class);
        if ((annotatedBundleContextParameter || annotatedInstallBundleParameter) && parameterContext.getDeclaringExecutable() instanceof Constructor) {
            throw new ParameterResolutionException("BundleContextExtension does not support parameter injection on constructors");
        }
        return annotatedBundleContextParameter || annotatedInstallBundleParameter;
    }

    public static BundleContext getBundleContext(ExtensionContext extensionContext) {
        BundleContext bundleContext = ((CloseableResourceBundleContext)BundleContextExtension.getStore(extensionContext).getOrComputeIfAbsent((Object)BUNDLE_CONTEXT_KEY, key -> new CloseableResourceBundleContext(extensionContext.getRequiredTestClass(), BundleContextExtension.getParentBundleContext(extensionContext)), CloseableResourceBundleContext.class)).get();
        return bundleContext;
    }

    private static BundleContext getParentBundleContext(ExtensionContext extensionContext) {
        BundleContext parentContext = extensionContext.getParent().filter(context -> context.getTestClass().isPresent()).map(BundleContextExtension::getBundleContext).orElseGet(() -> FrameworkUtil.getBundle((Class)extensionContext.getRequiredTestClass()).getBundleContext());
        return parentContext;
    }

    public static InstallBundle getInstallbundle(ExtensionContext extensionContext) {
        return (InstallBundle)BundleContextExtension.getStore(extensionContext).getOrComputeIfAbsent((Object)INSTALL_BUNDLE_KEY, key -> new InstallBundle(BundleContextExtension.getBundleContext(extensionContext)), InstallBundle.class);
    }

    static ExtensionContext.Store getStore(ExtensionContext extensionContext) {
        return extensionContext.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{BundleContextExtension.class, extensionContext.getUniqueId()}));
    }

    public static class CloseableResourceBundleContext
    implements ExtensionContext.Store.CloseableResource {
        private final BundleContext bundleContext;

        CloseableResourceBundleContext(Class<?> testClass, BundleContext bundleContext) {
            this.bundleContext = CloseableBundleContext.proxy(testClass, (BundleContext)bundleContext);
        }

        public void close() throws Exception {
            ((AutoCloseable)this.get()).close();
        }

        public BundleContext get() {
            return this.bundleContext;
        }

        public String toString() {
            return this.get().toString();
        }
    }
}

