/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.junit5.service;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.common.inject.FieldInjector;
import org.osgi.test.common.inject.TargetType;
import org.osgi.test.common.service.ServiceAware;
import org.osgi.test.common.service.ServiceConfiguration;
import org.osgi.test.common.service.ServiceConfigurationKey;
import org.osgi.test.junit5.context.BundleContextExtension;

public class ServiceExtension
implements BeforeAllCallback,
BeforeEachCallback,
ParameterResolver {
    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        List fields = FieldInjector.findAnnotatedFields((Class)extensionContext.getRequiredTestClass(), InjectService.class, m -> Modifier.isStatic(m.getModifiers()));
        fields.forEach(field -> {
            ServiceExtension.assertValidFieldCandidate(field);
            InjectService serviceUseParameter = field.getAnnotation(InjectService.class);
            TargetType targetType = TargetType.of((Field)field);
            FieldInjector.setField((Field)field, null, (Object)ServiceExtension.resolveReturnValue(targetType, serviceUseParameter, extensionContext));
        });
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        for (Object instance : extensionContext.getRequiredTestInstances().getAllInstances()) {
            List fields = FieldInjector.findAnnotatedNonStaticFields(instance.getClass(), InjectService.class);
            fields.forEach(field -> {
                ServiceExtension.assertValidFieldCandidate(field);
                InjectService serviceUseParameter = field.getAnnotation(InjectService.class);
                TargetType targetType = TargetType.of((Field)field);
                FieldInjector.setField((Field)field, (Object)instance, (Object)ServiceExtension.resolveReturnValue(targetType, serviceUseParameter, extensionContext));
            });
        }
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Optional injectService = parameterContext.findAnnotation(InjectService.class);
        Parameter parameter = parameterContext.getParameter();
        TargetType targetType = TargetType.of((Parameter)parameter);
        return ServiceExtension.resolveReturnValue(targetType, (InjectService)injectService.get(), extensionContext);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Type genericMemberType;
        if (!parameterContext.isAnnotated(InjectService.class)) {
            return false;
        }
        Parameter parameter = parameterContext.getParameter();
        Class<?> memberType = parameter.getType();
        Type serviceType = genericMemberType = parameter.getParameterizedType();
        if (List.class.equals(memberType) && genericMemberType instanceof ParameterizedType) {
            serviceType = ((ParameterizedType)genericMemberType).getActualTypeArguments()[0];
        } else if (ServiceAware.class.equals(memberType) && genericMemberType instanceof ParameterizedType) {
            serviceType = ((ParameterizedType)genericMemberType).getActualTypeArguments()[0];
        }
        if (serviceType instanceof Class) {
            return true;
        }
        throw new ParameterResolutionException("Can only resolve @" + InjectService.class.getSimpleName() + " parameter for services with non-generic types, service type was: " + serviceType.getTypeName());
    }

    static void assertValidFieldCandidate(Field field) {
        if (Modifier.isFinal(field.getModifiers()) || Modifier.isPrivate(field.getModifiers())) {
            throw new ExtensionConfigurationException("@" + InjectService.class.getSimpleName() + " field [" + field.getName() + "] must not be final or private.");
        }
    }

    public static <S> ServiceConfiguration<S> getServiceConfiguration(Class<S> serviceType, String format, String[] args, int cardinality, long timeout, ExtensionContext extensionContext) {
        ServiceConfiguration serviceConfiguration = ((CloseableServiceConfiguration)ServiceExtension.getStore(extensionContext).getOrComputeIfAbsent((Object)new ServiceConfigurationKey(serviceType, format, args, cardinality, timeout), key -> new CloseableServiceConfiguration(new ServiceConfiguration(key).init(BundleContextExtension.getBundleContext(extensionContext))), CloseableServiceConfiguration.class)).get();
        return serviceConfiguration;
    }

    static Object resolveReturnValue(TargetType targetType, InjectService injectService, ExtensionContext extensionContext) throws ParameterResolutionException {
        Optional o;
        Type serviceType = targetType.getType();
        if ((targetType.matches(List.class) || targetType.matches(ServiceAware.class)) && (o = targetType.getFirstGenericTypes()).isPresent()) {
            serviceType = (Type)o.get();
        }
        assert (serviceType instanceof Class);
        ServiceConfiguration configuration = ServiceExtension.getServiceConfiguration(serviceType, injectService.filter(), injectService.filterArguments(), injectService.cardinality(), injectService.timeout(), extensionContext);
        if (targetType.matches(List.class) && targetType.hasParameterizedTypes()) {
            return configuration.getServices();
        }
        if (targetType.matches(ServiceAware.class) && targetType.hasParameterizedTypes()) {
            return configuration;
        }
        return configuration.getService();
    }

    static ExtensionContext.Store getStore(ExtensionContext extensionContext) {
        return extensionContext.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{ServiceExtension.class, extensionContext.getUniqueId()}));
    }

    public static class CloseableServiceConfiguration<S>
    implements ExtensionContext.Store.CloseableResource {
        private final ServiceConfiguration<S> serviceConfiguration;

        CloseableServiceConfiguration(ServiceConfiguration<S> serviceConfiguration) {
            this.serviceConfiguration = serviceConfiguration;
        }

        public void close() throws Exception {
            this.get().close();
        }

        public ServiceConfiguration<S> get() {
            return this.serviceConfiguration;
        }

        public String toString() {
            return this.get().toString();
        }
    }
}

