/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.junit5.context;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.test.common.annotation.InjectInstalledBundle;
import org.osgi.test.common.inject.FieldInjector;
import org.osgi.test.common.install.BundleInstaller;
import org.osgi.test.junit5.context.BundleContextExtension;

public class InstalledBundleExtension
implements BeforeAllCallback,
BeforeEachCallback,
ParameterResolver {
    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        List fields = FieldInjector.findAnnotatedFields((Class)extensionContext.getRequiredTestClass(), InjectInstalledBundle.class, m -> Modifier.isStatic(m.getModifiers()));
        fields.forEach(field -> {
            FieldInjector.assertFieldIsOfType((Field)field, Bundle.class, InjectInstalledBundle.class, ExtensionConfigurationException::new);
            InjectInstalledBundle injectBundle = field.getAnnotation(InjectInstalledBundle.class);
            FieldInjector.setField((Field)field, null, (Object)this.installedBundleOf(injectBundle, extensionContext));
        });
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        for (Object instance : extensionContext.getRequiredTestInstances().getAllInstances()) {
            Class<?> testClass = instance.getClass();
            List fields = FieldInjector.findAnnotatedNonStaticFields(testClass, InjectInstalledBundle.class);
            fields.forEach(field -> {
                FieldInjector.assertFieldIsOfType((Field)field, Bundle.class, InjectInstalledBundle.class, ExtensionConfigurationException::new);
                InjectInstalledBundle injectBundle = field.getAnnotation(InjectInstalledBundle.class);
                FieldInjector.setField((Field)field, (Object)instance, (Object)this.installedBundleOf(injectBundle, extensionContext));
            });
        }
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Parameter parameter = parameterContext.getParameter();
        Class<?> parameterType = parameter.getType();
        if (parameterContext.isAnnotated(InjectInstalledBundle.class)) {
            FieldInjector.assertParameterIsOfType(parameterType, Bundle.class, InjectInstalledBundle.class, ParameterResolutionException::new);
            InjectInstalledBundle injectBundle = parameter.getAnnotation(InjectInstalledBundle.class);
            return this.installedBundleOf(injectBundle, extensionContext);
        }
        throw new ExtensionConfigurationException("No parameter types known to BundleContextExtension were found");
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        boolean annotatedBundleParameter = parameterContext.isAnnotated(InjectInstalledBundle.class);
        if (annotatedBundleParameter && parameterContext.getDeclaringExecutable() instanceof Constructor) {
            throw new ParameterResolutionException("BundleContextExtension does not support parameter injection on constructors");
        }
        return annotatedBundleParameter;
    }

    private Bundle installedBundleOf(InjectInstalledBundle injectBundle, ExtensionContext extensionContext) {
        try {
            BundleContext bc = BundleContextExtension.getBundleContext(extensionContext);
            BundleInstaller ib = BundleContextExtension.getBundleInstaller(extensionContext);
            String spec = injectBundle.value();
            if (spec.startsWith("http:") || spec.startsWith("https:") || spec.startsWith("file:")) {
                return ib.installBundle(new URL(injectBundle.value()), injectBundle.start());
            }
            return ib.installBundle(BundleInstaller.EmbeddedLocation.of((BundleContext)bc, (String)spec), injectBundle.start());
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new ExtensionConfigurationException(String.format("Could not parse URL from given String %s.", injectBundle.value()), (Throwable)e);
        }
    }

    static ExtensionContext.Store getStore(ExtensionContext extensionContext) {
        return extensionContext.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{InstalledBundleExtension.class, extensionContext.getUniqueId()}));
    }
}

