/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.junit5.service;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.test.common.inject.TargetType;
import org.osgi.test.common.service.ServiceConfiguration;
import org.osgi.test.junit5.context.BundleContextExtension;
import org.osgi.test.junit5.service.ServiceExtension;
import org.osgi.test.junit5.service.ServiceSource;

public class ServiceArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<ServiceSource> {
    private ServiceSource serviceSource;

    public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
        BundleContext bundleContext = BundleContextExtension.getBundleContext(context);
        ServiceConfiguration<?> sc = ServiceExtension.getServiceConfiguration(this.serviceSource.serviceType(), this.serviceSource.filter(), this.serviceSource.filterArguments(), 0, this.serviceSource.timeout(), context);
        Stream<Arguments> stream = sc.getServiceReferences().stream().filter(Objects::nonNull).map(sr -> {
            ArrayList<Object> list = new ArrayList<Object>();
            Optional oElement = context.getElement();
            if (oElement.isPresent() && oElement.get() instanceof Method) {
                Method method = (Method)oElement.get();
                for (Parameter param : method.getParameters()) {
                    TargetType targetType = TargetType.of((Parameter)param);
                    if (targetType.matches(this.serviceSource.serviceType())) {
                        Object service = sc.getTracked().get(sr);
                        list.add(service);
                        continue;
                    }
                    if (targetType.matches(ServiceReference.class, new Type[]{this.serviceSource.serviceType()})) {
                        list.add(sr);
                        continue;
                    }
                    if (targetType.matches(Dictionary.class, new Type[]{String.class, Object.class})) {
                        Hashtable<String, Object> dict = new Hashtable<String, Object>();
                        for (String key : sr.getPropertyKeys()) {
                            ((Dictionary)dict).put(key, sr.getProperty(key));
                        }
                        list.add(dict);
                        continue;
                    }
                    if (!targetType.matches(Map.class, new Type[]{String.class, Object.class})) continue;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    for (String key : sr.getPropertyKeys()) {
                        map.put(key, sr.getProperty(key));
                    }
                    list.add(map);
                }
            }
            return Arguments.of((Object[])list.toArray());
        });
        return stream;
    }

    public void accept(ServiceSource annotation) {
        this.serviceSource = annotation;
    }
}

