/*
 * $Header: /cvshome/repository/org/osgi/service/metatype/MetaTypeProvider.java,v 1.3 2001/07/31 19:06:00 pkriens Exp $
 *
 * Copyright (c) The Open Services Gateway Initiative (2001).
 * All Rights Reserved.
 *
 * Implementation of certain elements of the Open Services Gateway Initiative
 * (OSGI) Specification may be subject to third party intellectual property
 * rights, including without limitation, patent rights (such a third party may
 * or may not be a member of OSGi). OSGi is not responsible and shall not be
 * held responsible in any manner for identifying or failing to identify any or
 * all such third party intellectual property rights.
 *
 * This document and the information contained herein are provided on an "AS
 * IS" basis and OSGI DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO ANY WARRANTY THAT THE USE OF THE INFORMATION HEREIN WILL
 * NOT INFRINGE ANY RIGHTS AND ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR
 * FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT WILL OSGI BE LIABLE FOR ANY
 * LOSS OF PROFITS, LOSS OF BUSINESS, LOSS OF USE OF DATA, INTERRUPTION OF
 * BUSINESS, OR FOR DIRECT, INDIRECT, SPECIAL OR EXEMPLARY, INCIDENTIAL,
 * PUNITIVE OR CONSEQUENTIAL DAMAGES OF ANY KIND IN CONNECTION WITH THIS
 * DOCUMENT OR THE INFORMATION CONTAINED HEREIN, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH LOSS OR DAMAGE.
 *
 * All Company, brand and product names may be trademarks that are the sole
 * property of their respective owners. All rights reserved.
 */

package org.osgi.service.metatype;
import java.util.*;
/**
 * Provides access to metatypes.
 *
 * @version $Revision: 1.3 $
 * @author Open Services Gateway Initiative
*/
public interface MetaTypeProvider {
   /**
    * Return the definition of this object class for a locale.
    *   
    * <p>The locale parameter must be a name that consists
    * of <tt>language</tt> [ "_"  <tt>country</tt> [ "_" <tt>variation</tt> ] ] as is customary
    * in the <tt>Locale</tt> class. This <tt>Locale</tt> class is not
    * used because certain profiles do not contain it.
    *
    * <p>The implementation should use the locale parameter
    * to match an <tt>ObjectClassDefinition</tt> object. It should follow
    * the customary locale search path by removing the latter
    * parts of the name.
    *
    * @param pid    The PID for which the type is needed or null if there is only 1
    * @param locale The locale of the definition or null for default locale
    * @returns the <tt>ObjectClassDefinition</tt> object
    */
    ObjectClassDefinition getObjectClassDefinition(String pid, String locale);

    /**
    * Return a list of locales available or null if only 1
    *   
    * The return parameter must be a name that consists
    * of language [ _  country [ _ variation ]] as is customary
    * in the <tt>Locale</tt> class. This Locale class is not
    * used because certain profiles do not contain it.
    */
    String[] getLocales();
}

