/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;
import org.osgi.util.tracker.ServiceTracker;

class LoggerFactoryTracker
extends ServiceTracker<Object, Object> {
    private static final int QUEUE_SIZE = 200;
    private final BlockingQueue<Entry> queue = new LinkedBlockingQueue<Entry>(200);
    private volatile LoggerFactory firstFactory = null;

    LoggerFactoryTracker(BundleContext context) {
        super(context, LoggerFactory.class.getName(), null);
    }

    public Object addingService(ServiceReference<Object> reference) {
        Object service = this.context.getService(reference);
        if (service instanceof LoggerFactory) {
            if (this.isEmpty()) {
                LoggerFactory factory = (LoggerFactory)service;
                this.drain(factory);
                this.firstFactory = factory;
            }
            return service;
        }
        if (service != null) {
            this.context.ungetService(reference);
        }
        return null;
    }

    public void removedService(ServiceReference<Object> reference, Object service) {
        this.firstFactory = null;
        this.context.ungetService(reference);
    }

    private void drain(LoggerFactory factory) {
        if (factory == null || this.queue.isEmpty()) {
            return;
        }
        ArrayList entries = new ArrayList(200);
        this.queue.drainTo(entries);
        for (Entry entry : entries) {
            entry.log(factory);
        }
    }

    void log(Bundle bundle, String name, LogLevel level, String message, Throwable t) {
        Entry e = new Entry(bundle, name, level, message, t);
        while (!this.queue.offer(e)) {
            ArrayList entries = new ArrayList(200);
            this.queue.drainTo(entries);
            for (Entry entry : entries) {
                System.err.println(entry);
                System.err.flush();
            }
        }
    }

    Logger getLogger(Bundle bundle, String name) {
        LoggerFactory factory = (LoggerFactory)this.getService();
        if (factory == null) {
            factory = this.firstFactory;
        }
        if (factory != null) {
            this.drain(factory);
            return factory.getLogger(bundle, name, Logger.class);
        }
        return null;
    }

    static class Entry {
        private final Bundle bundle;
        private final String name;
        private final LogLevel level;
        private final String message;
        private final Throwable t;

        Entry(Bundle bundle, String name, LogLevel level, String message, Throwable t) {
            this.bundle = bundle;
            this.name = name;
            this.level = level;
            this.message = message;
            this.t = t;
        }

        public String toString() {
            StringWriter buf = new StringWriter(32);
            buf.append(this.level.name());
            buf.append(' ');
            buf.append(this.name);
            buf.append(" - ");
            buf.append(this.message);
            if (this.t != null) {
                this.t.printStackTrace(new PrintWriter(buf));
            }
            return buf.toString();
        }

        void log(LoggerFactory factory) {
            Logger logger = factory.getLogger(this.bundle, this.name, Logger.class);
            switch (this.level) {
                case TRACE: {
                    logger.trace(this.message, (Object)this.t);
                    break;
                }
                case DEBUG: {
                    logger.debug(this.message, (Object)this.t);
                    break;
                }
                case INFO: {
                    logger.info(this.message, (Object)this.t);
                    break;
                }
                case WARN: {
                    logger.warn(this.message, (Object)this.t);
                    break;
                }
                case ERROR: {
                    logger.error(this.message, (Object)this.t);
                    break;
                }
                default: {
                    logger.audit(this.message, (Object)this.t);
                }
            }
        }
    }
}

