/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import org.osgi.framework.Bundle;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerConsumer;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.impl.LoggerFactoryTracker;
import org.slf4j.impl.SLF4JLoggerFactory;

class SLF4JLogger
extends MarkerIgnoringBase {
    private static final long serialVersionUID = 1L;
    private static final Class<StubLogger> stubClass = StubLogger.class;
    final transient Bundle bundle;
    final transient LoggerFactoryTracker tracker;
    private volatile transient Logger stub;

    SLF4JLogger(Bundle bundle, String name) {
        this.name = name;
        this.bundle = bundle;
        this.tracker = SLF4JLoggerFactory.getTracker();
    }

    private Logger getLogger() {
        Logger logger = this.tracker.getLogger(this.bundle, this.name);
        if (logger == null && (logger = this.stub) == null) {
            this.stub = logger = new StubLogger();
        }
        return logger;
    }

    public boolean isTraceEnabled() {
        Logger logger = this.getLogger();
        return logger.isTraceEnabled();
    }

    public void trace(String msg) {
        Logger logger = this.getLogger();
        logger.trace(msg);
    }

    public void trace(String msg, Throwable t) {
        Logger logger = this.getLogger();
        logger.trace(msg, (Object)t);
    }

    public void trace(String format, Object arg1) {
        Logger logger = this.getLogger();
        if (logger.isTraceEnabled()) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1);
            logger.trace(tp.getMessage(), (Object)tp.getThrowable());
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        Logger logger = this.getLogger();
        if (logger.isTraceEnabled()) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            logger.trace(tp.getMessage(), (Object)tp.getThrowable());
        }
    }

    public void trace(String format, Object ... argArray) {
        Logger logger = this.getLogger();
        if (logger.isTraceEnabled()) {
            FormattingTuple tp = MessageFormatter.arrayFormat((String)format, (Object[])argArray);
            logger.trace(tp.getMessage(), (Object)tp.getThrowable());
        }
    }

    public boolean isDebugEnabled() {
        Logger logger = this.getLogger();
        return logger.isDebugEnabled();
    }

    public void debug(String msg) {
        Logger logger = this.getLogger();
        logger.debug(msg);
    }

    public void debug(String msg, Throwable t) {
        Logger logger = this.getLogger();
        logger.debug(msg, (Object)t);
    }

    public void debug(String format, Object arg1) {
        Logger logger = this.getLogger();
        if (logger.isDebugEnabled()) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1);
            logger.debug(tp.getMessage(), (Object)tp.getThrowable());
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        Logger logger = this.getLogger();
        if (logger.isDebugEnabled()) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            logger.debug(tp.getMessage(), (Object)tp.getThrowable());
        }
    }

    public void debug(String format, Object ... argArray) {
        Logger logger = this.getLogger();
        if (logger.isDebugEnabled()) {
            FormattingTuple tp = MessageFormatter.arrayFormat((String)format, (Object[])argArray);
            logger.debug(tp.getMessage(), (Object)tp.getThrowable());
        }
    }

    public boolean isInfoEnabled() {
        Logger logger = this.getLogger();
        return logger.isInfoEnabled();
    }

    public void info(String msg) {
        Logger logger = this.getLogger();
        logger.info(msg);
    }

    public void info(String msg, Throwable t) {
        Logger logger = this.getLogger();
        logger.info(msg, (Object)t);
    }

    public void info(String format, Object arg1) {
        Logger logger = this.getLogger();
        if (logger.isInfoEnabled()) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1);
            logger.info(tp.getMessage(), (Object)tp.getThrowable());
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        Logger logger = this.getLogger();
        if (logger.isInfoEnabled()) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            logger.info(tp.getMessage(), (Object)tp.getThrowable());
        }
    }

    public void info(String format, Object ... argArray) {
        Logger logger = this.getLogger();
        if (logger.isInfoEnabled()) {
            FormattingTuple tp = MessageFormatter.arrayFormat((String)format, (Object[])argArray);
            logger.info(tp.getMessage(), (Object)tp.getThrowable());
        }
    }

    public boolean isWarnEnabled() {
        Logger logger = this.getLogger();
        return logger.isWarnEnabled();
    }

    public void warn(String msg) {
        Logger logger = this.getLogger();
        logger.warn(msg);
    }

    public void warn(String msg, Throwable t) {
        Logger logger = this.getLogger();
        logger.warn(msg, (Object)t);
    }

    public void warn(String format, Object arg1) {
        Logger logger = this.getLogger();
        if (logger.isWarnEnabled()) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1);
            logger.warn(tp.getMessage(), (Object)tp.getThrowable());
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        Logger logger = this.getLogger();
        if (logger.isWarnEnabled()) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            logger.warn(tp.getMessage(), (Object)tp.getThrowable());
        }
    }

    public void warn(String format, Object ... argArray) {
        Logger logger = this.getLogger();
        if (logger.isWarnEnabled()) {
            FormattingTuple tp = MessageFormatter.arrayFormat((String)format, (Object[])argArray);
            logger.warn(tp.getMessage(), (Object)tp.getThrowable());
        }
    }

    public boolean isErrorEnabled() {
        Logger logger = this.getLogger();
        return logger.isErrorEnabled();
    }

    public void error(String msg) {
        Logger logger = this.getLogger();
        logger.error(msg);
    }

    public void error(String msg, Throwable t) {
        Logger logger = this.getLogger();
        logger.error(msg, (Object)t);
    }

    public void error(String format, Object arg1) {
        Logger logger = this.getLogger();
        if (logger.isErrorEnabled()) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1);
            logger.error(tp.getMessage(), (Object)tp.getThrowable());
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        Logger logger = this.getLogger();
        if (logger.isErrorEnabled()) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            logger.error(tp.getMessage(), (Object)tp.getThrowable());
        }
    }

    public void error(String format, Object ... argArray) {
        Logger logger = this.getLogger();
        if (logger.isErrorEnabled()) {
            FormattingTuple tp = MessageFormatter.arrayFormat((String)format, (Object[])argArray);
            logger.error(tp.getMessage(), (Object)tp.getThrowable());
        }
    }

    class StubLogger
    implements Logger {
        private static final boolean TRACE_ENABLED = false;
        private static final boolean DEBUG_ENABLED = false;
        private static final boolean INFO_ENABLED = false;
        private static final boolean WARN_ENABLED = true;
        private static final boolean ERROR_ENABLED = true;

        StubLogger() {
        }

        public String getName() {
            return SLF4JLogger.this.getName();
        }

        public boolean isTraceEnabled() {
            return false;
        }

        public void trace(String msg) {
        }

        public void trace(String msg, Object t) {
        }

        public void trace(String format, Object arg1, Object arg2) {
        }

        public void trace(String format, Object ... arguments) {
        }

        public <E extends Exception> void trace(LoggerConsumer<E> consumer) throws E {
        }

        public boolean isDebugEnabled() {
            return false;
        }

        public void debug(String msg) {
        }

        public void debug(String msg, Object t) {
        }

        public void debug(String format, Object arg1, Object arg2) {
        }

        public void debug(String format, Object ... arguments) {
        }

        public <E extends Exception> void debug(LoggerConsumer<E> consumer) throws E {
        }

        public boolean isInfoEnabled() {
            return false;
        }

        public void info(String msg) {
        }

        public void info(String msg, Object t) {
        }

        public void info(String format, Object arg1, Object arg2) {
        }

        public void info(String format, Object ... arguments) {
        }

        public <E extends Exception> void info(LoggerConsumer<E> consumer) throws E {
        }

        public boolean isWarnEnabled() {
            return true;
        }

        public void warn(String msg) {
            SLF4JLogger.this.tracker.log(SLF4JLogger.this.bundle, this.getName(), LogLevel.WARN, msg, null);
        }

        public void warn(String msg, Object t) {
            SLF4JLogger.this.tracker.log(SLF4JLogger.this.bundle, this.getName(), LogLevel.WARN, msg, (Throwable)t);
        }

        public void warn(String format, Object arg1, Object arg2) {
            throw new UnsupportedOperationException();
        }

        public void warn(String format, Object ... arguments) {
            throw new UnsupportedOperationException();
        }

        public <E extends Exception> void warn(LoggerConsumer<E> consumer) throws E {
            throw new UnsupportedOperationException();
        }

        public boolean isErrorEnabled() {
            return true;
        }

        public void error(String msg) {
            SLF4JLogger.this.tracker.log(SLF4JLogger.this.bundle, this.getName(), LogLevel.ERROR, msg, null);
        }

        public void error(String msg, Object t) {
            SLF4JLogger.this.tracker.log(SLF4JLogger.this.bundle, this.getName(), LogLevel.ERROR, msg, (Throwable)t);
        }

        public void error(String format, Object arg1, Object arg2) {
            throw new UnsupportedOperationException();
        }

        public void error(String format, Object ... arguments) {
            throw new UnsupportedOperationException();
        }

        public <E extends Exception> void error(LoggerConsumer<E> consumer) throws E {
            throw new UnsupportedOperationException();
        }

        public void audit(String message) {
            throw new UnsupportedOperationException();
        }

        public void audit(String format, Object arg) {
            throw new UnsupportedOperationException();
        }

        public void audit(String format, Object arg1, Object arg2) {
            throw new UnsupportedOperationException();
        }

        public void audit(String format, Object ... arguments) {
            throw new UnsupportedOperationException();
        }
    }
}

