/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.xls;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.DocumentFactoryHelper;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.storage.ISObject;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.PropertySetter;
import org.osgl.util.S;
import org.osgl.xls.ExcelReadException;
import org.osgl.xls.HeaderTransformStrategy;
import org.osgl.xls.JavaBeanUtil;
import org.osgl.xls.MapSetter;
import org.osgl.xls.SheetSelector;
import osgl.version.Version;

public class ExcelReader {
    public static final Version VERSION = Version.of(ExcelReader.class);
    public static final Logger LOGGER = LogManager.get(ExcelReader.class);
    private final boolean isXlsx;
    private final Lang.Func0<InputStream> inputStreamProvider;
    private final Lang.Predicate<Sheet> sheetSelector;
    private final int headerRow;
    private final boolean ignoreEmptyRows;
    private final TolerantLevel tolerantLevel;
    private final Lang.Function<String, String> headerTransformer;
    private final Map<String, String> headerMapping;
    private final String terminator;

    private ExcelReader(Builder builder) {
        this.inputStreamProvider = (Lang.Func0)$.notNull((Object)builder.inputStreamProvider);
        this.sheetSelector = builder.sheetSelector;
        this.headerRow = builder.headerRow;
        this.ignoreEmptyRows = builder.ignoreEmptyRows;
        this.isXlsx = builder.isXlsx;
        this.tolerantLevel = builder.tolerantLevel;
        this.headerMapping = builder.headerMapping;
        this.headerTransformer = builder.headerTransformer;
        this.terminator = builder.terminator;
    }

    public List<Map<String, Object>> read() {
        return this.read(Map.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <TYPE> List<TYPE> read(Class<? extends TYPE> schema) {
        ArrayList dataList = new ArrayList();
        long now = $.ms();
        Workbook wb = this.loadWorkbook();
        long time = $.ms() - now;
        LOGGER.trace("it takes %sms to load the workbook", new Object[]{time});
        try {
            Map<String, PropertySetter> setterMap = this.processSchemaMapping(schema);
            if (setterMap.isEmpty() && this.tolerantLevel.isStrict()) {
                throw new ExcelReadException("No schema mapping found in strict mode");
            }
            this.read(wb, dataList, setterMap, schema);
        }
        finally {
            IO.close((Closeable)wb);
        }
        return dataList;
    }

    private <TYPE> Map<String, PropertySetter> processSchemaMapping(Class<? extends TYPE> schema) {
        boolean schemaIsPojo;
        HashMap<String, PropertySetter> schemaMapping = new HashMap<String, PropertySetter>();
        boolean bl = schemaIsPojo = !Map.class.isAssignableFrom(schema);
        if (schemaIsPojo) {
            Map<String, PropertySetter> pojoSetters = JavaBeanUtil.setters(schema, this.headerMapping);
            schemaMapping.putAll(pojoSetters);
            for (Map.Entry<String, String> entry : this.headerMapping.entrySet()) {
                String header = entry.getKey().trim().toLowerCase();
                String field = entry.getValue();
                PropertySetter setter = pojoSetters.get(field);
                if (null != setter) {
                    schemaMapping.put(header, setter);
                    continue;
                }
                if (!this.tolerantLevel.isTolerant() || null == (setter = pojoSetters.get(field = (String)this.headerTransformer.apply((Object)header)))) continue;
                schemaMapping.put(header, setter);
            }
        } else {
            for (Map.Entry<String, String> entry : this.headerMapping.entrySet()) {
                schemaMapping.put(entry.getKey(), new MapSetter(entry.getValue()));
            }
        }
        return schemaMapping;
    }

    private <TYPE> void read(Workbook workbook, List<TYPE> dataList, Map<String, PropertySetter> setterMap, Class<? extends TYPE> schema) {
        for (Sheet sheet : workbook) {
            if (!this.sheetSelector.test((Object)sheet)) continue;
            this.read(sheet, dataList, setterMap, schema);
        }
    }

    private <TYPE> void read(Sheet sheet, List<TYPE> dataList, Map<String, PropertySetter> setterMap, Class<? extends TYPE> schema) {
        Lang.Var headerRowHolder = $.var((Object)this.headerRow);
        boolean schemaIsMap = Map.class.isAssignableFrom(schema);
        Map<Integer, PropertySetter> columnIndex = this.buildColumnIndex(sheet, setterMap, schemaIsMap, (Lang.Var<Integer>)headerRowHolder);
        if (columnIndex.size() < setterMap.size()) {
            this.tolerantLevel.columnIndexMapNotFullyBuilt(sheet);
        }
        if (columnIndex.isEmpty()) {
            return;
        }
        int startRow = (Integer)headerRowHolder.get() + 1;
        int maxRow = sheet.getLastRowNum() + 1;
        block6: for (int rowId = startRow; rowId < maxRow; ++rowId) {
            Object entity = schemaIsMap ? new LinkedHashMap() : $.newInstance(schema);
            Row row = sheet.getRow(rowId);
            boolean isEmptyRow = true;
            for (Map.Entry<Integer, PropertySetter> entry : columnIndex.entrySet()) {
                try {
                    Cell cell = row.getCell(entry.getKey().intValue());
                    if (null == cell) continue;
                    try {
                        Object value = this.readCellValue(cell);
                        if (null == value) continue;
                        if (null != this.terminator && this.terminator.equals(value)) break block6;
                        isEmptyRow = false;
                        try {
                            entry.getValue().set(entity, value, null);
                        }
                        catch (Exception e) {
                            this.tolerantLevel.errorSettingCellValueToPojo(e, cell, value, schema);
                        }
                    }
                    catch (Exception e) {
                        this.tolerantLevel.onReadCellException(e, cell);
                    }
                }
                catch (Exception e) {
                    this.tolerantLevel.onReadCellException(e, sheet, row, entry.getKey());
                }
            }
            if (isEmptyRow && this.ignoreEmptyRows) continue;
            Object data = $.cast((Object)entity);
            dataList.add(data);
        }
    }

    private Object readCellValue(Cell cell) {
        return this.readCellValue(cell, cell.getCellTypeEnum());
    }

    private Object readCellValue(Cell cell, CellType type) {
        switch (type) {
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue();
                }
                double n = cell.getNumericCellValue();
                CellStyle style = cell.getCellStyle();
                String format = style.getDataFormatString();
                if (format.indexOf(46) < 0) {
                    return (long)n;
                }
                return n;
            }
            case FORMULA: {
                return this.readCellValue(cell, cell.getCachedFormulaResultTypeEnum());
            }
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
            case ERROR: {
                return this.tolerantLevel.readErrorCell(cell);
            }
            case BLANK: {
                return null;
            }
            case STRING: {
                return cell.getStringCellValue();
            }
        }
        return this.tolerantLevel.readUnknownCellType(cell);
    }

    private Map<Integer, PropertySetter> buildColumnIndex(Sheet sheet, Map<String, PropertySetter> setterMap, boolean schemaIsMap, Lang.Var<Integer> headerRowHolder) {
        int startRow = sheet.getFirstRowNum();
        int maxRow = sheet.getLastRowNum();
        int headerRow = this.headerRow;
        if (headerRow < startRow || headerRow >= maxRow) {
            this.tolerantLevel.headerRowOutOfScope(sheet);
            headerRow = startRow;
        }
        if (this.tolerantLevel.isStrict()) {
            return this.buildColumnIndex(sheet.getRow(headerRow), setterMap, schemaIsMap);
        }
        Object index = C.map((Object[])new Object[0]);
        for (int rowId = headerRow; rowId < maxRow; ++rowId) {
            index = this.buildColumnIndex(sheet.getRow(rowId), setterMap, schemaIsMap);
            if (index.isEmpty()) continue;
            headerRowHolder.set((Object)rowId);
            return index;
        }
        return index;
    }

    private Map<Integer, PropertySetter> buildColumnIndex(Row row, Map<String, PropertySetter> setterMap, boolean schemaIsMap) {
        HashMap<Integer, PropertySetter> retVal = new HashMap<Integer, PropertySetter>();
        for (Cell cell : row) {
            try {
                String header = cell.getStringCellValue();
                if (S.blank((String)header)) continue;
                header = header.trim();
                PropertySetter setter = null;
                String translated = this.headerMapping.get(header.toLowerCase());
                if (null != translated) {
                    setter = setterMap.get(translated);
                }
                if (null == setter) {
                    String key = (String)this.headerTransformer.apply((Object)header);
                    setter = setterMap.get(key);
                }
                if (null != setter) {
                    retVal.put(cell.getColumnIndex(), setter);
                    continue;
                }
                if (!this.tolerantLevel.isAggressiveReading() || !schemaIsMap) continue;
                retVal.put(cell.getColumnIndex(), new MapSetter((String)this.headerTransformer.apply((Object)header)));
            }
            catch (Exception e) {
                LOGGER.debug((Throwable)e, "error reading cell value:" + cell);
            }
        }
        return retVal;
    }

    private Workbook loadWorkbook() {
        InputStream is = (InputStream)this.inputStreamProvider.apply();
        try {
            return this.isXlsx ? new XSSFWorkbook(is) : new HSSFWorkbook(is);
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
    }

    public static List<Map<String, Object>> read(File file) {
        return ExcelReader.builder().file(file).build().read();
    }

    public static List<Map<String, Object>> read(File file, Map<String, String> headerMapping) {
        return ExcelReader.builder().file(file).headerMapping(headerMapping).build().read();
    }

    public static <T> List<T> read(File file, Class<T> schema) {
        return ExcelReader.builder().file(file).build().read(schema);
    }

    public static <T> List<T> read(File file, Class<T> schema, Map<String, String> headerMapping) {
        return ExcelReader.builder().file(file).headerMapping(headerMapping).build().read(schema);
    }

    public static List<Map<String, Object>> read(URL url) {
        return ExcelReader.builder().url(url).build().read();
    }

    public static List<Map<String, Object>> read(URL url, Map<String, String> headerMapping) {
        return ExcelReader.builder().url(url).headerMapping(headerMapping).build().read();
    }

    public static <T> List<T> read(URL url, Class<T> schema) {
        return ExcelReader.builder().url(url).build().read(schema);
    }

    public static <T> List<T> read(URL url, Class<T> schema, Map<String, String> headerMapping) {
        return ExcelReader.builder().url(url).headerMapping(headerMapping).build().read(schema);
    }

    public static List<Map<String, Object>> read(InputStream inputStream) {
        return ExcelReader.builder().inputStream(inputStream).build().read();
    }

    public static List<Map<String, Object>> read(InputStream inputStream, Map<String, String> headerMapping) {
        return ExcelReader.builder().inputStream(inputStream).headerMapping(headerMapping).build().read();
    }

    public static <T> List<T> read(InputStream inputStream, Class<T> schema) {
        return ExcelReader.builder().inputStream(inputStream).build().read(schema);
    }

    public static <T> List<T> read(InputStream inputStream, Class<T> schema, Map<String, String> headerMapping) {
        return ExcelReader.builder().inputStream(inputStream).headerMapping(headerMapping).build().read(schema);
    }

    public static List<Map<String, Object>> read(ISObject sobj) {
        return ExcelReader.builder().sobject(sobj).build().read();
    }

    public static List<Map<String, Object>> read(ISObject sobj, Map<String, String> headerMapping) {
        return ExcelReader.builder().sobject(sobj).headerMapping(headerMapping).build().read();
    }

    public static <T> List<T> read(ISObject sobj, Class<T> schema) {
        return ExcelReader.builder().sobject(sobj).build().read(schema);
    }

    public static <T> List<T> read(ISObject sobj, Class<T> schema, Map<String, String> headerMapping) {
        return ExcelReader.builder().sobject(sobj).headerMapping(headerMapping).build().read(schema);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Map headerMapping) {
        return new Builder().headerMapping(headerMapping);
    }

    public static Builder builder(TolerantLevel tolerantLevel) {
        return new Builder(tolerantLevel);
    }

    public static Builder builder(Lang.Function<String, String> captionToSchemaTransformer) {
        return new Builder(captionToSchemaTransformer);
    }

    public static Builder builder(Lang.Function<String, String> captionToSchemaTransformer, TolerantLevel tolerantLevel) {
        return new Builder(captionToSchemaTransformer, tolerantLevel);
    }

    private static PushbackInputStream pushbackInputStream(InputStream is) {
        return new PushbackInputStream(is, 100);
    }

    public static class Builder {
        private Lang.Func0<InputStream> inputStreamProvider;
        private Lang.Predicate<Sheet> sheetSelector = SheetSelector.ALL;
        private Map<String, String> headerMapping = new HashMap<String, String>();
        private boolean isXlsx = false;
        private int headerRow = 0;
        private boolean ignoreEmptyRows = true;
        private Lang.Function<String, String> headerTransformer = HeaderTransformStrategy.TO_JAVA_NAME;
        private TolerantLevel tolerantLevel = TolerantLevel.AGGRESSIVE_READ;
        private String terminator;

        public Builder() {
        }

        public Builder(TolerantLevel tolerantLevel) {
            this.tolerantLevel = (TolerantLevel)((Object)$.notNull((Object)((Object)tolerantLevel)));
        }

        public Builder(Lang.Function<String, String> headerTransformer) {
            this.headerTransformer = (Lang.Function)$.notNull(headerTransformer);
        }

        public Builder(Lang.Function<String, String> headerTransformer, TolerantLevel tolerantLevel) {
            this.headerTransformer = (Lang.Function)$.notNull(headerTransformer);
            this.tolerantLevel = (TolerantLevel)((Object)$.notNull((Object)((Object)tolerantLevel)));
        }

        public Builder resource(String path) {
            URL url = ExcelReader.class.getResource(path);
            if (null == url) {
                path = path.startsWith("/") ? path.substring(1) : "/" + path;
                url = ExcelReader.class.getResource(path);
                throw E.ioException((String)("Resource not found: " + path), (Object[])new Object[0]);
            }
            return this.url(url);
        }

        public Builder url(final URL url) {
            Boolean isXlsx = null;
            String path = url.getPath();
            if (path.endsWith(".xlsx")) {
                isXlsx = true;
            } else if (path.endsWith(".xls")) {
                isXlsx = false;
            }
            if (null == isXlsx) {
                return this.inputStream(ExcelReader.pushbackInputStream(IO.is((URL)url)));
            }
            this.isXlsx = isXlsx;
            this.inputStreamProvider = new Lang.F0<InputStream>(){

                public InputStream apply() throws NotAppliedException, Lang.Break {
                    return new BufferedInputStream(IO.is((URL)url));
                }
            };
            return this;
        }

        public Builder file(final String path) {
            Boolean isXlsx = null;
            if (path.endsWith(".xlsx")) {
                isXlsx = true;
            } else if (path.endsWith(".xls")) {
                isXlsx = false;
            }
            if (null == isXlsx) {
                return this.inputStream(ExcelReader.pushbackInputStream(IO.is((File)new File(path))));
            }
            this.isXlsx = isXlsx;
            this.inputStreamProvider = new Lang.F0<InputStream>(){

                public InputStream apply() throws NotAppliedException, Lang.Break {
                    return new BufferedInputStream(IO.is((File)new File(path)));
                }
            };
            return this;
        }

        public Builder file(final File file) {
            Boolean isXlsx = null;
            String path = file.getPath();
            if (path.endsWith(".xlsx")) {
                isXlsx = true;
            } else if (path.endsWith(".xls")) {
                isXlsx = false;
            }
            if (null == isXlsx) {
                return this.inputStream(ExcelReader.pushbackInputStream(IO.is((File)file)));
            }
            this.isXlsx = isXlsx;
            this.inputStreamProvider = new Lang.F0<InputStream>(){

                public InputStream apply() throws NotAppliedException, Lang.Break {
                    return new BufferedInputStream(IO.is((File)file));
                }
            };
            return this;
        }

        public Builder sobject(ISObject sobj) {
            Boolean isXlsx = null;
            String s = sobj.getAttribute("filename");
            if (S.notBlank((String)s)) {
                if (s.endsWith(".xlsx")) {
                    isXlsx = true;
                } else if (s.endsWith(".xls")) {
                    isXlsx = false;
                }
            }
            if (null == isXlsx) {
                s = sobj.getAttribute("content-type");
                if (S.notBlank((String)s)) {
                    if (s.startsWith("application/vnd.openxmlformats-officedocument.spreadsheetml")) {
                        isXlsx = true;
                    } else if ("application/vnd.ms-excel".equals(s)) {
                        isXlsx = false;
                    }
                }
                if (null == isXlsx) {
                    return this.inputStream(ExcelReader.pushbackInputStream(sobj.asInputStream()));
                }
            }
            this.isXlsx = isXlsx;
            return this.sobject(sobj, isXlsx);
        }

        public Builder sobject(final ISObject sobj, boolean isXlsx) {
            this.isXlsx = isXlsx;
            this.inputStreamProvider = new Lang.F0<InputStream>(){

                public InputStream apply() throws NotAppliedException, Lang.Break {
                    return sobj.asInputStream();
                }
            };
            return this;
        }

        public Builder classResource(String url) {
            Boolean xlsx = null;
            if (url.endsWith(".xlsx")) {
                xlsx = true;
            } else if (url.endsWith(".xls")) {
                xlsx = false;
            }
            if (null == xlsx) {
                return this.inputStream(IO.is((URL)ExcelReader.class.getResource(url)));
            }
            return this.classResource(url, xlsx);
        }

        public Builder classResource(final String url, boolean isXlsx) {
            this.isXlsx = isXlsx;
            this.inputStreamProvider = new Lang.F0<InputStream>(){

                public InputStream apply() throws NotAppliedException, Lang.Break {
                    return IO.is((URL)ExcelReader.class.getResource(url));
                }
            };
            return this;
        }

        public Builder inputStream(InputStream is) {
            PushbackInputStream probeStream = ExcelReader.pushbackInputStream(is);
            try {
                return this.inputStream(probeStream, DocumentFactoryHelper.hasOOXMLHeader((InputStream)probeStream));
            }
            catch (IOException e) {
                throw E.ioException((IOException)e);
            }
        }

        public Builder inputStream(final InputStream is, boolean isXlsx) {
            this.isXlsx = isXlsx;
            this.inputStreamProvider = new Lang.F0<InputStream>(){

                public InputStream apply() throws NotAppliedException, Lang.Break {
                    return is;
                }
            };
            return this;
        }

        public Builder terminator(String terminator) {
            this.terminator = terminator;
            return this;
        }

        public Builder sheetSelector(Lang.Predicate<Sheet> sheetPredicate) {
            this.sheetSelector = (Lang.Predicate)$.notNull(sheetPredicate);
            return this;
        }

        public Builder sheets(String ... names) {
            return this.sheetSelector(SheetSelector.byName(names));
        }

        public Builder excludeSheets(String ... names) {
            return this.sheetSelector(SheetSelector.excludeByName(names));
        }

        public Builder sheets(int ... indexes) {
            return this.sheetSelector(SheetSelector.byPosition(indexes));
        }

        public Builder excludeSheets(int ... indexes) {
            return this.sheetSelector(SheetSelector.excludeByPosition(indexes));
        }

        public Builder headerRow(int rowIndex) {
            E.illegalArgumentIf((rowIndex < 0 ? 1 : 0) != 0, (String)"start row must not be negative");
            this.headerRow = rowIndex;
            return this;
        }

        public Builder ignoreEmptyRows() {
            this.ignoreEmptyRows = true;
            return this;
        }

        public Builder ignoreEmptyRows(boolean ignore) {
            this.ignoreEmptyRows = ignore;
            return this;
        }

        public Builder readEmptyRows() {
            this.ignoreEmptyRows = false;
            return this;
        }

        public HeaderMapper map(String header) {
            return new HeaderMapper(header);
        }

        public Builder headerMapping(Map mapping) {
            E.illegalArgumentIf((boolean)mapping.isEmpty(), (String)"empty header mapping found");
            this.headerMapping = (Map)$.cast((Object)$.notNull((Object)mapping));
            return this;
        }

        public Builder readColumns(String ... headers) {
            return this.readColumns((Collection<String>)C.listOf((Object[])headers));
        }

        public Builder readColumns(Collection<String> headers) {
            E.illegalArgumentIf((boolean)headers.isEmpty(), (String)"empty read column caption collection found");
            this.headerMapping = new HashMap<String, String>();
            for (String header : headers) {
                this.headerMapping.put(header, (String)this.headerTransformer.apply((Object)header));
            }
            this.tolerantLevel = TolerantLevel.TOLERANT;
            return this;
        }

        public ExcelReader build() {
            return new ExcelReader(this);
        }

        public class HeaderMapper {
            private String caption;

            private HeaderMapper(String caption) {
                E.illegalArgumentIf((boolean)S.blank((String)caption), (String)"caption cannot be null or blank");
                this.caption = caption.trim().toLowerCase();
            }

            public Builder to(String property) {
                E.illegalArgumentIf((boolean)S.blank((String)property), (String)"property cannot be null or blank");
                Builder builder = Builder.this;
                builder.headerMapping.put(this.caption, property);
                return builder;
            }
        }
    }

    public static enum TolerantLevel {
        STRICT,
        TOLERANT,
        AGGRESSIVE_READ;


        public boolean isStrict() {
            return STRICT == this;
        }

        public boolean isTolerant() {
            return TOLERANT != this;
        }

        public boolean isAggressiveReading() {
            return AGGRESSIVE_READ == this;
        }

        public void headerRowOutOfScope(Sheet sheet) {
            String message = S.fmt((String)"caption row out of scope in sheet[%s] !", (Object[])new Object[]{sheet.getSheetName()});
            if (this.isStrict()) {
                throw new ExcelReadException(message);
            }
            LOGGER.warn(message + " will probe for caption row");
        }

        public void columnIndexMapNotFullyBuilt(Sheet sheet) {
            String message = S.fmt((String)("column index not fully built on sheet: " + sheet.getSheetName()));
            if (this.isStrict()) {
                throw new ExcelReadException(message);
            }
            LOGGER.warn(message);
        }

        public void onReadCellException(Exception e, Sheet sheet, Row row, int cellIndex) {
            String errorMessage = S.fmt((String)"Error reading cell value: %s-%s@[%s]", (Object[])new Object[]{cellIndex, row.getRowNum(), sheet.getSheetName()});
            if (this.isStrict()) {
                throw new ExcelReadException(e, errorMessage, new Object[0]);
            }
            LOGGER.warn((Throwable)e, errorMessage);
        }

        public void onReadCellException(Exception e, Cell cell) {
            String errorMessage = S.fmt((String)"Error reading cell value: %s@[%s]", (Object[])new Object[]{cell.getAddress(), cell.getSheet().getSheetName()});
            if (this.isStrict()) {
                throw new ExcelReadException(e, errorMessage, new Object[0]);
            }
            LOGGER.warn((Throwable)e, errorMessage);
        }

        public Object readErrorCell(Cell cell) {
            if (this.isStrict()) {
                throw new ExcelReadException("Error cell value encountered: %s@[%s]", cell.getAddress(), cell.getRow().getSheet().getSheetName());
            }
            return null;
        }

        public Object readUnknownCellType(Cell cell) {
            if (this.isStrict()) {
                throw new ExcelReadException("Unknown cell type encountered: %s@[%s]", cell.getAddress(), cell.getRow().getSheet().getSheetName());
            }
            return null;
        }

        public void errorSettingCellValueToPojo(Exception e, Cell cell, Object value, Class<?> schema) {
            String errorMessage = S.fmt((String)"failed to set cell value[%s] to POJO[%s]: %s@[%s]", (Object[])new Object[]{value, schema, cell.getAddress(), cell.getRow().getSheet().getSheetName()});
            if (this.isStrict()) {
                throw new ExcelReadException(e, errorMessage, new Object[0]);
            }
            LOGGER.warn((Throwable)e, errorMessage);
        }
    }
}

