/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.xls;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.C;
import org.osgl.util.PropertySetter;
import org.osgl.util.S;

class JavaBeanUtil {
    private JavaBeanUtil() {
    }

    static Map<String, PropertySetter> setters(Class<?> schema, Map<String, String> headerMapping) {
        HashMap<String, PropertySetter> setterMap = new HashMap<String, PropertySetter>();
        JavaBeanUtil.loadSettersFromSetterMethod(schema, setterMap);
        JavaBeanUtil.loadSettersFromFields(schema, setterMap);
        JavaBeanUtil.processNestedSetters(schema, headerMapping, setterMap);
        return setterMap;
    }

    private static void processNestedSetters(Class<?> schema, Map<String, String> headerMapping, Map<String, PropertySetter> setterMap) {
        C.Set nestedProperties = C.newSet();
        for (final String prop : headerMapping.values()) {
            if (!prop.contains(".")) continue;
            nestedProperties.add(prop);
        }
        if (nestedProperties.isEmpty()) {
            return;
        }
        for (final String prop : nestedProperties) {
            PropertySetter setter = new PropertySetter(){

                public void set(Object entity, Object value, Object index) {
                    $.setProperty((Object)entity, (Object)value, (String)prop);
                }

                public void setObjectFactory(Lang.Function<Class<?>, Object> factory) {
                }

                public void setStringValueResolver(Lang.Func2<String, Class<?>, ?> stringValueResolver) {
                }
            };
            setterMap.put(prop, setter);
        }
    }

    private static void loadSettersFromSetterMethod(Class<?> schema, Map<String, PropertySetter> map) {
        Method[] methods;
        for (Method method : methods = schema.getMethods()) {
            char c;
            String property;
            String name = method.getName();
            if (!name.startsWith("set") || Void.class.equals(method.getReturnType()) || (property = name.substring(3)).length() < 1 || (c = property.charAt(0)) > 'Z' || c < 'A') continue;
            String propertyName = S.lowerFirst((String)property);
            map.put(propertyName, $.propertyHandlerFactory.createPropertySetter(schema, propertyName));
        }
    }

    private static void loadSettersFromFields(Class<?> schema, Map<String, PropertySetter> map) {
        Field[] fields;
        for (Field field : fields = schema.getDeclaredFields()) {
            int modifier = field.getModifiers();
            if (!Modifier.isPublic(modifier) || Modifier.isStatic(modifier) || Modifier.isTransient(modifier)) continue;
            String propertyName = field.getName();
            map.put(propertyName, $.propertyHandlerFactory.createPropertySetter(schema, propertyName));
        }
    }
}

