/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.xls;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.poi.ss.usermodel.Sheet;
import org.osgl.Lang;
import org.osgl.util.E;
import org.osgl.util.S;

public class SheetSelector {
    public static Lang.Predicate<Sheet> ALL = new Lang.Predicate<Sheet>(){

        public boolean test(Sheet rows) {
            return true;
        }
    };

    public static Lang.Predicate<Sheet> byName(String ... names) {
        E.illegalArgumentIf((names.length == 0 ? 1 : 0) != 0, (String)"name list expected");
        final HashSet nameList = new HashSet();
        for (String s : names) {
            if (S.blank((String)s)) continue;
            s = s.trim().toLowerCase();
            S.List splited = S.fastSplit((String)s, (String)",");
            nameList.addAll(splited);
        }
        return new Lang.Predicate<Sheet>(){

            public boolean test(Sheet sheet) {
                return nameList.contains(sheet.getSheetName().toLowerCase());
            }
        };
    }

    public static Lang.Predicate<Sheet> excludeByName(String ... names) {
        return SheetSelector.byName(names).negate();
    }

    public static Lang.Predicate<Sheet> byPosition(final int ... indexes) {
        E.illegalArgumentIf((indexes.length == 0 ? 1 : 0) != 0, (String)"index list expected");
        Arrays.sort(indexes);
        return new Lang.Predicate<Sheet>(){

            public boolean test(Sheet sheet) {
                int myIndex = sheet.getWorkbook().getSheetIndex(sheet);
                return Arrays.binarySearch(indexes, myIndex) > -1;
            }
        };
    }

    public static Lang.Predicate<Sheet> excludeByPosition(int ... indexes) {
        return SheetSelector.byPosition(indexes).negate();
    }
}

