/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.inject;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.inject.Provider;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.inject.BeanSpec;
import org.osgl.inject.ElementFilter;
import org.osgl.inject.ElementLoader;
import org.osgl.inject.Genie;
import org.osgl.inject.KeyExtractor;
import org.osgl.inject.annotation.Filter;
import org.osgl.inject.annotation.LoadCollection;
import org.osgl.inject.annotation.MapKey;
import org.osgl.util.C;

abstract class ElementLoaderProvider<T>
implements Provider<T> {
    private final Provider<T> realProvider;
    private final LoaderInfo loader;
    private final Set<FilterInfo> filters;
    private final Genie genie;

    private ElementLoaderProvider(BeanSpec spec, Provider<T> provider, Genie genie) {
        this.realProvider = provider;
        C.List loaders = ElementLoaderProvider.loaders(genie, spec).sorted();
        this.loader = (LoaderInfo)loaders.first();
        C.List tail = loaders.head(-1);
        this.filters = C.set((Collection)ElementLoaderProvider.filters(genie, spec).append((Collection)tail));
        this.genie = genie;
    }

    public final T get() {
        Object bean = this.realProvider.get();
        Lang.Predicate predicate = Lang.F.and((Lang.Function[])((Lang.Function[])this.filters.toArray(new FilterInfo[this.filters.size()])));
        for (Object element : this.loader.load(this.genie)) {
            if (!predicate.test(element)) continue;
            this.populate(bean, element);
        }
        return (T)bean;
    }

    protected abstract void populate(T var1, Object var2);

    static <T> Provider<T> decorate(BeanSpec spec, Provider<T> provider, Genie genie) {
        if (!spec.hasElementLoader()) {
            return provider;
        }
        if (provider instanceof ElementLoaderProvider) {
            return (Provider)$.cast(provider);
        }
        if (spec.isMap()) {
            return new MapLoaderProvider<T>(spec, provider, genie);
        }
        return new CollectionLoaderProvider<T>(spec, provider, genie);
    }

    private static C.List<LoaderInfo> loaders(Genie genie, BeanSpec spec) {
        C.List list = C.newList();
        Set<Annotation> loaders = spec.loaders();
        for (Annotation anno : loaders) {
            Class<? extends Annotation> annoClass = anno.annotationType();
            LoadCollection loaderTag = LoadCollection.class == annoClass ? (LoadCollection)anno : annoClass.getAnnotation(LoadCollection.class);
            ElementLoader loader = genie.get(loaderTag.value());
            list.add((Object)new LoaderInfo(loader, loaderTag.reverseFilter(), anno, spec));
        }
        return list;
    }

    private static C.List<FilterInfo> filters(Genie genie, BeanSpec spec) {
        C.List list = C.newList();
        Set<Annotation> annotations = spec.filters();
        for (Annotation anno : annotations) {
            Class<? extends Annotation> annoClass = anno.annotationType();
            Filter filterTag = Filter.class == annoClass ? (Filter)anno : annoClass.getAnnotation(Filter.class);
            ElementFilter loader = genie.get(filterTag.value());
            list.add((Object)new FilterInfo(loader, filterTag.reverse(), anno, spec));
        }
        return list;
    }

    private static class MapLoaderProvider<T extends Map>
    extends ElementLoaderProvider<T> {
        String hint;
        KeyExtractor keyExtractor;

        MapLoaderProvider(BeanSpec spec, Provider<T> provider, Genie genie) {
            super(spec, provider, genie);
            MapKey mapKey = spec.mapKey();
            this.keyExtractor = genie.get(mapKey.extractor());
            this.hint = mapKey.value();
        }

        @Override
        protected void populate(T bean, Object element) {
            bean.put(this.keyExtractor.keyOf(this.hint, element), (Object)element);
        }
    }

    private static class CollectionLoaderProvider<T extends Collection>
    extends ElementLoaderProvider<T> {
        CollectionLoaderProvider(BeanSpec spec, Provider<T> provider, Genie genie) {
            super(spec, provider, genie);
        }

        @Override
        protected void populate(T bean, Object element) {
            bean.add((Object)element);
        }
    }

    private static class LoaderInfo
    extends FilterInfo
    implements Comparable<LoaderInfo> {
        LoaderInfo(ElementLoader loader, boolean reverse, Annotation anno, BeanSpec container) {
            super(loader, reverse, anno, container);
        }

        ElementLoader loader() {
            return (ElementLoader)this.filter;
        }

        @Override
        public int compareTo(LoaderInfo o) {
            return this.loader().priority() - o.loader().priority();
        }

        Iterable load(Genie genie) {
            return this.loader().load(this.options, this.containerSpec, genie);
        }
    }

    private static class FilterInfo
    extends Lang.Predicate {
        final ElementFilter filter;
        final Map<String, Object> options;
        final Lang.Function<Object, Boolean> predicate;
        final BeanSpec containerSpec;

        FilterInfo(ElementFilter filter, boolean reverse, Annotation anno, BeanSpec container) {
            this.filter = filter;
            this.options = $.evaluate((Annotation)anno);
            Lang.Predicate filterFunction = filter.filter(this.options, container);
            this.predicate = reverse ? Lang.F.negate(filterFunction) : filterFunction;
            this.containerSpec = container;
        }

        public boolean test(Object bean) {
            return (Boolean)this.predicate.apply(bean);
        }
    }
}

