/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.inject;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.inject.Genie;
import org.osgl.inject.InjectException;
import org.osgl.inject.Injector;
import org.osgl.inject.annotation.Filter;
import org.osgl.inject.annotation.InjectTag;
import org.osgl.inject.annotation.LoadCollection;
import org.osgl.inject.annotation.LoadValue;
import org.osgl.inject.annotation.MapKey;
import org.osgl.inject.annotation.Provides;
import org.osgl.inject.annotation.Transform;
import org.osgl.inject.annotation.TypeOf;
import org.osgl.inject.util.AnnotationUtil;
import org.osgl.inject.util.ParameterizedTypeImpl;
import org.osgl.util.AnnotationAware;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public class BeanSpec
implements AnnotationAware {
    private final Injector injector;
    private final int hc;
    private final Type type;
    private volatile transient Class<?> rawType;
    private Field field;
    private final boolean isArray;
    private final Set<Annotation> elementLoaders = new HashSet<Annotation>();
    private final Set<Annotation> filters = new HashSet<Annotation>();
    private final Set<Annotation> transformers = new HashSet<Annotation>();
    private final Set<Annotation> qualifiers = new HashSet<Annotation>();
    private final Set<Annotation> postProcessors = new HashSet<Annotation>();
    private final int modifiers;
    private final Map<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
    private final Map<Class<? extends Annotation>, Annotation> allAnnotations = new HashMap<Class<? extends Annotation>, Annotation>();
    private final Map<Class<? extends Annotation>, Set<Annotation>> tagAnnotations = new HashMap<Class<? extends Annotation>, Set<Annotation>>();
    private final Set<AnnoData> annoData = new HashSet<AnnoData>();
    private final Set<AnnoData> injectTags = new HashSet<AnnoData>();
    private String originalName;
    private String name;
    private MapKey mapKey;
    private Class<? extends Annotation> scope;
    private BeanSpec componentSpec;
    private volatile boolean componentSpecSet;
    private boolean stopInheritedScope;
    private Annotation valueLoader;
    private List<Type> typeParams;
    private volatile Map<String, BeanSpec> fields;
    private static Set<Class<? extends Annotation>> WAIVE_TAG_TYPES = C.set(Documented.class, (Object[])new Class[]{Retention.class, Target.class, Inherited.class});
    private static Lang.Predicate<Field> NON_STATIC_FIELD = new Lang.Predicate<Field>(){

        public boolean test(Field field) {
            return !Modifier.isStatic(field.getModifiers());
        }
    };

    private BeanSpec(Type type, Annotation[] annotations, String name, Injector injector, int modifiers) {
        this.injector = injector;
        this.type = type;
        this.originalName = name;
        this.name = name;
        Class rawType = this.rawType();
        this.isArray = rawType.isArray();
        this.resolveTypeAnnotations(injector);
        this.resolveAnnotations(annotations, injector);
        this.hc = this.calcHashCode();
        this.modifiers = modifiers;
    }

    private BeanSpec(BeanSpec source, Type convertTo) {
        this.originalName = source.name;
        this.name = source.name;
        this.injector = source.injector;
        this.type = convertTo;
        this.isArray = this.rawType().isArray();
        this.qualifiers.addAll(source.qualifiers);
        this.elementLoaders.addAll(source.elementLoaders);
        this.filters.addAll(source.filters);
        this.transformers.addAll(source.transformers);
        this.valueLoader = source.valueLoader;
        this.annotations.putAll(source.annotations);
        this.annoData.addAll(source.annoData);
        this.allAnnotations.putAll(source.allAnnotations);
        this.tagAnnotations.putAll(source.tagAnnotations);
        this.hc = this.calcHashCode();
        this.modifiers = source.modifiers;
    }

    private BeanSpec(BeanSpec source, String name) {
        this.originalName = source.name;
        this.name = name;
        this.injector = source.injector;
        this.type = source.type;
        this.isArray = this.rawType().isArray();
        this.qualifiers.addAll(source.qualifiers);
        this.elementLoaders.addAll(source.elementLoaders);
        this.filters.addAll(source.filters);
        this.transformers.addAll(source.transformers);
        this.valueLoader = source.valueLoader;
        this.annotations.putAll(source.annotations);
        this.annoData.addAll(source.annoData);
        this.allAnnotations.putAll(source.allAnnotations);
        this.tagAnnotations.putAll(source.tagAnnotations);
        this.hc = this.calcHashCode();
        this.modifiers = source.modifiers;
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BeanSpec) {
            BeanSpec that = (BeanSpec)obj;
            return that.hc == this.hc && $.eq((Object)this.type, (Object)that.type) && $.eq((Object)this.name, (Object)that.name) && $.eq(this.annoData, that.annoData);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = S.builder((Object)this.type());
        if (S.notBlank((String)this.name)) {
            sb.append("(").append(this.name).append(")");
        }
        C.List list = C.newList();
        if (null != this.valueLoader) {
            list.append((Object)this.valueLoader);
        } else {
            list.append(this.qualifiers).append(this.elementLoaders).append(this.filters);
            if (null != this.mapKey) {
                list.append((Object)this.mapKey);
            }
        }
        if (null != this.scope) {
            list.append((Object)this.scope.getSimpleName());
        }
        if (!list.isEmpty()) {
            sb.append("@[").append(S.join((String)", ", (Iterable)list)).append("]");
        }
        return sb.toString();
    }

    public Injector injector() {
        return this.injector;
    }

    public Type type() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class rawType() {
        if (null == this.rawType) {
            BeanSpec beanSpec = this;
            synchronized (beanSpec) {
                if (null == this.rawType) {
                    this.rawType = BeanSpec.rawTypeOf(this.type);
                }
            }
        }
        return this.rawType;
    }

    public String name() {
        return this.name;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public Annotation[] allAnnotations() {
        return this.allAnnotations.values().toArray(new Annotation[this.allAnnotations.size()]);
    }

    public Annotation[] taggedAnnotations(Class<? extends Annotation> tagType) {
        Set<Annotation> tagged = this.tagAnnotations.get(tagType);
        return null == tagged ? new Annotation[]{} : tagged.toArray(new Annotation[tagged.size()]);
    }

    public BeanSpec toList() {
        return new BeanSpec(this, (Type)((Object)ArrayList.class));
    }

    public <T extends Annotation> T getAnnotation(Class<T> annoClass) {
        return (T)this.allAnnotations.get(annoClass);
    }

    public boolean hasAnnotation(Class<? extends Annotation> annoClass) {
        return this.allAnnotations.containsKey(annoClass);
    }

    public boolean hasAnnotation() {
        return !this.allAnnotations.isEmpty();
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.modifiers);
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.modifiers);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.modifiers);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.modifiers);
    }

    public boolean isInterface() {
        return this.rawType().isInterface();
    }

    BeanSpec rawTypeSpec() {
        return BeanSpec.of(this.rawType(), this.injector);
    }

    boolean isMap() {
        return Map.class.isAssignableFrom(this.rawType());
    }

    MapKey mapKey() {
        return this.mapKey;
    }

    boolean isProvider() {
        return Provider.class.isAssignableFrom(this.rawType());
    }

    BeanSpec toProvidee() {
        return new BeanSpec(this, ((ParameterizedType)this.type).getActualTypeArguments()[0]);
    }

    public BeanSpec withoutName() {
        return new BeanSpec(this, (String)null);
    }

    BeanSpec withoutQualifiers() {
        if (this.qualifiers.isEmpty()) {
            return this;
        }
        BeanSpec spec = this.withoutName();
        spec.qualifiers.clear();
        return spec;
    }

    public List<Type> typeParams() {
        if (null == this.typeParams) {
            if (this.type instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)$.cast((Object)this.type);
                Object[] ta = ptype.getActualTypeArguments();
                this.typeParams = C.listOf((Object[])ta);
            } else {
                this.typeParams = C.list();
            }
        }
        return this.typeParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanSpec componentSpec() {
        if (!this.componentSpecSet) {
            BeanSpec beanSpec = this;
            synchronized (beanSpec) {
                if (!this.componentSpecSet) {
                    this.componentSpecSet = true;
                    if (this.isArray()) {
                        this.componentSpec = BeanSpec.of(this.rawType.getComponentType(), this.injector);
                    } else {
                        List<Type> typeParams = this.typeParams();
                        if (!typeParams.isEmpty()) {
                            this.componentSpec = BeanSpec.of(typeParams.get(0), this.injector);
                        }
                    }
                }
            }
        }
        return this.componentSpec;
    }

    public boolean isInstanceOf(Class c) {
        return c.isAssignableFrom(this.rawType());
    }

    public boolean isInstance(Object o) {
        Class c = this.rawType();
        if (c.isInstance(o)) {
            return true;
        }
        Class p = $.primitiveTypeOf((Class)c);
        if (null != p && p.isInstance(o)) {
            return true;
        }
        Class w = $.wrapperClassOf((Class)c);
        return null != w && w.isInstance(o);
    }

    public boolean hasInjectDecorator() {
        return !this.annoData.isEmpty() || !this.injectTags.isEmpty();
    }

    public Set<Annotation> qualifiers() {
        return new HashSet<Annotation>(this.qualifiers);
    }

    public BeanSpec parent() {
        return BeanSpec.of(this.rawType().getGenericSuperclass(), this.injector());
    }

    public boolean isObject() {
        return Object.class == this.rawType();
    }

    public boolean isNotObject() {
        return Object.class != this.rawType();
    }

    Constructor getDeclaredConstructor() {
        try {
            return this.rawType().getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new InjectException(e, "cannot instantiate %s", this.rawType);
        }
    }

    Method[] getDeclaredMethods() {
        return this.rawType().getDeclaredMethods();
    }

    public BeanSpec field(String name) {
        return this.fields().get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, BeanSpec> fields() {
        if (null != this.fields) {
            return this.fields;
        }
        BeanSpec beanSpec = this;
        synchronized (beanSpec) {
            if (null == this.fields) {
                HashMap<String, BeanSpec> map = new HashMap<String, BeanSpec>();
                for (BeanSpec spec : this.fields((Lang.Predicate<Field>)Lang.F.yes())) {
                    map.put(spec.name, spec);
                    if (spec.originalName == spec.name) continue;
                    map.put(spec.originalName, spec);
                }
                this.fields = Collections.unmodifiableMap(map);
            }
        }
        return this.fields;
    }

    public List<BeanSpec> nonStaticFields() {
        return this.fields(NON_STATIC_FIELD);
    }

    public List<BeanSpec> fields(Lang.Predicate<Field> filter) {
        ArrayList<BeanSpec> retVal = new ArrayList<BeanSpec>();
        TypeVariable<Class<T>>[] typeDeclarations = this.rawType().getTypeParameters();
        for (BeanSpec current = this; null != current && current.isNotObject(); current = current.parent()) {
            Type[] fieldTypeParams = null;
            HashMap<String, Type> typeParamsMapping = new HashMap<String, Type>();
            for (Field field : current.rawType().getDeclaredFields()) {
                int i;
                if (!filter.test((Object)field)) continue;
                Type fieldGenericType = field.getGenericType();
                if (fieldGenericType instanceof ParameterizedType) {
                    TypeVariable<Class<T>>[] classTypeParams;
                    if (null == fieldTypeParams && (fieldTypeParams = ((ParameterizedType)fieldGenericType).getActualTypeArguments()) != null && fieldTypeParams.length > 0 && (classTypeParams = current.rawType().getTypeParameters()) != null && classTypeParams.length > 0) {
                        List<Type> classTypeImpls = current.typeParams();
                        for (i = 0; i < classTypeParams.length && i < classTypeImpls.size(); ++i) {
                            TypeVariable classTypeParam = classTypeParams[i];
                            if (!(classTypeParam instanceof TypeVariable)) continue;
                            typeParamsMapping.put(classTypeParam.getName(), classTypeImpls.get(i));
                        }
                    }
                    boolean updated = false;
                    if (!typeParamsMapping.isEmpty()) {
                        for (i = 0; i < fieldTypeParams.length; ++i) {
                            String name;
                            Type typeImpl;
                            Type typeArg = fieldTypeParams[i];
                            if (!(typeArg instanceof TypeVariable) || null == (typeImpl = (Type)typeParamsMapping.get(name = ((TypeVariable)typeArg).getName())) || !$.ne((Object)typeImpl, (Object)typeArg)) continue;
                            updated = true;
                            fieldTypeParams[i] = typeImpl;
                        }
                    }
                    if (updated) {
                        fieldGenericType = new ParameterizedTypeImpl(fieldTypeParams, ((ParameterizedType)fieldGenericType).getOwnerType(), ((ParameterizedType)fieldGenericType).getRawType());
                    }
                    retVal.add(this.beanSpecOf(field, fieldGenericType));
                    continue;
                }
                if (fieldGenericType instanceof TypeVariable) {
                    boolean added = false;
                    for (i = typeDeclarations.length - 1; i >= 0; --i) {
                        if (!typeDeclarations[i].equals(fieldGenericType)) continue;
                        fieldGenericType = this.typeParams().get(i);
                        retVal.add(this.beanSpecOf(field, fieldGenericType));
                        added = true;
                        break;
                    }
                    if (added) continue;
                    throw new InjectException("Cannot infer field type: " + field, new Object[0]);
                }
                retVal.add(BeanSpec.of(field, this.injector()));
            }
        }
        return retVal;
    }

    private BeanSpec beanSpecOf(Field field, Type genericType) {
        return BeanSpec.of(field, genericType, this.injector);
    }

    boolean hasElementLoader() {
        return !this.elementLoaders.isEmpty();
    }

    boolean hasValueLoader() {
        return null != this.valueLoader;
    }

    Set<Annotation> loaders() {
        return this.elementLoaders;
    }

    Set<Annotation> filters() {
        return this.filters;
    }

    Set<Annotation> transformers() {
        return this.transformers;
    }

    Set<Annotation> postProcessors() {
        return this.postProcessors;
    }

    Annotation valueLoader() {
        return this.valueLoader;
    }

    Class<? extends Annotation> scope() {
        return this.scope;
    }

    BeanSpec scope(Class<? extends Annotation> scopeAnno) {
        this.scope = scopeAnno;
        return this;
    }

    void makeFieldAccessible() {
        E.illegalStateIf((null == this.field ? 1 : 0) != 0);
        this.field.setAccessible(true);
    }

    void setField(Object bean, Object value) {
        E.illegalStateIf((null == this.field ? 1 : 0) != 0);
        try {
            this.field.set(bean, value);
        }
        catch (Exception e) {
            throw new InjectException(e, "Unable to inject field value on %s", bean.getClass());
        }
    }

    boolean notConstructable() {
        Class c = this.rawType();
        return c.isInterface() || c.isArray() || Modifier.isAbstract(c.getModifiers());
    }

    private void resolveTypeAnnotations(Injector injector) {
        for (Annotation annotation : this.rawType().getAnnotations()) {
            this.resolveScope(annotation, injector);
            Class<? extends Annotation> annoType = annotation.annotationType();
            if (annoType == Named.class) {
                this.name = ((Named)annotation).value();
            } else if (injector.isQualifier(annoType)) {
                this.qualifiers.add(annotation);
            }
            this.allAnnotations.put(annotation.annotationType(), annotation);
            this.storeTagAnnotation(annotation);
        }
    }

    private void resolveAnnotations(Annotation[] aa, Injector injector) {
        if (null == aa || aa.length == 0) {
            return;
        }
        Class rawType = this.rawType();
        boolean isMap = Map.class.isAssignableFrom(rawType);
        boolean isContainer = isMap || Collection.class.isAssignableFrom(rawType) || rawType.isArray();
        Annotation mapKey = null;
        ArrayList<Annotation> loadValueIncompatibles = new ArrayList<Annotation>();
        for (Annotation anno : aa) {
            Class<? extends Annotation> cls = anno.annotationType();
            Annotation prev = this.allAnnotations.put(cls, anno);
            if (null == prev || anno != prev) {
                this.storeTagAnnotation(anno);
            }
            if (Inject.class == cls || Provides.class == cls) {
                this.injectTags.add(new AnnoData(anno));
                continue;
            }
            boolean isInjectTag = this.tagAnnotations.containsKey(InjectTag.class);
            if (isInjectTag) {
                this.injectTags.add(new AnnoData(anno));
            }
            if (cls == MapKey.class) {
                if (null != mapKey) {
                    throw new InjectException("MapKey annotation already presented", new Object[0]);
                }
                if (!isMap) {
                    Genie.logger.warn("MapKey annotation ignored on target that is not of Map type");
                } else {
                    mapKey = (MapKey)$.cast((Object)anno);
                }
            }
            if (LoadValue.class == cls || cls.isAnnotationPresent(LoadValue.class)) {
                this.valueLoader = anno;
                continue;
            }
            if (LoadCollection.class == cls || cls.isAnnotationPresent(LoadCollection.class)) {
                if (isContainer) {
                    this.elementLoaders.add(anno);
                    loadValueIncompatibles.add(anno);
                    continue;
                }
                Genie.logger.warn("LoadCollection annotation[%s] ignored as target type is neither Collection nor Map", new Object[]{cls.getSimpleName()});
                continue;
            }
            if (Named.class == cls) {
                this.name = ((Named)anno).value();
                continue;
            }
            if (injector.isQualifier(cls)) {
                this.qualifiers.add(anno);
                loadValueIncompatibles.add(anno);
                continue;
            }
            if (Filter.class == cls || cls.isAnnotationPresent(Filter.class)) {
                if (isContainer) {
                    this.filters.add(anno);
                    loadValueIncompatibles.add(anno);
                    continue;
                }
                Genie.logger.warn("Filter annotation[%s] ignored as target type is neither Collection nor Map", new Object[]{cls.getSimpleName()});
                continue;
            }
            if (Transform.class == cls || cls.isAnnotationPresent(Transform.class)) {
                this.transformers.add(anno);
                continue;
            }
            if (injector.isPostConstructProcessor(cls)) {
                this.postProcessors.add(anno);
                this.annotations.put(cls, anno);
                continue;
            }
            this.resolveScope(anno, injector);
        }
        if (isMap && this.hasElementLoader() && null == mapKey) {
            throw new InjectException("No MapKey annotation found on Map type target with ElementLoader annotation presented", new Object[0]);
        }
        if (isContainer && null == this.valueLoader && this.elementLoaders.isEmpty()) {
            Class<Object> rawType0;
            if (rawType.isArray()) {
                rawType0 = rawType.getComponentType();
            } else {
                List<Type> typeParams = this.typeParams();
                if (typeParams.isEmpty()) {
                    rawType0 = Object.class;
                } else {
                    Type theType = typeParams.get(isMap ? 1 : 0);
                    rawType0 = BeanSpec.rawTypeOf(theType);
                }
            }
            if (!$.isSimpleType(rawType0)) {
                TypeOf typeOfAnno = AnnotationUtil.createAnnotation(TypeOf.class);
                this.elementLoaders.add(typeOfAnno);
                loadValueIncompatibles.add(typeOfAnno);
            }
        }
        if (null != this.valueLoader) {
            if (!loadValueIncompatibles.isEmpty()) {
                throw new InjectException("ValueLoader annotation cannot be used with ElementLoader and Filter annotations: %s", this.annotations);
            }
            this.annotations.put(this.valueLoader.annotationType(), this.valueLoader);
            this.annoData.add(new AnnoData(this.valueLoader));
        } else {
            for (Annotation anno : loadValueIncompatibles) {
                this.annotations.put(anno.annotationType(), anno);
                this.annoData.add(new AnnoData(anno));
            }
            if (null != mapKey) {
                if (this.hasElementLoader()) {
                    this.mapKey = mapKey;
                    this.annotations.put(mapKey.annotationType(), mapKey);
                    this.annoData.add(new AnnoData(mapKey));
                } else {
                    Genie.logger.warn("MapKey annotation ignored on target without ElementLoader annotation presented");
                }
            }
        }
    }

    private void storeTagAnnotation(Annotation anno) {
        Annotation[] tags;
        Class<? extends Annotation> annoType = anno.annotationType();
        for (Annotation tag : tags = annoType.getAnnotations()) {
            Class<? extends Annotation> tagType = tag.annotationType();
            if (WAIVE_TAG_TYPES.contains(tagType)) continue;
            Set<Annotation> tagged = this.tagAnnotations.get(tagType);
            if (null == tagged) {
                tagged = new HashSet<Annotation>();
                this.tagAnnotations.put(tagType, tagged);
            }
            tagged.add(anno);
        }
    }

    private void resolveScope(Annotation annotation, Injector injector) {
        if (this.stopInheritedScope) {
            return;
        }
        Class<? extends Annotation> annoClass = annotation.annotationType();
        if (injector.isInheritedScopeStopper(annoClass)) {
            this.stopInheritedScope = true;
            this.scope = null;
        } else if (injector.isScope(annoClass)) {
            if (null != this.scope) {
                Class<? extends Annotation> newScope = injector.scopeByAlias(annoClass);
                if (newScope != this.scope) {
                    throw new InjectException("Incompatible scope annotation found: %s", this);
                }
            } else {
                this.scope = injector.scopeByAlias(annoClass);
            }
        }
    }

    private int calcHashCode() {
        return $.hc((Object)this.type, (Object)this.name, this.annoData);
    }

    private BeanSpec setField(Field field) {
        this.field = field;
        return this;
    }

    public static BeanSpec of(Class<?> clazz, Injector injector) {
        return new BeanSpec(clazz, null, null, injector, 0);
    }

    public static BeanSpec of(Type type, Injector injector) {
        return new BeanSpec(type, null, null, injector, 0);
    }

    public static BeanSpec of(Type type, Annotation[] paramAnnotations, Injector injector) {
        return new BeanSpec(type, paramAnnotations, null, injector, 0);
    }

    public static BeanSpec of(Type type, Annotation[] paramAnnotations, Injector injector, int modifiers) {
        return new BeanSpec(type, paramAnnotations, null, injector, modifiers);
    }

    public static BeanSpec of(Type type, Annotation[] paramAnnotations, String name, Injector injector) {
        return new BeanSpec(type, paramAnnotations, name, injector, 0);
    }

    public static BeanSpec of(Type type, Annotation[] paramAnnotations, String name, Injector injector, int modifiers) {
        return new BeanSpec(type, paramAnnotations, name, injector, modifiers);
    }

    public static BeanSpec of(Field field, Injector injector) {
        Annotation[] annotations = field.getDeclaredAnnotations();
        Class<?> fieldType = field.getGenericType();
        if (fieldType instanceof TypeVariable) {
            fieldType = field.getType();
        }
        return BeanSpec.of(fieldType, annotations, field.getName(), injector, field.getModifiers()).setField(field);
    }

    private static BeanSpec of(Field field, Type realType, Injector injector) {
        Annotation[] annotations = field.getDeclaredAnnotations();
        return BeanSpec.of(realType, annotations, field.getName(), injector, field.getModifiers()).setField(field);
    }

    public static Class<?> rawTypeOf(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        throw E.unexpected((String)"type not recognized: %s", (Object[])new Object[]{type});
    }

    private static class AnnoData {
        private Class<? extends Annotation> annoClass;
        private Map<String, Object> data;
        private static Set<String> standardsAnnotationMethods = C.set((Collection)C.list((Object)"equals", (Object[])new String[]{"hashCode", "toString", "annotationType", "getClass"}));

        AnnoData(Annotation annotation) {
            this.annoClass = annotation.annotationType();
            this.data = AnnoData.evaluate(annotation);
        }

        public int hashCode() {
            return $.hc(this.annoClass, this.data);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof AnnoData) {
                AnnoData that = (AnnoData)obj;
                return $.eq(this.annoClass, that.annoClass) && $.eq(this.data, that.data);
            }
            return false;
        }

        private static Map<String, Object> evaluate(Annotation anno) {
            Method[] ma;
            HashMap<String, Object> properties = new HashMap<String, Object>();
            Class<? extends Annotation> annoClass = anno.annotationType();
            for (Method m : ma = annoClass.getMethods()) {
                if (AnnoData.isStandardAnnotationMethod(m) || AnnoData.shouldIgnore(m)) continue;
                properties.put(m.getName(), $.invokeVirtual((Object)anno, (Method)m, (Object[])new Object[0]));
            }
            return properties;
        }

        private static boolean isStandardAnnotationMethod(Method m) {
            return standardsAnnotationMethods.contains(m.getName());
        }

        private static boolean shouldIgnore(Method method) {
            Annotation[] aa;
            for (Annotation a : aa = method.getDeclaredAnnotations()) {
                if (!AnnoData.shouldIgnore(a)) continue;
                return true;
            }
            return false;
        }

        private static boolean shouldIgnore(Annotation annotation) {
            return annotation.annotationType().getName().endsWith("Nonbinding");
        }
    }
}

