/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.http.util;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.osgl.http.H;
import org.osgl.http.HttpConfig;
import org.osgl.util.E;
import org.osgl.util.FastStr;
import org.osgl.util.ListBuilder;
import org.osgl.util.S;

public enum Path {


    public static boolean isFullUrl(String path) {
        return path.startsWith("http:") || path.startsWith("https:");
    }

    public static boolean isAbsoluteUrl(String path) {
        return Path.isFullUrl(path) || path.startsWith("//");
    }

    public static String url(String path) {
        if (Path.isAbsoluteUrl(path)) {
            return path;
        }
        StringBuilder sb = S.builder((String)HttpConfig.contextPath());
        if (!path.startsWith("/")) {
            sb.append("/");
        }
        return sb.append(path).toString();
    }

    public static String url(String path, H.Request req) {
        if (null == req) {
            return Path.url(path);
        }
        if (Path.isAbsoluteUrl(path)) {
            return path;
        }
        String ctx = req.contextPath();
        StringBuilder sb = S.builder();
        if (!"/".equals(ctx)) {
            sb.append(ctx);
        }
        if (!path.startsWith("/")) {
            sb.append("/");
        }
        return sb.append(path).toString();
    }

    public static String fullUrl(String path) {
        return Path.fullUrl(path, HttpConfig.secure());
    }

    public static String fullUrl(String path, boolean secure) {
        String ctx;
        if (Path.isFullUrl(path)) {
            return path;
        }
        StringBuilder sb = S.builder((String)(secure ? "https://" : "http://"));
        sb.append(HttpConfig.domain());
        if (secure) {
            if (443 != HttpConfig.securePort()) {
                sb.append(":").append(HttpConfig.securePort());
            }
        } else if (80 != HttpConfig.nonSecurePort()) {
            sb.append(":").append(HttpConfig.nonSecurePort());
        }
        if (!path.startsWith("//") && S.notBlank((String)(ctx = HttpConfig.contextPath())) && !"/".equals(ctx)) {
            sb.append(ctx);
        }
        if (!path.startsWith("/")) {
            sb.append("/");
        }
        sb.append(path);
        return sb.toString();
    }

    public static String fullUrl(String path, H.Request req) {
        String ctx;
        if (null == req) {
            return Path.fullUrl(path, false);
        }
        if (Path.isFullUrl(path)) {
            return path;
        }
        boolean secure = req.scheme().equals("https");
        StringBuilder sb = S.builder((String)req.scheme()).append("://");
        sb.append(req.domain());
        int reqPort = req.port();
        if (secure) {
            if (443 != reqPort) {
                sb.append(":").append(reqPort);
            }
        } else if (80 != reqPort) {
            sb.append(":").append(reqPort);
        }
        if (!path.startsWith("//") && !"/".equals(ctx = req.contextPath())) {
            sb.append(req.contextPath());
        }
        if (!path.startsWith("/")) {
            sb.append("/");
        }
        sb.append(path);
        return sb.toString();
    }

    public static Iterator<CharSequence> tokenizer(char[] buf) {
        return Path.tokenizer(buf, 0);
    }

    public static Iterator<CharSequence> tokenizer(char[] buf, int start) {
        return Path.tokenizer(buf, start, '/', '?');
    }

    public static Iterator<CharSequence> tokenizer(final char[] buf, final int start, final char separator, final char terminator) {
        return new Iterator<CharSequence>(){
            int cursor;
            final int len;
            int begin;
            {
                this.cursor = start;
                this.len = buf.length;
                this.begin = -1;
            }

            @Override
            public boolean hasNext() {
                char c;
                while (this.cursor < this.len && (c = buf[this.cursor]) == separator) {
                    ++this.cursor;
                }
                return this.cursor < this.len && buf[this.cursor] != terminator;
            }

            @Override
            public CharSequence next() {
                for (int i = this.cursor; i < this.len; ++i) {
                    char c = buf[i];
                    if (c == terminator) {
                        this.cursor = this.len;
                        return FastStr.unsafeOf((char[])buf, (int)this.begin, (int)i);
                    }
                    if (c == separator) {
                        if (this.begin > -1) {
                            FastStr ret = FastStr.unsafeOf((char[])buf, (int)this.begin, (int)i);
                            this.cursor = i + 1;
                            this.begin = -1;
                            return ret;
                        }
                    } else if (this.begin == -1) {
                        this.begin = i;
                    }
                    if (i != this.len - 1 || this.begin == -1) continue;
                    this.cursor = this.len;
                    return FastStr.unsafeOf((char[])buf, (int)this.begin, (int)(i + 1));
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw E.unsupport();
            }
        };
    }

    public static List<CharSequence> tokenize(char[] buf) {
        return Path.tokenize(buf, 0);
    }

    public static List<CharSequence> tokenize(char[] buf, int start) {
        return Path.tokenize(buf, start, '/', '?');
    }

    public static List<CharSequence> tokenize(char[] buf, int start, char separator, char terminator) {
        int len = buf.length;
        ListBuilder lb = ListBuilder.create();
        int begin = -1;
        for (int i = start; i < len; ++i) {
            char c = buf[i];
            if (c == terminator) {
                lb.add((Object)FastStr.unsafeOf((char[])buf, (int)begin, (int)i));
                break;
            }
            if (c == separator) {
                if (begin > -1) {
                    lb.add((Object)FastStr.unsafeOf((char[])buf, (int)begin, (int)i));
                }
                begin = -1;
            } else if (begin == -1) {
                begin = i;
            }
            if (i != len - 1 || begin == -1) continue;
            lb.add((Object)FastStr.unsafeOf((char[])buf, (int)begin, (int)(i + 1)));
        }
        return lb.toList();
    }
}

