/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.logging;

import org.osgl.$;
import org.osgl.Lang;
import org.osgl.logging.LogService;
import org.osgl.logging.LogServiceProvider;
import org.osgl.logging.Logger;
import org.osgl.logging.service.JDKLogService;
import org.osgl.util.S;

public class LogManager {
    private static LogServiceProvider userFact = null;
    private static final LogServiceProvider fact;
    private static volatile Logger def;

    LogManager() {
    }

    public static Logger get(Class<?> clazz) {
        return new Proxy(clazz.getName());
    }

    public static Logger get(String name) {
        return new Proxy(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Logger def() {
        if (null != def) return def;
        Class<LogManager> clazz = LogManager.class;
        synchronized (LogManager.class) {
            if (null != def) return def;
            def = LogManager.get(Object.class);
            // ** MonitorExit[var0] (shouldn't be in output)
            return def;
        }
    }

    public static void registerLogServiceProvider(LogServiceProvider fact) {
        LogManager.reset();
        userFact = fact;
    }

    public static void reset() {
        userFact = null;
        def = null;
    }

    public static boolean isTraceEnabled() {
        return LogManager.def().isTraceEnabled();
    }

    public static void trace(String msg) {
        LogManager.def().trace(msg);
    }

    public static void trace(String format, Object ... args) {
        LogManager.def().trace(format, args);
    }

    public static void trace(Throwable t, String msg) {
        LogManager.def().trace(t, msg);
    }

    public static void trace(Throwable t, String format, Object ... args) {
        LogManager.def().trace(t, format, args);
    }

    public static boolean isDebugEnabled() {
        return LogManager.def().isDebugEnabled();
    }

    public static void debug(String msg) {
        LogManager.def().debug(msg);
    }

    public static void debug(String format, Object ... args) {
        LogManager.def().debug(format, args);
    }

    public static void debug(Throwable t, String msg) {
        LogManager.def().debug(t, msg);
    }

    public static void debug(Throwable t, String format, Object ... args) {
        LogManager.def().debug(t, format, args);
    }

    public static boolean isInfoEnabled() {
        return LogManager.def().isInfoEnabled();
    }

    public static void info(String msg) {
        LogManager.def().info(msg);
    }

    public static void info(String format, Object ... args) {
        LogManager.def().info(format, args);
    }

    public static void info(Throwable t, String msg) {
        LogManager.def().info(t, msg);
    }

    public static void info(Throwable t, String format, Object ... args) {
        LogManager.def().info(t, format, args);
    }

    public static boolean isWarnEnabled() {
        return LogManager.def().isWarnEnabled();
    }

    public static void warn(String msg) {
        LogManager.def().warn(msg);
    }

    public static void warn(String format, Object ... args) {
        LogManager.def().warn(format, args);
    }

    public static void warn(Throwable t, String msg) {
        LogManager.def().warn(t, msg);
    }

    public static void warn(Throwable t, String format, Object ... args) {
        LogManager.def().warn(t, format, args);
    }

    public static boolean isErrorEnabled() {
        return LogManager.def().isErrorEnabled();
    }

    public static void error(String msg) {
        LogManager.def().error(msg);
    }

    public static void error(String format, Object ... args) {
        LogManager.def().error(format, args);
    }

    public static void error(Throwable t, String msg) {
        LogManager.def().error(t, msg);
    }

    public static void error(Throwable t, String format, Object ... args) {
        LogManager.def().error(t, format, args);
    }

    public static void fatal(String msg) {
        LogManager.def().fatal(msg);
    }

    public static void fatal(String format, Object ... args) {
        LogManager.def().fatal(format, args);
    }

    public static void fatal(Throwable t, String msg) {
        LogManager.def().fatal(t, msg);
    }

    public static void fatal(Throwable t, String format, Object ... args) {
        LogManager.def().fatal(t, format, args);
    }

    static {
        String FQCN = LogManager.class.getName();
        try {
            userFact = (LogServiceProvider)$.newInstance((String)"org.osgl.logging.service.LogbackServiceProvider");
            userFact.getLogService(FQCN);
        }
        catch (Throwable e) {
            userFact = null;
        }
        if (null == userFact) {
            try {
                userFact = (LogServiceProvider)$.newInstance((String)"org.osgl.logging.service.Log4jServiceProvider");
                userFact.getLogService(FQCN);
            }
            catch (Throwable e) {
                userFact = null;
            }
        }
        if (null == userFact) {
            try {
                userFact = (LogServiceProvider)$.newInstance((String)"org.osgl.logging.service.TinyLogServiceProvider");
                userFact.getLogService(FQCN);
            }
            catch (Throwable e) {
                userFact = null;
            }
        }
        if (null == userFact) {
            try {
                userFact = (LogServiceProvider)$.newInstance((String)"org.osgl.logging.service.Slf4jServiceProvider");
                userFact.getLogService(FQCN);
            }
            catch (Throwable e) {
                userFact = null;
            }
        }
        if (null == userFact) {
            try {
                userFact = (LogServiceProvider)$.newInstance((String)"org.osgl.logging.service.CommonsLoggingServiceProvider");
                userFact.getLogService(FQCN);
            }
            catch (Throwable e) {
                userFact = null;
            }
        }
        fact = new LogServiceProvider(){
            private LogServiceProvider defFact = new JDKLogService.Factory();

            @Override
            public LogService getLogService(String name) {
                return null == userFact ? this.defFact.getLogService(name) : userFact.getLogService(name);
            }
        };
        def = null;
    }

    private static class Proxy
    implements Logger {
        private Class<?> c_;
        private String nm_;
        private volatile LogService l_;
        private Level trace = new Level(){

            @Override
            public boolean isEnabled() {
                return Proxy.this.isTraceEnabled();
            }

            public void visit(String s) throws Lang.Break {
                Proxy.this.impl().trace(s);
            }

            @Override
            public void visit(Throwable t, String msg) {
                Proxy.this.impl().trace(t, msg);
            }
        };
        private Level debug = new Level(){

            @Override
            public boolean isEnabled() {
                return Proxy.this.isDebugEnabled();
            }

            public void visit(String s) throws Lang.Break {
                Proxy.this.impl().debug(s);
            }

            @Override
            public void visit(Throwable t, String msg) {
                Proxy.this.impl().debug(t, msg);
            }
        };
        private Level info = new Level(){

            @Override
            public boolean isEnabled() {
                return Proxy.this.isInfoEnabled();
            }

            public void visit(String s) throws Lang.Break {
                Proxy.this.impl().info(s);
            }

            @Override
            public void visit(Throwable t, String msg) {
                Proxy.this.impl().info(t, msg);
            }
        };
        private Level warn = new Level(){

            @Override
            public boolean isEnabled() {
                return Proxy.this.isWarnEnabled();
            }

            public void visit(String s) throws Lang.Break {
                Proxy.this.impl().warn(s);
            }

            @Override
            public void visit(Throwable t, String msg) {
                Proxy.this.impl().warn(t, msg);
            }
        };
        private Level error = new Level(){

            @Override
            public boolean isEnabled() {
                return Proxy.this.isErrorEnabled();
            }

            public void visit(String s) throws Lang.Break {
                Proxy.this.impl().error(s);
            }

            @Override
            public void visit(Throwable t, String msg) {
                Proxy.this.impl().error(t, msg);
            }
        };
        private Level fatal = new Level(){

            @Override
            public boolean isEnabled() {
                return true;
            }

            public void visit(String s) throws Lang.Break {
                Proxy.this.impl().fatal(s);
            }

            @Override
            public void visit(Throwable t, String msg) {
                Proxy.this.impl().fatal(t, msg);
            }
        };

        Proxy(String name) {
            this.nm_ = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LogService impl() {
            if (null == this.l_) {
                Proxy proxy = this;
                synchronized (proxy) {
                    if (null == this.l_) {
                        this.l_ = fact.getLogService(this.nm_);
                    }
                }
            }
            return this.l_;
        }

        @Override
        public void setLevel(Logger.Level level) {
            this.impl().setLevel(level);
        }

        @Override
        public boolean isTraceEnabled() {
            return this.impl().isTraceEnabled();
        }

        private void log(Level level, String msg) {
            assert (null != level);
            if (level.isEnabled()) {
                level.visit(msg);
            }
        }

        private void log(Level level, String format, Object ... args) {
            try {
                if (null == level) {
                    return;
                }
                if (level.isEnabled()) {
                    String msg = S.fmt((String)format, (Object[])args);
                    level.visit(msg);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }

        private void log(Level level, Throwable t, String msg) {
            if (level.isEnabled()) {
                level.visit(t, msg);
            }
        }

        private void log(Level level, Throwable t, String format, Object ... args) {
            try {
                if (null == level) {
                    return;
                }
                if (level.isEnabled()) {
                    String msg = S.fmt((String)format, (Object[])args);
                    level.visit(t, msg);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }

        @Override
        public void trace(String msg) {
            this.log(this.trace, msg);
        }

        @Override
        public void trace(String format, Object ... args) {
            this.log(this.trace, format, args);
        }

        @Override
        public void trace(Throwable t, String msg) {
            this.log(this.trace, t, msg);
        }

        @Override
        public void trace(Throwable t, String format, Object ... args) {
            this.log(this.trace, t, format, args);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.impl().isDebugEnabled();
        }

        @Override
        public void debug(String msg) {
            this.log(this.debug, msg);
        }

        @Override
        public void debug(String format, Object ... args) {
            this.log(this.debug, format, args);
        }

        @Override
        public void debug(Throwable t, String msg) {
            this.log(this.debug, t, msg);
        }

        @Override
        public void debug(Throwable t, String format, Object ... args) {
            this.log(this.debug, t, format, args);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.impl().isInfoEnabled();
        }

        @Override
        public void info(String msg) {
            this.log(this.info, msg);
        }

        @Override
        public void info(String format, Object ... args) {
            this.log(this.info, format, args);
        }

        @Override
        public void info(Throwable t, String msg) {
            this.log(this.info, t, msg);
        }

        @Override
        public void info(Throwable t, String format, Object ... args) {
            this.log(this.info, t, format, args);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.impl().isWarnEnabled();
        }

        @Override
        public void warn(String msg) {
            this.log(this.warn, msg);
        }

        @Override
        public void warn(String format, Object ... args) {
            this.log(this.warn, format, args);
        }

        @Override
        public void warn(Throwable t, String msg) {
            this.log(this.warn, t, msg);
        }

        @Override
        public void warn(Throwable t, String format, Object ... args) {
            this.log(this.warn, t, format, args);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.impl().isErrorEnabled();
        }

        @Override
        public void error(String msg) {
            this.log(this.error, msg);
        }

        @Override
        public void error(String format, Object ... args) {
            this.log(this.error, format, args);
        }

        @Override
        public void error(Throwable t, String msg) {
            this.log(this.error, t, msg);
        }

        @Override
        public void error(Throwable t, String format, Object ... args) {
            this.log(this.error, t, format, args);
        }

        @Override
        public void fatal(String msg) {
            this.log(this.fatal, msg);
        }

        @Override
        public void fatal(String format, Object ... args) {
            this.log(this.fatal, format, args);
        }

        @Override
        public void fatal(Throwable t, String msg) {
            this.log(this.fatal, t, msg);
        }

        @Override
        public void fatal(Throwable t, String format, Object ... args) {
            this.log(this.fatal, t, format, args);
        }

        private abstract class Level
        extends Lang.Visitor<String> {
            private Level() {
            }

            public abstract void visit(Throwable var1, String var2);

            public abstract boolean isEnabled();
        }
    }
}

