/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.logging.service;

import org.osgl.logging.LogService;
import org.osgl.logging.Logger;
import org.osgl.util.E;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLogger;

public class Slf4jService
implements LogService {
    protected final Logger logger;
    private Logger.Level level;

    public Slf4jService(Class clazz) {
        this.logger = LoggerFactory.getLogger((Class)clazz);
        this.ensureLogger();
    }

    public Slf4jService(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
        this.ensureLogger();
    }

    @Override
    public void setLevel(Logger.Level level) {
        this.level = level;
    }

    @Override
    public boolean isTraceEnabled() {
        return null != this.level && this.level.isTraceEnabled() || this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String msg) {
        if (this.isTraceEnabled()) {
            this.logger.trace(msg);
        }
    }

    @Override
    public void trace(Throwable t, String msg) {
        if (this.isTraceEnabled()) {
            this.logger.trace(msg, t);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return null != this.level && this.level.isDebugEnabled() || this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            this.logger.debug(msg);
        }
    }

    @Override
    public void debug(Throwable t, String msg) {
        if (this.isDebugEnabled()) {
            this.logger.debug(msg, t);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return null != this.level && this.level.isInfoEnabled() || this.logger.isInfoEnabled();
    }

    @Override
    public void info(String msg) {
        if (this.isInfoEnabled()) {
            this.logger.info(msg);
        }
    }

    @Override
    public void info(Throwable t, String msg) {
        if (this.isInfoEnabled()) {
            this.logger.info(msg, t);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return null != this.level && this.level.isWarnEnabled() || this.logger.isWarnEnabled();
    }

    @Override
    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            this.logger.warn(msg);
        }
    }

    @Override
    public void warn(Throwable t, String msg) {
        if (this.isWarnEnabled()) {
            this.logger.warn(msg, t);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return null != this.level && this.level.isErrorEnabled() || this.logger.isErrorEnabled();
    }

    @Override
    public void error(String msg) {
        if (this.isErrorEnabled()) {
            this.logger.error(msg);
        }
    }

    @Override
    public void error(Throwable t, String msg) {
        if (this.isErrorEnabled()) {
            this.logger.error(msg, t);
        }
    }

    @Override
    public void fatal(String msg) {
        this.logger.error(msg);
    }

    @Override
    public void fatal(Throwable t, String msg) {
        this.logger.error(msg, t);
    }

    private void ensureLogger() {
        E.illegalStateIf((boolean)(this.logger instanceof NOPLogger), (String)"cannot initialize Slf4jService");
    }
}

