/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.logging.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgl.logging.LogService;
import org.osgl.logging.Logger;

public class CommonsLoggingService
implements LogService {
    protected final Log logger;
    private Logger.Level level;

    public CommonsLoggingService(Class<?> clz) {
        this.logger = LogFactory.getLog(clz);
    }

    public CommonsLoggingService(String name) {
        this.logger = LogFactory.getLog((String)name);
    }

    @Override
    public void setLevel(Logger.Level level) {
        this.level = level;
    }

    @Override
    public boolean isTraceEnabled() {
        return null != this.level && this.level.isTraceEnabled() || this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String msg) {
        if (this.isTraceEnabled()) {
            this.logger.trace((Object)msg);
        }
    }

    @Override
    public void trace(Throwable t, String msg) {
        if (this.isTraceEnabled()) {
            this.logger.trace((Object)msg, t);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return null != this.level && this.level.isDebugEnabled() || this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            this.logger.debug((Object)msg);
        }
    }

    @Override
    public void debug(Throwable t, String msg) {
        if (this.isDebugEnabled()) {
            this.logger.debug((Object)msg, t);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return null != this.level && this.level.isInfoEnabled() || this.logger.isInfoEnabled();
    }

    @Override
    public void info(String msg) {
        if (this.isInfoEnabled()) {
            this.logger.info((Object)msg);
        }
    }

    @Override
    public void info(Throwable t, String msg) {
        if (this.isInfoEnabled()) {
            this.logger.info((Object)msg, t);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return null != this.level && this.level.isWarnEnabled() || this.logger.isWarnEnabled();
    }

    @Override
    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            this.logger.warn((Object)msg);
        }
    }

    @Override
    public void warn(Throwable t, String msg) {
        if (this.isWarnEnabled()) {
            this.logger.warn((Object)msg, t);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return null != this.level && this.level.isErrorEnabled() || this.logger.isErrorEnabled();
    }

    @Override
    public void error(String msg) {
        if (this.isErrorEnabled()) {
            this.logger.error((Object)msg);
        }
    }

    @Override
    public void error(Throwable t, String msg) {
        if (this.isErrorEnabled()) {
            this.logger.error((Object)msg, t);
        }
    }

    @Override
    public void fatal(String msg) {
        this.logger.fatal((Object)msg);
    }

    @Override
    public void fatal(Throwable t, String msg) {
        this.logger.fatal((Object)msg, t);
    }
}

