/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.storage.impl;

import com.qiniu.common.QiniuException;
import com.qiniu.common.Zone;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.FileInfo;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.osgl.$;
import org.osgl.exception.AccessDeniedException;
import org.osgl.exception.ResourceNotFoundException;
import org.osgl.storage.ISObject;
import org.osgl.storage.IStorageService;
import org.osgl.storage.impl.KodoObject;
import org.osgl.storage.impl.StorageServiceBase;
import org.osgl.util.E;
import org.osgl.util.S;

public class KodoService
extends StorageServiceBase<KodoObject>
implements IStorageService {
    public static final String CONF_ACCESS_KEY = "storage.kodo.access.key";
    public static final String CONF_SECRET_KEY = "storage.kodo.secret.key";
    public static final String CONF_BUCKET = "storage.kodo.bucket";
    public static final String CONF_PERMISSION = "storage.kodo.bucket.permission";
    public static final String CONF_DOMAIN = "storage.kodo.domain";
    public static final String BUCKET_PUB = "public";
    public static final String BUCKET_PRI = "private";
    private static OkHttpClient httpClient;
    private String bucket;
    private String permission;
    private String domain;
    private BucketManager bucketManager;
    private UploadManager uploadManager;
    private Auth auth;

    public KodoService(Map<String, String> conf) {
        super(conf, KodoObject.class);
    }

    @Override
    protected void configure(Map<String, String> conf) {
        super.configure(conf, "kodo");
        String accessKey = conf.get(CONF_ACCESS_KEY);
        String secretKey = conf.get(CONF_SECRET_KEY);
        if (S.isAnyEmpty((String[])new String[]{accessKey, secretKey})) {
            E.invalidConfiguration((String)"Kodo accessKey or Kodo secretKey not found in the configuration", (Object[])new Object[0]);
        }
        this.bucket = conf.get(CONF_BUCKET);
        if (S.isEmpty((String)this.bucket)) {
            E.invalidConfiguration((String)"Kodo bucket not found in the configuration", (Object[])new Object[0]);
        }
        this.domain = conf.get(CONF_DOMAIN);
        if (S.isEmpty((String)this.domain)) {
            E.invalidConfiguration((String)"Kodo domain not found in the configuration", (Object[])new Object[0]);
        }
        this.permission = conf.get(CONF_PERMISSION);
        if (S.notBlank((String)this.permission) && !S.eq((String)this.permission, (String)BUCKET_PUB) && !S.eq((String)this.permission, (String)BUCKET_PRI)) {
            E.invalidConfiguration((String)"The permission fields need 'public' or 'private'", (Object[])new Object[0]);
        }
        this.auth = Auth.create((String)accessKey, (String)secretKey);
        Configuration c = new Configuration(Zone.autoZone());
        this.bucketManager = new BucketManager(this.auth, c);
        this.uploadManager = new UploadManager(c);
        httpClient = new OkHttpClient();
    }

    @Override
    protected void doRemove(String fullPath) {
        try {
            this.bucketManager.delete(this.bucket, fullPath);
        }
        catch (QiniuException e) {
            throw KodoService.handleException(fullPath, e);
        }
    }

    @Override
    protected Map<String, String> doGetMeta(String fullPath) {
        try {
            FileInfo stat = this.bucketManager.stat(this.bucket, fullPath);
            return (Map)$.copy((Object)stat).to(Map.class);
        }
        catch (QiniuException e) {
            throw KodoService.handleException(fullPath, e);
        }
    }

    @Override
    protected InputStream doGetInputStream(String fullPath) {
        String baseUrl = S.msgFmt((String)"http://{0}/{1}", (Object[])new Object[]{this.domain, fullPath});
        if (this.isPrivate(this.permission)) {
            baseUrl = this.auth.privateDownloadUrl(baseUrl);
        }
        Request req = new Request.Builder().url(baseUrl).build();
        try {
            Response resp = httpClient.newCall(req).execute();
            if (resp.isSuccessful()) {
                return Objects.requireNonNull(resp.body()).byteStream();
            }
            switch (resp.code()) {
                case 404: {
                    throw new ResourceNotFoundException(fullPath);
                }
                case 403: {
                    throw new AccessDeniedException(fullPath);
                }
            }
            throw E.unexpected((String)"Error accessing %s: %s", (Object[])new Object[]{fullPath, resp.body().string()});
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
    }

    private boolean isPrivate(String permission) {
        return S.eq((String)BUCKET_PRI, (String)permission);
    }

    private String getUploadToken() {
        return this.auth.uploadToken(this.bucket);
    }

    @Override
    protected void doPut(String fullPath, ISObject stuff, Map<String, String> attrs) {
        StringMap meta = new StringMap();
        for (String k : attrs.keySet()) {
            meta.putNotEmpty(k, attrs.get(k));
        }
        String contentType = stuff.getAttribute("content-type");
        try {
            this.uploadManager.put(stuff.asInputStream(), fullPath, this.getUploadToken(), meta, contentType);
        }
        catch (QiniuException e) {
            throw KodoService.handleException(fullPath, e);
        }
    }

    @Override
    protected ISObject newSObject(String key) {
        return new KodoObject(key, this);
    }

    @Override
    protected StorageServiceBase newService(Map<String, String> conf) {
        return new KodoService(conf);
    }

    private static RuntimeException handleException(String key, QiniuException e) {
        switch (e.code()) {
            case 404: {
                throw new ResourceNotFoundException((Throwable)e, key, new Object[0]);
            }
            case 403: {
                throw new AccessDeniedException((Throwable)e, key, new Object[0]);
            }
        }
        throw E.unexpected((String)key, (Object[])new Object[0]);
    }
}

