/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.storage.impl;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.GetObjectTaggingRequest;
import com.amazonaws.services.s3.model.GetObjectTaggingResult;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.ObjectTagging;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.Tag;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgl.exception.AccessDeniedException;
import org.osgl.exception.ResourceNotFoundException;
import org.osgl.storage.ISObject;
import org.osgl.storage.IStorageService;
import org.osgl.storage.impl.S3Obj;
import org.osgl.storage.impl.SObject;
import org.osgl.storage.impl.StorageServiceBase;
import org.osgl.util.E;
import org.osgl.util.S;

public class S3Service
extends StorageServiceBase<S3Obj>
implements IStorageService {
    public static final String CONF_KEY_ID = "storage.s3.keyId";
    public static final String CONF_KEY_SECRET = "storage.s3.keySecret";
    public static final String CONF_DEF_STORAGE_CLASS = "storage.s3.defStorageClass";
    public static final String CONF_BUCKET = "storage.s3.bucket";
    public static final String CONF_MAX_ERROR_RETRY = "storage.s3.maxErrorRetry";
    public static final String CONF_CONN_TIMEOUT = "storage.s3.connectionTimeout";
    public static final String CONF_SOCKET_TIMEOUT = "storage.s3.socketTimeout";
    public static final String CONF_TCP_KEEP_ALIVE = "storage.s3.tcpKeepAlive";
    public static final String CONF_MAX_CONN = "storage.s3.maxConnection";
    @Deprecated
    public static final String CONF_S3_GET_NO_GET = "storage.s3.get.noGet";
    @Deprecated
    public static final String CONF_S3_GET_META_ONLY = "storage.s3.get.MetaOnly";
    @Deprecated
    public static final String CONF_S3_STATIC_WEB_ENDPOINT = "storage.s3.staticWebEndpoint";
    public static final String ATTR_STORAGE_CLASS = "x-amz-storage-class";
    private String awsKeyId;
    private String awsKeySecret;
    private StorageClass defStorageClass;
    private String bucket;
    public static AmazonS3 s3;

    public S3Service(Map<String, String> conf) {
        super(conf, S3Obj.class);
    }

    @Override
    protected void configure(Map<String, String> conf) {
        int n;
        String sc;
        super.configure(conf, "s3");
        this.awsKeyId = conf.get(CONF_KEY_ID);
        this.awsKeySecret = conf.get(CONF_KEY_SECRET);
        if (null == this.awsKeySecret || null == this.awsKeyId) {
            E.invalidConfiguration((String)"AWS Key ID or AWS Key Secret not found in the configuration", (Object[])new Object[0]);
        }
        this.defStorageClass = null != (sc = conf.get(CONF_DEF_STORAGE_CLASS)) ? StorageClass.valueOfIgnoreCase(sc, this.defStorageClass) : StorageClass.REDUCED_REDUNDANCY;
        this.bucket = conf.get(CONF_BUCKET);
        if (null == this.bucket) {
            E.invalidConfiguration((String)"AWS bucket not found in the configuration", (Object[])new Object[0]);
        }
        System.setProperty("line.separator", "\n");
        BasicAWSCredentials cred = new BasicAWSCredentials(this.awsKeyId, this.awsKeySecret);
        ClientConfiguration cc = new ClientConfiguration();
        if (conf.containsKey(CONF_MAX_ERROR_RETRY)) {
            n = Integer.parseInt(conf.get(CONF_MAX_ERROR_RETRY));
            cc = cc.withMaxErrorRetry(n);
        }
        if (conf.containsKey(CONF_CONN_TIMEOUT)) {
            n = Integer.parseInt(conf.get(CONF_CONN_TIMEOUT));
            cc = cc.withConnectionTimeout(n);
        }
        if (conf.containsKey(CONF_MAX_CONN)) {
            n = Integer.parseInt(conf.get(CONF_MAX_CONN));
            cc = cc.withMaxConnections(n);
        }
        if (conf.containsKey(CONF_TCP_KEEP_ALIVE)) {
            boolean b = Boolean.parseBoolean(conf.get(CONF_TCP_KEEP_ALIVE));
            cc = cc.withTcpKeepAlive(b);
        }
        if (conf.containsKey(CONF_SOCKET_TIMEOUT)) {
            n = Integer.parseInt(conf.get(CONF_SOCKET_TIMEOUT));
            cc = cc.withSocketTimeout(n);
        }
        s3 = new AmazonS3Client((AWSCredentials)cred, cc);
    }

    @Override
    protected void doRemove(String fullPath) {
        try {
            s3.deleteObject(new DeleteObjectRequest(this.bucket, fullPath));
        }
        catch (AmazonS3Exception e) {
            throw S3Service.handleException(fullPath, e);
        }
    }

    @Override
    protected ISObject newSObject(String key) {
        try {
            return new S3Obj(key, this);
        }
        catch (AmazonS3Exception e) {
            throw S3Service.handleException(key, e);
        }
    }

    @Override
    protected Map<String, String> doGetMeta(String fullPath) {
        GetObjectTaggingRequest req0 = new GetObjectTaggingRequest(this.bucket, fullPath);
        GetObjectTaggingResult resp = s3.getObjectTagging(req0);
        return S3Service.tagListToMap(resp.getTagSet());
    }

    @Override
    protected InputStream doGetInputStream(String fullPath) {
        GetObjectRequest req = new GetObjectRequest(this.bucket, fullPath);
        S3Object s3obj = s3.getObject(req);
        return s3obj.getObjectContent();
    }

    @Override
    protected void doPut(String fullPath, ISObject stuff, Map<String, String> attrs) {
        long length;
        ObjectMetadata meta = new ObjectMetadata();
        meta.setUserMetadata(attrs);
        if (!(stuff instanceof SObject.InputStreamSObject) && 0L < (length = stuff.getLength())) {
            meta.setContentLength(stuff.getLength());
        }
        PutObjectRequest req = new PutObjectRequest(this.bucket, fullPath, stuff.asInputStream(), meta);
        req.setTagging(S3Service.mapToTagList(attrs));
        StorageClass storageClass = StorageClass.valueOfIgnoreCase(attrs.remove(ATTR_STORAGE_CLASS), this.defStorageClass);
        if (null != storageClass) {
            req.setStorageClass(storageClass.toString());
        }
        req.withCannedAcl(CannedAccessControlList.PublicRead);
        try {
            s3.putObject(req);
        }
        catch (AmazonS3Exception e) {
            throw S3Service.handleException(fullPath, e);
        }
    }

    private static ObjectTagging mapToTagList(Map<String, String> map) {
        ArrayList<Tag> list = new ArrayList<Tag>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            list.add(new Tag(entry.getKey(), S3Service.replaceSpecialCharacters(entry.getValue())));
        }
        return new ObjectTagging(list);
    }

    private static Map<String, String> tagListToMap(List<Tag> tagging) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Tag tag : tagging) {
            map.put(tag.getKey(), tag.getValue());
        }
        return map;
    }

    private static AmazonS3Exception handleException(String key, AmazonS3Exception e) {
        int status = e.getStatusCode();
        switch (status) {
            case 404: {
                throw new ResourceNotFoundException((Throwable)e, key, new Object[0]);
            }
            case 403: {
                throw new AccessDeniedException((Throwable)e, key, new Object[0]);
            }
        }
        throw e;
    }

    @Override
    protected StorageServiceBase newService(Map conf) {
        return new S3Service(conf);
    }

    private static String replaceSpecialCharacters(String s) {
        boolean changed = false;
        char[] ca = s.toCharArray();
        for (int i = ca.length - 1; i >= 0; --i) {
            char c = ca[i];
            if (S3Service.isValid(c)) continue;
            ca[i] = 32;
            changed = true;
        }
        return changed ? new String(ca) : s;
    }

    private static boolean isValid(char c) {
        if (c >= '0' && c <= '9') {
            return true;
        }
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        switch (c) {
            case '.': 
            case '/': {
                return true;
            }
        }
        return false;
    }

    public static enum StorageClass {
        STANDARD,
        REDUCED_REDUNDANCY,
        GLACIER;


        public static StorageClass valueOfIgnoreCase(String s, StorageClass def) {
            if (S.blank((String)s)) {
                return def;
            }
            if ("r".equalsIgnoreCase(s = s.trim()) || "rrs".equalsIgnoreCase(s) || "rr".equalsIgnoreCase(s) || "reduced_redundancy".equalsIgnoreCase(s) || "reducedRedundancy".equalsIgnoreCase(s)) {
                return REDUCED_REDUNDANCY;
            }
            if ("glacier".equalsIgnoreCase(s) || "g".equalsIgnoreCase(s)) {
                return GLACIER;
            }
            if ("s".equalsIgnoreCase(s) || "standard".equalsIgnoreCase(s)) {
                return STANDARD;
            }
            return def;
        }
    }
}

