/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.storage.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.nio.charset.Charset;
import org.osgl.exception.UnexpectedIOException;
import org.osgl.storage.ISObject;
import org.osgl.storage.impl.SObject;
import org.osgl.storage.impl.StorageServiceBase;
import org.osgl.util.IO;

public class StorageObject<TYPE extends StorageObject, SVC extends StorageServiceBase<TYPE>>
extends SObject {
    protected transient SVC svc;
    private SoftReference<byte[]> cache;
    protected transient ISObject buf;

    StorageObject(String key, SVC svc) {
        super(key);
        this.svc = svc;
        this.setAttributes(((StorageServiceBase)svc).getMeta(key));
    }

    public long getLength() {
        byte[] ba;
        String s = this.getAttribute("length");
        if (null != s) {
            return Long.parseLong(s);
        }
        if (null != this.cache && null != (ba = this.cache.get())) {
            return ba.length;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISObject buf() {
        if (null == this.buf) {
            StorageObject storageObject = this;
            synchronized (storageObject) {
                if (null == this.buf) {
                    this.buf = this.loadBuf();
                    if (!this.buf.isValid()) {
                        this.setCause(this.buf.getException());
                    }
                }
            }
        }
        return this.buf;
    }

    protected ISObject loadBuf() {
        SObject sobj = SObject.of((byte[])this.read());
        sobj.setAttributes(this.getAttributes());
        return sobj;
    }

    public File asFile() throws UnexpectedIOException {
        return this.buf().asFile();
    }

    public String asString() throws UnexpectedIOException {
        return this.buf().asString();
    }

    public String asString(Charset charset) throws UnexpectedIOException {
        return this.buf().asString(charset);
    }

    public byte[] asByteArray() throws UnexpectedIOException {
        return this.buf().asByteArray();
    }

    public InputStream asInputStream() throws UnexpectedIOException {
        return ((StorageServiceBase)this.svc).getInputStream(this.getKey());
    }

    private synchronized byte[] read() {
        byte[] ba;
        if (null != this.cache && null != (ba = this.cache.get())) {
            return ba;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream is = ((StorageServiceBase)this.svc).getInputStream(this.getKey());
        IO.copy((InputStream)is, (OutputStream)baos);
        byte[] ba2 = baos.toByteArray();
        this.cache = new SoftReference<byte[]>(ba2);
        return ba2;
    }
}

