/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.storage.spring;

import java.util.Map;
import org.osgl.storage.IStorageService;
import org.osgl.storage.KeyGenerator;
import org.osgl.storage.impl.S3Service;
import org.osgl.storage.spring.StorageServiceConfigurer;
import org.osgl.storage.spring.StorageServiceConfigurerBase;
import org.osgl.util.C;
import org.osgl.util.E;
import org.springframework.stereotype.Component;

@Component
public class S3ServiceConfigurer
extends StorageServiceConfigurerBase
implements StorageServiceConfigurer {
    private String awsKeyId;
    private String awsKeySecret;
    private S3Service.StorageClass defStorageClass;
    private String bucket;
    private String staticWebEndPoint = null;
    private boolean getMetaOnly = false;
    private boolean noGet = false;

    public void setAwsKeyId(String awsKeyId) {
        E.NPE((Object)awsKeyId);
        this.awsKeyId = awsKeyId;
    }

    public void setAwsKeySecret(String awsKeySecret) {
        E.NPE((Object)awsKeySecret);
        this.awsKeySecret = awsKeySecret;
    }

    public void setDefStorageClass(S3Service.StorageClass defStorageClass) {
        E.NPE((Object)((Object)defStorageClass));
        this.defStorageClass = defStorageClass;
    }

    public void setBucket(String bucket) {
        E.NPE((Object)bucket);
        this.bucket = bucket;
    }

    public void setStaticWebEndPoint(String staticWebEndPoint) {
        E.NPE((Object)staticWebEndPoint);
        this.staticWebEndPoint = staticWebEndPoint;
    }

    public void setGetMetaOnly(boolean getMetaOnly) {
        this.getMetaOnly = getMetaOnly;
    }

    public void setNoGet(boolean noGet) {
        this.noGet = noGet;
    }

    @Override
    public IStorageService getStorageService() {
        C.Map conf = C.Map((Object[])new Object[]{"storage.s3.keyId", this.awsKeyId, "storage.s3.keySecret", this.awsKeySecret, "storage.s3.defStorageClass", this.defStorageClass, "storage.s3.bucket", this.bucket, "storage.get.MetaOnly", this.getMetaOnly, "storage.get.noGet", this.noGet});
        S3Service ss = new S3Service((Map<String, String>)conf);
        KeyGenerator keyGenerator = this.getKeyGenerator();
        if (null != keyGenerator) {
            ss.setKeyGenerator(keyGenerator);
        }
        return ss;
    }
}

